/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.org.apache.maven.wagon.shared.http.HttpMethodConfiguration;

public class ConfigurationUtils {
    public static void copyConfig(HttpMethodConfiguration config, RequestConfig.Builder builder2) {
        Properties params;
        if (config.getConnectionTimeout() > 0) {
            builder2.setConnectTimeout(config.getConnectionTimeout());
        }
        if (config.getReadTimeout() > 0) {
            builder2.setSocketTimeout(config.getReadTimeout());
        }
        if ((params = config.getParams()) != null) {
            Pattern coercePattern = Pattern.compile("%(\\w+),(.+)");
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                Matcher matcher2 = coercePattern.matcher(value2);
                if (matcher2.matches()) {
                    value2 = matcher2.group(2);
                }
                if (key.equals("http.socket.timeout")) {
                    builder2.setSocketTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals("http.connection.stalecheck")) {
                    builder2.setStaleConnectionCheckEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals("http.connection.timeout")) {
                    builder2.setConnectTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals("http.protocol.expect-continue")) {
                    builder2.setExpectContinueEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals("http.route.default-proxy")) {
                    builder2.setProxy(HttpHost.create(value2));
                    continue;
                }
                if (key.equals("http.route.local-address")) {
                    try {
                        builder2.setLocalAddress(InetAddress.getByName(value2));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    continue;
                }
                if (key.equals("http.auth.proxy-scheme-pref")) {
                    builder2.setProxyPreferredAuthSchemes(Arrays.asList(value2.split(",")));
                    continue;
                }
                if (key.equals("http.auth.target-scheme-pref")) {
                    builder2.setTargetPreferredAuthSchemes(Arrays.asList(value2.split(",")));
                    continue;
                }
                if (key.equals("http.protocol.handle-authentication")) {
                    builder2.setAuthenticationEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals("http.protocol.allow-circular-redirects")) {
                    builder2.setCircularRedirectsAllowed(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals("http.conn-manager.timeout")) {
                    builder2.setConnectionRequestTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals("http.protocol.cookie-policy")) {
                    builder2.setCookieSpec(value2);
                    continue;
                }
                if (key.equals("http.protocol.max-redirects")) {
                    builder2.setMaxRedirects(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals("http.protocol.handle-redirects")) {
                    builder2.setRedirectsEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals("http.protocol.reject-relative-redirect")) {
                    builder2.setRelativeRedirectsAllowed(Boolean.valueOf(value2) == false);
                    continue;
                }
                if (key.equals("http.protocol.handle-content-compression")) {
                    builder2.setContentCompressionEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (!key.equals("http.protocol.handle-uri-normalization")) continue;
                builder2.setNormalizeUri(Boolean.valueOf(value2));
            }
        }
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration defaults, HttpMethodConfiguration base2, HttpMethodConfiguration local) {
        HttpMethodConfiguration result2 = ConfigurationUtils.merge(defaults, base2);
        return ConfigurationUtils.merge(result2, local);
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base2, HttpMethodConfiguration local) {
        if (base2 == null && local == null) {
            return null;
        }
        if (base2 == null) {
            return local;
        }
        if (local == null) {
            return base2;
        }
        HttpMethodConfiguration result2 = base2.copy();
        if (local.getConnectionTimeout() != 60000) {
            result2.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getReadTimeout() != 1800000) {
            result2.setReadTimeout(local.getReadTimeout());
        }
        if (local.getHeaders() != null) {
            result2.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result2.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result2.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result2;
    }
}

