/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.List;
import java.util.Objects;
import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystem;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectResult;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyCollectionException;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyFilter;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyVisitor;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.DependencyCollector;
import org.jetbrains.kotlin.org.eclipse.aether.impl.Deployer;
import org.jetbrains.kotlin.org.eclipse.aether.impl.Installer;
import org.jetbrains.kotlin.org.eclipse.aether.impl.LocalRepositoryProvider;
import org.jetbrains.kotlin.org.eclipse.aether.impl.MetadataResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.SyncContextFactory;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionResolver;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    @Override
    public void initService(ServiceLocator locator) {
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session2);
        return this.artifactResolver.resolveArtifact(session2, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session2, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session2);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result2 = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result2.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session2, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result2.setRoot(collectResult.getRoot());
            result2.setCycles(collectResult.getCycles());
            result2.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new NullPointerException("dependency node and collect request cannot be null");
        }
        ArtifactRequestBuilder builder2 = new ArtifactRequestBuilder(trace);
        DependencyFilter filter2 = request.getFilter();
        DependencyVisitor visitor2 = filter2 != null ? new FilteringDependencyVisitor(builder2, filter2) : builder2;
        visitor2 = new TreeDependencyVisitor(visitor2);
        if (result2.getRoot() != null) {
            result2.getRoot().accept(visitor2);
        }
        List<ArtifactRequest> requests = builder2.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session2, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result2.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result2, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result2, (Throwable)are);
        }
        return result2;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result2 : results) {
            Artifact artifact = result2.getArtifact();
            if (artifact == null) continue;
            result2.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session2, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session2, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void validateSession(RepositorySystemSession session2) {
        Objects.requireNonNull(session2, "repository system session cannot be null");
        this.invalidSession(session2.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session2.getSystemProperties(), "system properties");
        this.invalidSession(session2.getUserProperties(), "user properties");
        this.invalidSession(session2.getConfigProperties(), "config properties");
        this.invalidSession(session2.getMirrorSelector(), "mirror selector");
        this.invalidSession(session2.getProxySelector(), "proxy selector");
        this.invalidSession(session2.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session2.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session2.getData(), "data");
    }

    private void invalidSession(Object obj, String name2) {
        Objects.requireNonNull(obj, "repository system session's " + name2 + " cannot be null");
    }
}

