/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.io.Serializable;
import org.jetbrains.kotlin.org.jdom.AttributeType;
import org.jetbrains.kotlin.org.jdom.CloneBase;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.IllegalDataException;
import org.jetbrains.kotlin.org.jdom.IllegalNameException;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Verifier;

public class Attribute
extends CloneBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 200L;
    public static final AttributeType UNDECLARED_TYPE = AttributeType.UNDECLARED;
    public static final AttributeType CDATA_TYPE = AttributeType.CDATA;
    public static final AttributeType ID_TYPE = AttributeType.ID;
    public static final AttributeType IDREF_TYPE = AttributeType.IDREF;
    public static final AttributeType IDREFS_TYPE = AttributeType.IDREFS;
    public static final AttributeType ENTITY_TYPE = AttributeType.ENTITY;
    public static final AttributeType ENTITIES_TYPE = AttributeType.ENTITIES;
    public static final AttributeType NMTOKEN_TYPE = AttributeType.NMTOKEN;
    public static final AttributeType NMTOKENS_TYPE = AttributeType.NMTOKENS;
    public static final AttributeType NOTATION_TYPE = AttributeType.NOTATION;
    public static final AttributeType ENUMERATED_TYPE = AttributeType.ENUMERATION;
    protected String name;
    protected Namespace namespace;
    protected String value;
    protected AttributeType type = AttributeType.UNDECLARED;
    protected boolean specified = true;
    protected transient Element parent;

    protected Attribute() {
    }

    public Attribute(String name2, String value2, AttributeType type2, Namespace namespace) {
        this.setName(name2);
        this.setValue(value2);
        this.setAttributeType(type2);
        this.setNamespace(namespace);
    }

    public Element getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String name2) {
        if (name2 == null) {
            throw new NullPointerException("Can not set a null name for an Attribute.");
        }
        String reason = Verifier.checkAttributeName(name2);
        if (reason != null) {
            throw new IllegalNameException(name2, "attribute", reason);
        }
        this.name = name2;
        this.specified = true;
        return this;
    }

    public String getQualifiedName() {
        String prefix = this.namespace.getPrefix();
        if ("".equals(prefix)) {
            return this.getName();
        }
        return prefix + ':' + this.getName();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Attribute setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (namespace != Namespace.NO_NAMESPACE && "".equals(namespace.getPrefix())) {
            throw new IllegalNameException("", "attribute namespace", "An attribute namespace without a prefix can only be the NO_NAMESPACE namespace");
        }
        this.namespace = namespace;
        this.specified = true;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String value2) {
        if (value2 == null) {
            throw new NullPointerException("Can not set a null value for an Attribute");
        }
        String reason = Verifier.checkCharacterData(value2);
        if (reason != null) {
            throw new IllegalDataException(value2, "attribute", reason);
        }
        this.value = value2;
        this.specified = true;
        return this;
    }

    public Attribute setAttributeType(AttributeType type2) {
        this.type = type2 == null ? AttributeType.UNDECLARED : type2;
        this.specified = true;
        return this;
    }

    public String toString() {
        return "[Attribute: " + this.getQualifiedName() + "=\"" + this.value + "\"" + "]";
    }

    @Override
    public Attribute clone() {
        Attribute clone = (Attribute)super.clone();
        clone.parent = null;
        return clone;
    }

    protected Attribute setParent(Element parent2) {
        this.parent = parent2;
        return this;
    }
}

