/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.builtins.Completers;
import org.jline.builtins.Options;
import org.jline.console.AbstractCommandRegistry;
import org.jline.console.ArgDesc;
import org.jline.console.CmdDesc;
import org.jline.console.CommandRegistry;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.utils.AttributedString;

public abstract class JlineCommandRegistry
extends AbstractCommandRegistry {
    public List<String> commandInfo(String command2) {
        try {
            Object[] args2 = new Object[]{"--help"};
            if (command2.equals("help")) {
                args2 = new Object[]{};
            }
            this.invoke(new CommandRegistry.CommandSession(), command2, args2);
        }
        catch (Options.HelpException e) {
            return JlineCommandRegistry.compileCommandInfo(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("JlineCommandRegistry.commandInfo() method must be overridden in class " + this.getClass().getCanonicalName());
    }

    public CmdDesc commandDescription(String command2) {
        try {
            this.invoke(new CommandRegistry.CommandSession(), command2, "--help");
        }
        catch (Options.HelpException e) {
            return JlineCommandRegistry.compileCommandDescription(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("JlineCommandRegistry.commandDescription() method must be overridden in class " + this.getClass().getCanonicalName());
    }

    public List<Completers.OptDesc> commandOptions(String command2) {
        try {
            this.invoke(new CommandRegistry.CommandSession(), command2, "--help");
        }
        catch (Options.HelpException e) {
            return JlineCommandRegistry.compileCommandOptions(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<Completer> defaultCompleter(String command2) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    public Options parseOptions(String[] usage, Object[] args2) throws Options.HelpException {
        Options opt = Options.compile(usage).parse(args2);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        return opt;
    }

    private static AttributedString highlightComment(String comment) {
        return Options.HelpException.highlightComment(comment, Options.HelpException.defaultStyle());
    }

    private static String[] helpLines(String helpMessage, boolean body2) {
        return new HelpLines(helpMessage, body2).lines();
    }

    protected static CmdDesc compileCommandDescription(String helpMessage) {
        ArrayList<AttributedString> main2 = new ArrayList<AttributedString>();
        HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
        String prevOpt = null;
        boolean mainDone = false;
        HelpLines hl = new HelpLines(helpMessage, true);
        for (String s : hl.lines()) {
            int ind;
            if (s.matches("^\\s+-.*$")) {
                mainDone = true;
                ind = s.lastIndexOf("  ");
                if (ind > 0) {
                    String o = s.substring(0, ind);
                    String d = s.substring(ind);
                    if (o.trim().length() > 0) {
                        prevOpt = o.trim();
                        options.put(prevOpt, new ArrayList<AttributedString>(Arrays.asList(JlineCommandRegistry.highlightComment(d.trim()))));
                    }
                }
            } else if (s.matches("^[\\s]{20}.*$") && prevOpt != null && options.containsKey(prevOpt)) {
                ind = s.lastIndexOf("  ");
                if (ind > 0) {
                    ((List)options.get(prevOpt)).add(JlineCommandRegistry.highlightComment(s.substring(ind).trim()));
                }
            } else {
                prevOpt = null;
            }
            if (mainDone) continue;
            main2.add(Options.HelpException.highlightSyntax(s.trim(), Options.HelpException.defaultStyle(), hl.subcommands()));
        }
        return new CmdDesc(main2, ArgDesc.doArgNames(Arrays.asList("")), options);
    }

    protected static List<Completers.OptDesc> compileCommandOptions(String helpMessage) {
        ArrayList<Completers.OptDesc> out = new ArrayList<Completers.OptDesc>();
        for (String s : JlineCommandRegistry.helpLines(helpMessage, true)) {
            int ind;
            if (!s.matches("^\\s+-.*$") || (ind = s.lastIndexOf("  ")) <= 0) continue;
            String[] op = s.substring(0, ind).trim().split("\\s+");
            String d = s.substring(ind).trim();
            String so = null;
            String lo = null;
            if (op.length == 1) {
                if (op[0].startsWith("--")) {
                    lo = op[0];
                } else {
                    so = op[0];
                }
            } else {
                so = op[0];
                lo = op[1];
            }
            boolean hasValue = false;
            if (lo != null && lo.contains("=")) {
                hasValue = true;
                lo = lo.split("=")[0];
            }
            out.add(new Completers.OptDesc(so, lo, d, hasValue ? Completers.AnyCompleter.INSTANCE : null));
        }
        return out;
    }

    protected static List<String> compileCommandInfo(String helpMessage) {
        ArrayList<String> out = new ArrayList<String>();
        boolean first2 = true;
        for (String s : JlineCommandRegistry.helpLines(helpMessage, false)) {
            if (first2 && s.contains(" - ")) {
                out.add(s.substring(s.indexOf(" - ") + 3).trim());
            } else {
                out.add(s.trim());
            }
            first2 = false;
        }
        return out;
    }

    private static class HelpLines {
        private String helpMessage;
        private boolean body;
        private boolean subcommands;

        public HelpLines(String helpMessage, boolean body2) {
            this.helpMessage = helpMessage;
            this.body = body2;
        }

        public String[] lines() {
            String out = "";
            Matcher tm = Pattern.compile("(^|\\n)(Usage|Summary)(:)").matcher(this.helpMessage);
            if (tm.find()) {
                this.subcommands = tm.group(2).matches("Summary");
                out = this.body ? this.helpMessage.substring(tm.end(3)) : this.helpMessage.substring(0, tm.start(1));
            } else if (!this.body) {
                out = this.helpMessage;
            }
            return out.split("\\r?\\n");
        }

        public boolean subcommands() {
            return this.subcommands;
        }
    }
}

