/*
 * Decompiled with CFR 0.152.
 */
package afu.org.checkerframework.checker.regex;

import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.regex.qual.Regex;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import afu.org.checkerframework.framework.qual.EnsuresQualifierIf;
import afu.org.checkerframework.framework.qual.EnsuresQualifiersIf;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexUtil {
    private RegexUtil() {
        throw new AssertionError((Object)"Class RegexUtil shouldn't be instantiated");
    }

    @Pure
    @EnsuresQualifiersIf(value={@EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)})
    public static boolean isRegex(String s) {
        return RegexUtil.isRegex(s, 0);
    }

    @Pure
    public static boolean isRegex(String s, int groups2) {
        Pattern p;
        try {
            p = Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups2;
    }

    @Pure
    @EnsuresQualifiersIf(value={@EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)})
    public static boolean isRegex(char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Nullable String regexError(String s) {
        return RegexUtil.regexError(s, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s, int groups2) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups2) {
                return RegexUtil.regexErrorMessage(s, groups2, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s) {
        return RegexUtil.regexException(s, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s, int groups2) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups2) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s, groups2, actualGroups), s, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String s) {
        return RegexUtil.asRegex(s, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s, int groups2) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups2) {
                throw new Error(RegexUtil.regexErrorMessage(s, groups2, actualGroups));
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    private static String regexErrorMessage(String s, int expectedGroups, int actualGroups) {
        return "regex \"" + s + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p) {
        return p.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, int index2) {
            this(new PatternSyntaxException(desc, regex, index2));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        public String getMessage() {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

