/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate2, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate2;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate2, Object[] array2) {
        this(delegate2, ImmutableList.asImmutableList(array2));
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate2, Object[] array2, int size) {
        this(delegate2, ImmutableList.asImmutableList(array2, size));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index2) {
        return this.delegateList.listIterator(index2);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset2) {
        return this.delegateList.copyIntoArray(dst, offset2);
    }

    @Override
    public E get(int index2) {
        return this.delegateList.get(index2);
    }
}

