/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableValueGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N", "V"})
@Beta
public final class ImmutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V> {
    private ImmutableValueGraph(ValueGraph<N, V> graph2) {
        super(ValueGraphBuilder.from(graph2), ImmutableValueGraph.getNodeConnections(graph2), graph2.edges().size());
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph2) {
        return graph2 instanceof ImmutableValueGraph ? (ImmutableValueGraph<N, V>)graph2 : new ImmutableValueGraph<N, V>(graph2);
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> graph2) {
        return Preconditions.checkNotNull(graph2);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }

    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> graph2) {
        ImmutableMap.Builder<N, GraphConnections<N, V>> nodeConnections = ImmutableMap.builder();
        for (N node : graph2.nodes()) {
            nodeConnections.put(node, ImmutableValueGraph.connectionsOf(graph2, node));
        }
        return nodeConnections.build();
    }

    private static <N, V> GraphConnections<N, V> connectionsOf(final ValueGraph<N, V> graph2, final N node) {
        Function successorNodeToValueFn = new Function<N, V>(){

            @Override
            public V apply(N successorNode) {
                return graph2.edgeValueOrDefault(node, successorNode, null);
            }
        };
        return graph2.isDirected() ? DirectedGraphConnections.ofImmutable(graph2.predecessors(node), Maps.asMap(graph2.successors(node), successorNodeToValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph2.adjacentNodes(node), successorNodeToValueFn));
    }
}

