/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Key;
import com.google.inject.internal.ConstructionContext;
import com.google.inject.internal.CreationListener;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.internal.ProviderInternalFactory;
import com.google.inject.internal.ProvisionListenerStackCallback;
import com.google.inject.spi.Dependency;
import javax.inject.Provider;

final class BoundProviderFactory<T>
extends ProviderInternalFactory<T>
implements CreationListener {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injector, Key<? extends Provider<? extends T>> providerKey, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = provisionCallback;
        this.injector = injector;
        this.providerKey = providerKey;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(InternalContext context2, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        context2.pushState(this.providerKey, this.source);
        try {
            Provider<? extends T> provider2 = this.providerFactory.get(context2, dependency, true);
            T t = this.circularGet(provider2, context2, dependency, this.provisionCallback);
            return t;
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(this.providerKey);
        }
        finally {
            context2.popState();
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider2, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            return super.provision(provider2, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw InternalProvisionException.errorInProvider(userException);
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

