/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.handler.manager;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactHandlerManager.class)
public class DefaultArtifactHandlerManager
implements ArtifactHandlerManager {
    @Requirement(role=ArtifactHandler.class)
    private Map<String, ArtifactHandler> artifactHandlers;
    private Map<String, ArtifactHandler> allHandlers = new ConcurrentHashMap<String, ArtifactHandler>();

    @Override
    public ArtifactHandler getArtifactHandler(String type2) {
        ArtifactHandler handler2 = this.allHandlers.get(type2);
        if (handler2 == null) {
            handler2 = this.artifactHandlers.get(type2);
            if (handler2 == null) {
                handler2 = new DefaultArtifactHandler(type2);
            } else {
                this.allHandlers.put(type2, handler2);
            }
        }
        return handler2;
    }

    @Override
    public void addHandlers(Map<String, ArtifactHandler> handlers2) {
        this.allHandlers.putAll(handlers2);
    }

    @Deprecated
    public Set<String> getHandlerTypes() {
        return this.artifactHandlers.keySet();
    }
}

