/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

abstract class AbstractScopeArtifactFilter
implements ArtifactFilter {
    private boolean compileScope;
    private boolean runtimeScope;
    private boolean testScope;
    private boolean providedScope;
    private boolean systemScope;

    AbstractScopeArtifactFilter() {
    }

    void addScopeInternal(String scope2) {
        if ("compile".equals(scope2)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
        } else if ("runtime".equals(scope2)) {
            this.compileScope = true;
            this.runtimeScope = true;
        } else if ("compile+runtime".equals(scope2)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
        } else if ("runtime+system".equals(scope2)) {
            this.systemScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
        } else if ("test".equals(scope2)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        }
    }

    @Override
    public boolean include(Artifact artifact) {
        if ("compile".equals(artifact.getScope())) {
            return this.compileScope;
        }
        if ("runtime".equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if ("test".equals(artifact.getScope())) {
            return this.testScope;
        }
        if ("provided".equals(artifact.getScope())) {
            return this.providedScope;
        }
        if ("system".equals(artifact.getScope())) {
            return this.systemScope;
        }
        return true;
    }
}

