/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.DefaultMaven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.FilteredProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

@Component(role=GraphBuilder.class, hint="graphBuilder")
public class DefaultGraphBuilder
implements GraphBuilder {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;

    public Result<ProjectDependencyGraph> build(MavenSession session2) {
        try {
            Result<ProjectDependencyGraph> result2 = this.sessionDependencyGraph(session2);
            if (result2 == null) {
                List<MavenProject> projects = this.getProjectsForMavenReactor(session2);
                this.validateProjects(projects);
                result2 = this.reactorDependencyGraph(session2, projects);
            }
            return result2;
        }
        catch (MavenExecutionException | DuplicateProjectException | ProjectBuildingException e) {
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, e)));
        }
        catch (CycleDetectedException e) {
            String message2 = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message2, e);
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, error)));
        }
    }

    private Result<ProjectDependencyGraph> sessionDependencyGraph(MavenSession session2) throws CycleDetectedException, DuplicateProjectException {
        Result<DefaultProjectDependencyGraph> result2 = null;
        if (session2.getProjectDependencyGraph() != null || session2.getProjects() != null) {
            DefaultProjectDependencyGraph graph2 = new DefaultProjectDependencyGraph(session2.getAllProjects(), session2.getProjects());
            result2 = Result.success(graph2);
        }
        return result2;
    }

    private Result<ProjectDependencyGraph> reactorDependencyGraph(MavenSession session2, List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException, MavenExecutionException {
        ProjectDependencyGraph projectDependencyGraph = new DefaultProjectDependencyGraph(projects);
        List<MavenProject> activeProjects = projectDependencyGraph.getSortedProjects();
        activeProjects = this.trimSelectedProjects(activeProjects, projectDependencyGraph, session2.getRequest());
        activeProjects = this.trimExcludedProjects(activeProjects, session2.getRequest());
        if ((activeProjects = this.trimResumedProjects(activeProjects, session2.getRequest())).size() != projectDependencyGraph.getSortedProjects().size()) {
            projectDependencyGraph = new FilteredProjectDependencyGraph(projectDependencyGraph, activeProjects);
        }
        return Result.success(projectDependencyGraph);
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, ProjectDependencyGraph graph2, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result2 = projects;
        if (!request.getSelectedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getSelectedProjects()) {
                MavenProject selectedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    selectedProject = project;
                    break;
                }
                if (selectedProject != null) {
                    selectedProjects.add(selectedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty(request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                for (MavenProject selectedProject : new ArrayList(selectedProjects)) {
                    if (makeUpstream) {
                        selectedProjects.addAll(graph2.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    selectedProjects.addAll(graph2.getDownstreamProjects(selectedProject, true));
                }
            }
            result2 = new ArrayList<MavenProject>(selectedProjects.size());
            for (MavenProject project : projects) {
                if (!selectedProjects.contains(project)) continue;
                result2.add(project);
            }
        }
        return result2;
    }

    private List<MavenProject> trimExcludedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result2 = projects;
        if (!request.getExcludedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> excludedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getExcludedProjects()) {
                MavenProject excludedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    excludedProject = project;
                    break;
                }
                if (excludedProject != null) {
                    excludedProjects.add(excludedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            result2 = new ArrayList<MavenProject>(projects.size());
            for (MavenProject project : projects) {
                if (excludedProjects.contains(project)) continue;
                result2.add(project);
            }
        }
        return result2;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result2 = projects;
        if (StringUtils.isNotEmpty(request.getResumeFrom())) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            String selector = request.getResumeFrom();
            result2 = new ArrayList<MavenProject>(projects.size());
            boolean resumed = false;
            for (MavenProject project : projects) {
                if (!resumed && this.isMatchingProject(project, selector, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                result2.add(project);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + this.formatProjects(projects), request.getPom());
            }
        }
        return result2;
    }

    private String formatProjects(List<MavenProject> projects) {
        StringBuilder projectNames = new StringBuilder();
        Iterator<MavenProject> iterator2 = projects.iterator();
        while (iterator2.hasNext()) {
            MavenProject project = iterator2.next();
            projectNames.append(project.getGroupId()).append(":").append(project.getArtifactId());
            if (!iterator2.hasNext()) continue;
            projectNames.append(", ");
        }
        return projectNames.toString();
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenSession session2) throws ProjectBuildingException {
        MavenExecutionRequest request = session2.getRequest();
        request.getProjectBuildingRequest().setRepositorySession(session2.getRepositorySession());
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
            MavenProject project = this.projectBuilder.build(modelSource, request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            projects.add(project);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files2 = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files2, request);
        return projects;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files2, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files2, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result2 : results) {
            projects.add(result2.getProject());
            if (result2.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result2.getProject().getId());
            for (ModelProblem problem : result2.getProblems()) {
                String loc = ModelProblemUtils.formatLocation(problem, result2.getProjectId());
                this.logger.warn(problem.getMessage() + (StringUtils.isNotEmpty(loc) ? " @ " + loc : ""));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private void validateProjects(List<MavenProject> projects) {
        HashMap<String, MavenProject> projectsMap = new HashMap<String, MavenProject>();
        for (MavenProject p : projects) {
            String projectKey = ArtifactUtils.key(p.getGroupId(), p.getArtifactId(), p.getVersion());
            projectsMap.put(projectKey, p);
        }
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuildPlugins()) {
                String pluginKey;
                if (!plugin.isExtensions() || !projectsMap.containsKey(pluginKey = ArtifactUtils.key(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion()))) continue;
                this.logger.warn(project.getName() + " uses " + plugin.getKey() + " as extensions, which is not possible within the same reactor build. This plugin was pulled from the local repository!");
            }
        }
    }
}

