/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class Parent
implements Serializable,
Cloneable,
InputLocationTracker {
    private String groupId;
    private String artifactId;
    private String version;
    private String relativePath = "../pom.xml";
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation groupIdLocation;
    private InputLocation artifactIdLocation;
    private InputLocation versionLocation;
    private InputLocation relativePathLocation;

    public Parent clone() {
        try {
            Parent copy2 = (Parent)super.clone();
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
                case "relativePath": {
                    return this.relativePathLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    @Override
    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    this.location = location2;
                    return;
                }
                case "groupId": {
                    this.groupIdLocation = location2;
                    return;
                }
                case "artifactId": {
                    this.artifactIdLocation = location2;
                    return;
                }
                case "version": {
                    this.versionLocation = location2;
                    return;
                }
                case "relativePath": {
                    this.relativePathLocation = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        StringBuilder id = new StringBuilder(64);
        id.append(this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId());
        id.append(":");
        id.append("pom");
        id.append(":");
        id.append(this.getVersion());
        return id.toString();
    }

    public String toString() {
        return this.getId();
    }
}

