/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements TypeAwareExpressionEvaluator {
    private MavenSession session;
    private MojoExecution mojoExecution;
    private MavenProject project;
    private String basedir;
    private Properties properties;

    @Deprecated
    public PluginParameterExpressionEvaluator(MavenSession session2, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project, Properties properties2) {
        this(session2, mojoExecution);
    }

    public PluginParameterExpressionEvaluator(MavenSession session2) {
        this(session2, null);
    }

    public PluginParameterExpressionEvaluator(MavenSession session2, MojoExecution mojoExecution) {
        File projectFile;
        this.session = session2;
        this.mojoExecution = mojoExecution;
        this.properties = new Properties();
        this.project = session2.getCurrentProject();
        this.properties.putAll((Map<?, ?>)session2.getUserProperties());
        this.properties.putAll((Map<?, ?>)session2.getSystemProperties());
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getBasedir()) != null) {
            basedir = projectFile.getAbsolutePath();
        }
        if (basedir == null) {
            basedir = session2.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        this.basedir = basedir;
    }

    @Override
    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    @Override
    public Object evaluate(String expr, Class<?> type2) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value2 = null;
        if (expr == null) {
            return null;
        }
        String expression2 = this.stripTokens(expr);
        if (expression2.equals(expr)) {
            int lastIndex;
            int index2 = expr.indexOf("${");
            if (index2 >= 0 && (lastIndex = expr.indexOf(125, index2)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index2);
                retVal = index2 > 0 && expr.charAt(index2 - 1) == '$' ? retVal + expr.substring(index2 + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index2, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr.substring(index2 + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression2.contains("$$")) {
                return expression2.replaceAll("\\$\\$", "\\$");
            }
            return expression2;
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if ("localRepository".equals(expression2)) {
            value2 = this.session.getLocalRepository();
        } else if ("session".equals(expression2)) {
            value2 = this.session;
        } else if (expression2.startsWith("session")) {
            try {
                pathSeparator = expression2.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression2.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.session);
                    value2 = value2 + expression2.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression2.substring(1), this.session);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression2, e);
            }
        } else if ("reactorProjects".equals(expression2)) {
            value2 = this.session.getProjects();
        } else if ("mojoExecution".equals(expression2)) {
            value2 = this.mojoExecution;
        } else if ("project".equals(expression2)) {
            value2 = this.project;
        } else if ("executedProject".equals(expression2)) {
            value2 = this.project.getExecutionProject();
        } else if (expression2.startsWith("project") || expression2.startsWith("pom")) {
            try {
                pathSeparator = expression2.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression2.substring(0, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value2 = value2 + expression2.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression2.substring(1), this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression2, e);
            }
        } else if (expression2.equals("repositorySystemSession")) {
            value2 = this.session.getRepositorySession();
        } else if (expression2.equals("mojo")) {
            value2 = this.mojoExecution;
        } else if (expression2.startsWith("mojo")) {
            try {
                pathSeparator = expression2.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression2.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.mojoExecution);
                    value2 = value2 + expression2.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression2.substring(1), this.mojoExecution);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression2, e);
            }
        } else if (expression2.equals("plugin")) {
            value2 = mojoDescriptor.getPluginDescriptor();
        } else if (expression2.startsWith("plugin")) {
            try {
                pathSeparator = expression2.indexOf(47);
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression2.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value2 = value2 + expression2.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression2.substring(1), pluginDescriptor);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression2, e);
            }
        } else if ("settings".equals(expression2)) {
            value2 = this.session.getSettings();
        } else if (expression2.startsWith("settings")) {
            try {
                pathSeparator = expression2.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression2.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.session.getSettings());
                    value2 = value2 + expression2.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression2.substring(1), this.session.getSettings());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression2, e);
            }
        } else if ("basedir".equals(expression2)) {
            value2 = this.basedir;
        } else if (expression2.startsWith("basedir") && (pathSeparator = expression2.indexOf(47)) > 0) {
            value2 = this.basedir + expression2.substring(pathSeparator);
        }
        if (value2 != null && type2 != null && !(value2 instanceof String) && !PluginParameterExpressionEvaluator.isTypeCompatible(type2, value2)) {
            value2 = null;
        }
        if (value2 == null) {
            if (this.properties != null) {
                value2 = this.properties.getProperty(expression2);
            }
            if (value2 == null && this.project != null && this.project.getProperties() != null) {
                value2 = this.project.getProperties().getProperty(expression2);
            }
        }
        if (value2 instanceof String && (exprStartDelimiter = (val = (String)value2).indexOf("${")) >= 0) {
            value2 = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value2;
    }

    private static boolean isTypeCompatible(Class<?> type2, Object value2) {
        if (type2.isInstance(value2)) {
            return true;
        }
        return (type2.isPrimitive() || type2.getName().startsWith("java.lang.")) && value2.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf(125) == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    @Override
    public File alignToBaseDirectory(File file2) {
        if (file2 != null && !file2.isAbsolute()) {
            file2 = file2.getPath().startsWith(File.separator) ? file2.getAbsoluteFile() : new File(new File(this.basedir, file2.getPath()).toURI().normalize()).getAbsoluteFile();
        }
        return file2;
    }
}

