/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=MavenProjectHelper.class)
public class DefaultMavenProjectHelper
extends AbstractLogEnabled
implements MavenProjectHelper {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public void attachArtifact(MavenProject project, String artifactType, String artifactClassifier, File artifactFile) {
        String type2 = artifactType;
        ArtifactHandler handler2 = null;
        if (type2 != null) {
            handler2 = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler2 == null) {
            handler2 = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, artifactClassifier, handler2);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project, String artifactType, File artifactFile) {
        ArtifactHandler handler2 = this.artifactHandlerManager.getArtifactHandler(artifactType);
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, handler2);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project, File artifactFile, String artifactClassifier) {
        Artifact projectArtifact = project.getArtifact();
        AttachedArtifact artifact = new AttachedArtifact(projectArtifact, projectArtifact.getType(), artifactClassifier, projectArtifact.getArtifactHandler());
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, artifact);
    }

    public void attachArtifact(MavenProject project, Artifact artifact) {
        project.addAttachedArtifact(artifact);
    }

    @Override
    public void addResource(MavenProject project, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addResource(resource);
    }

    @Override
    public void addTestResource(MavenProject project, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addTestResource(resource);
    }
}

