/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultModelBuildingListener;
import org.apache.maven.project.DefaultProjectBuildingResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.project.ReactorModelCache;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Component(role=ProjectBuilder.class)
public class DefaultProjectBuilder
implements ProjectBuilder {
    public static final String DISABLE_GLOBAL_MODEL_CACHE_SYSTEM_PROPERTY = "maven.defaultProjectBuilder.disableGlobalModelCache";
    @Requirement
    private Logger logger;
    @Requirement
    private ModelBuilder modelBuilder;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private ProjectBuildingHelper projectBuildingHelper;
    @Requirement
    private MavenRepositorySystem repositorySystem;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private RemoteRepositoryManager repositoryManager;
    @Requirement
    private ProjectDependenciesResolver dependencyResolver;
    private final ReactorModelCache modelCache = new ReactorModelCache();

    @Override
    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(pomFile, new FileModelSource(pomFile), new InternalConfig(request, null, this.useGlobalModelCache() ? this.getModelCache() : null));
    }

    private boolean useGlobalModelCache() {
        return !Boolean.getBoolean(DISABLE_GLOBAL_MODEL_CACHE_SYSTEM_PROPERTY);
    }

    @Override
    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(null, modelSource, new InternalConfig(request, null, this.useGlobalModelCache() ? this.getModelCache() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBuildingResult build(File pomFile, ModelSource modelSource, InternalConfig config) throws ProjectBuildingException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ProjectBuildingRequest projectBuildingRequest = config.request;
            MavenProject project = projectBuildingRequest.getProject();
            List<ModelProblem> modelProblems = null;
            ModelBuildingException error = null;
            if (project == null) {
                ModelBuildingResult result2;
                ModelBuildingRequest request = this.getModelBuildingRequest(config);
                project = new MavenProject();
                project.setFile(pomFile);
                DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, this.projectBuildingHelper, projectBuildingRequest);
                request.setModelBuildingListener(listener);
                request.setPomFile(pomFile);
                request.setModelSource(modelSource);
                request.setLocationTracking(true);
                try {
                    result2 = this.modelBuilder.build(request);
                }
                catch (ModelBuildingException e) {
                    result2 = e.getResult();
                    if (result2 == null || result2.getEffectiveModel() == null) {
                        throw new ProjectBuildingException(e.getModelId(), e.getMessage(), pomFile, e);
                    }
                    error = e;
                }
                modelProblems = result2.getProblems();
                this.initProject(project, Collections.emptyMap(), true, result2, new HashMap<File, Boolean>(), projectBuildingRequest);
            } else if (projectBuildingRequest.isResolveDependencies()) {
                this.projectBuildingHelper.selectProjectRealm(project);
            }
            DependencyResolutionResult resolutionResult = null;
            if (projectBuildingRequest.isResolveDependencies()) {
                resolutionResult = this.resolveDependencies(project, config.session);
            }
            DefaultProjectBuildingResult result3 = new DefaultProjectBuildingResult(project, modelProblems, resolutionResult);
            if (error != null) {
                ProjectBuildingException e = new ProjectBuildingException(Arrays.asList(result3));
                e.initCause(error);
                throw e;
            }
            DefaultProjectBuildingResult defaultProjectBuildingResult = result3;
            return defaultProjectBuildingResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session2) {
        DependencyResolutionResult resolutionResult;
        try {
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session2);
            resolutionResult = this.dependencyResolver.resolve(resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path2 = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact(artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path2));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    private List<String> getProfileIds(List<Profile> profiles) {
        ArrayList<String> ids = new ArrayList<String>(profiles.size());
        for (Profile profile : profiles) {
            ids.add(profile.getId());
        }
        return ids;
    }

    private ModelBuildingRequest getModelBuildingRequest(InternalConfig config) {
        ProjectBuildingRequest configuration2 = config.request;
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        RequestTrace trace = RequestTrace.newChild(null, configuration2).newChild(request);
        ProjectModelResolver resolver = new ProjectModelResolver(config.session, trace, this.repoSystem, this.repositoryManager, config.repositories, configuration2.getRepositoryMerging(), config.modelPool);
        request.setValidationLevel(configuration2.getValidationLevel());
        request.setProcessPlugins(configuration2.isProcessPlugins());
        request.setProfiles(configuration2.getProfiles());
        request.setActiveProfileIds(configuration2.getActiveProfileIds());
        request.setInactiveProfileIds(configuration2.getInactiveProfileIds());
        request.setSystemProperties(configuration2.getSystemProperties());
        request.setUserProperties(configuration2.getUserProperties());
        request.setBuildStartTime(configuration2.getBuildStartTime());
        request.setModelResolver(resolver);
        request.setModelCache(config.modelCache);
        return request;
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(artifact, false, request);
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest request) throws ProjectBuildingException {
        boolean localProject;
        org.eclipse.aether.artifact.Artifact pomArtifact = RepositoryUtils.toArtifact(artifact);
        pomArtifact = ArtifactDescriptorUtils.toPomArtifact(pomArtifact);
        InternalConfig config = new InternalConfig(request, null, this.useGlobalModelCache() ? this.getModelCache() : null);
        try {
            ArtifactRequest pomRequest = new ArtifactRequest();
            pomRequest.setArtifact(pomArtifact);
            pomRequest.setRepositories(config.repositories);
            ArtifactResult pomResult = this.repoSystem.resolveArtifact(config.session, pomRequest);
            pomArtifact = pomResult.getArtifact();
            localProject = pomResult.getRepository() instanceof WorkspaceRepository;
        }
        catch (ArtifactResolutionException e) {
            if (e.getResults().get(0).isMissing() && allowStubModel) {
                return this.build(null, this.createStubModelSource(artifact), config);
            }
            throw new ProjectBuildingException(artifact.getId(), "Error resolving project artifact: " + e.getMessage(), e);
        }
        File pomFile = pomArtifact.getFile();
        if ("pom".equals(artifact.getType())) {
            artifact.selectVersion(pomArtifact.getVersion());
            artifact.setFile(pomFile);
            artifact.setResolved(true);
        }
        return this.build(localProject ? pomFile : null, new FileModelSource(pomFile), config);
    }

    private ModelSource createStubModelSource(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<project>");
        buffer.append("<modelVersion>4.0.0</modelVersion>");
        buffer.append("<groupId>").append(artifact.getGroupId()).append("</groupId>");
        buffer.append("<artifactId>").append(artifact.getArtifactId()).append("</artifactId>");
        buffer.append("<version>").append(artifact.getBaseVersion()).append("</version>");
        buffer.append("<packaging>").append(artifact.getType()).append("</packaging>");
        buffer.append("</project>");
        return new StringModelSource(buffer, artifact.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        ArrayList<ProjectBuildingResult> results = new ArrayList<ProjectBuildingResult>();
        ArrayList<InterimResult> interimResults = new ArrayList<InterimResult>();
        ReactorModelPool modelPool = new ReactorModelPool();
        InternalConfig config = new InternalConfig(request, modelPool, this.useGlobalModelCache() ? this.getModelCache() : new ReactorModelCache());
        HashMap<String, MavenProject> projectIndex = new HashMap<String, MavenProject>(256);
        boolean noErrors = this.build(results, interimResults, projectIndex, pomFiles, new LinkedHashSet<File>(), true, recursive, config);
        this.populateReactorModelPool(modelPool, interimResults);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            noErrors = this.build(results, new ArrayList<MavenProject>(), projectIndex, interimResults, request, new HashMap<File, Boolean>(), config.session) && noErrors;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        if (!noErrors) {
            throw new ProjectBuildingException(results);
        }
        return results;
    }

    private boolean build(List<ProjectBuildingResult> results, List<InterimResult> interimResults, Map<String, MavenProject> projectIndex, List<File> pomFiles, Set<File> aggregatorFiles, boolean isRoot, boolean recursive, InternalConfig config) {
        boolean noErrors = true;
        for (File pomFile : pomFiles) {
            aggregatorFiles.add(pomFile);
            if (!this.build(results, interimResults, projectIndex, pomFile, aggregatorFiles, isRoot, recursive, config)) {
                noErrors = false;
            }
            aggregatorFiles.remove(pomFile);
        }
        return noErrors;
    }

    private boolean build(List<ProjectBuildingResult> results, List<InterimResult> interimResults, Map<String, MavenProject> projectIndex, File pomFile, Set<File> aggregatorFiles, boolean isRoot, boolean recursive, InternalConfig config) {
        ModelBuildingResult result2;
        boolean noErrors = true;
        ModelBuildingRequest request = this.getModelBuildingRequest(config);
        MavenProject project = new MavenProject();
        project.setFile(pomFile);
        request.setPomFile(pomFile);
        request.setTwoPhaseBuilding(true);
        request.setLocationTracking(true);
        DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, this.projectBuildingHelper, config.request);
        request.setModelBuildingListener(listener);
        try {
            result2 = this.modelBuilder.build(request);
        }
        catch (ModelBuildingException e) {
            result2 = e.getResult();
            if (result2 == null || result2.getEffectiveModel() == null) {
                results.add(new DefaultProjectBuildingResult(e.getModelId(), pomFile, e.getProblems()));
                return false;
            }
            noErrors = false;
        }
        Model model = result2.getEffectiveModel();
        try {
            this.initProject(project, projectIndex, false, result2, new HashMap<File, Boolean>(0), config.request);
        }
        catch (InvalidArtifactRTException iarte) {
            result2.getProblems().add(new DefaultModelProblem(null, ModelProblem.Severity.ERROR, null, model, -1, -1, iarte));
        }
        projectIndex.put(result2.getModelIds().get(0), project);
        InterimResult interimResult = new InterimResult(pomFile, request, result2, listener, isRoot);
        interimResults.add(interimResult);
        if (recursive && !model.getModules().isEmpty()) {
            File basedir = pomFile.getParentFile();
            ArrayList<File> moduleFiles = new ArrayList<File>();
            for (String module2 : model.getModules()) {
                if (StringUtils.isEmpty(module2)) continue;
                File moduleFile = new File(basedir, module2 = module2.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                if (moduleFile.isDirectory()) {
                    moduleFile = this.modelProcessor.locatePom(moduleFile);
                }
                if (!moduleFile.isFile()) {
                    DefaultModelProblem problem = new DefaultModelProblem("Child module " + moduleFile + " of " + pomFile + " does not exist", ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                    result2.getProblems().add(problem);
                    noErrors = false;
                    continue;
                }
                if (Os.isFamily("windows")) {
                    try {
                        moduleFile = moduleFile.getCanonicalFile();
                    }
                    catch (IOException e) {
                        moduleFile = moduleFile.getAbsoluteFile();
                    }
                } else {
                    moduleFile = new File(moduleFile.toURI().normalize());
                }
                if (aggregatorFiles.contains(moduleFile)) {
                    StringBuilder buffer = new StringBuilder(256);
                    for (File aggregatorFile : aggregatorFiles) {
                        buffer.append(aggregatorFile).append(" -> ");
                    }
                    buffer.append(moduleFile);
                    DefaultModelProblem problem = new DefaultModelProblem("Child module " + moduleFile + " of " + pomFile + " forms aggregation cycle " + buffer, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                    result2.getProblems().add(problem);
                    noErrors = false;
                    continue;
                }
                moduleFiles.add(moduleFile);
            }
            interimResult.modules = new ArrayList<InterimResult>();
            if (!this.build(results, interimResult.modules, projectIndex, moduleFiles, aggregatorFiles, false, recursive, config)) {
                noErrors = false;
            }
        }
        return noErrors;
    }

    private void populateReactorModelPool(ReactorModelPool reactorModelPool, List<InterimResult> interimResults) {
        for (InterimResult interimResult : interimResults) {
            Model model = interimResult.result.getEffectiveModel();
            reactorModelPool.put(model.getGroupId(), model.getArtifactId(), model.getVersion(), model.getPomFile());
            this.populateReactorModelPool(reactorModelPool, interimResult.modules);
        }
    }

    private boolean build(List<ProjectBuildingResult> results, List<MavenProject> projects, Map<String, MavenProject> projectIndex, List<InterimResult> interimResults, ProjectBuildingRequest request, Map<File, Boolean> profilesXmls, RepositorySystemSession session2) {
        boolean noErrors = true;
        for (InterimResult interimResult : interimResults) {
            MavenProject project = interimResult.listener.getProject();
            try {
                ModelBuildingResult result2 = this.modelBuilder.build(interimResult.request, interimResult.result);
                try {
                    this.initProject(project, projectIndex, true, result2, profilesXmls, request);
                }
                catch (InvalidArtifactRTException iarte) {
                    result2.getProblems().add(new DefaultModelProblem(null, ModelProblem.Severity.ERROR, null, result2.getEffectiveModel(), -1, -1, iarte));
                }
                ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
                noErrors = this.build(results, modules, projectIndex, interimResult.modules, request, profilesXmls, session2) && noErrors;
                projects.addAll(modules);
                projects.add(project);
                project.setExecutionRoot(interimResult.root);
                project.setCollectedProjects(modules);
                DependencyResolutionResult resolutionResult = null;
                if (request.isResolveDependencies()) {
                    resolutionResult = this.resolveDependencies(project, session2);
                }
                results.add(new DefaultProjectBuildingResult(project, result2.getProblems(), resolutionResult));
            }
            catch (ModelBuildingException e) {
                DefaultProjectBuildingResult result3 = null;
                result3 = project == null ? new DefaultProjectBuildingResult(e.getModelId(), interimResult.pomFile, e.getProblems()) : new DefaultProjectBuildingResult(project, e.getProblems(), null);
                results.add(result3);
                noErrors = false;
            }
        }
        return noErrors;
    }

    private void initProject(MavenProject project, Map<String, MavenProject> projects, boolean buildParentIfNotExisting, ModelBuildingResult result2, Map<File, Boolean> profilesXmls, ProjectBuildingRequest projectBuildingRequest) {
        ArtifactRepository repo;
        DeploymentRepository r;
        Model model = result2.getEffectiveModel();
        project.setModel(model);
        project.setOriginalModel(result2.getRawModel());
        project.setFile(model.getPomFile());
        this.initParent(project, projects, buildParentIfNotExisting, result2, projectBuildingRequest);
        Artifact projectArtifact = this.repositorySystem.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
        project.setArtifact(projectArtifact);
        if (project.getFile() != null && buildParentIfNotExisting) {
            Build build2 = project.getBuild();
            project.addScriptSourceRoot(build2.getScriptSourceDirectory());
            project.addCompileSourceRoot(build2.getSourceDirectory());
            project.addTestCompileSourceRoot(build2.getTestSourceDirectory());
        }
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>();
        activeProfiles.addAll(result2.getActivePomProfiles(result2.getModelIds().get(0)));
        activeProfiles.addAll(result2.getActiveExternalProfiles());
        project.setActiveProfiles(activeProfiles);
        project.setInjectedProfileIds("external", this.getProfileIds(result2.getActiveExternalProfiles()));
        for (String modelId : result2.getModelIds()) {
            project.setInjectedProfileIds(modelId, this.getProfileIds(result2.getActivePomProfiles(modelId)));
        }
        String modelId = this.findProfilesXml(result2, profilesXmls);
        if (modelId != null) {
            DefaultModelProblem problem = new DefaultModelProblem("Detected profiles.xml alongside " + modelId + ", this file is no longer supported and was ignored, please use the settings.xml instead", ModelProblem.Severity.WARNING, ModelProblem.Version.V30, model, -1, -1, null);
            result2.getProblems().add(problem);
        }
        project.setProjectBuildingRequest(projectBuildingRequest);
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        for (Plugin plugin : project.getBuildPlugins()) {
            Artifact artifact = this.repositorySystem.createPluginArtifact(plugin);
            if (artifact == null) continue;
            pluginArtifacts.add(artifact);
        }
        project.setPluginArtifacts(pluginArtifacts);
        HashSet<Artifact> reportArtifacts = new HashSet<Artifact>();
        for (ReportPlugin report2 : project.getReportPlugins()) {
            Plugin pp = new Plugin();
            pp.setGroupId(report2.getGroupId());
            pp.setArtifactId(report2.getArtifactId());
            pp.setVersion(report2.getVersion());
            Artifact artifact = this.repositorySystem.createPluginArtifact(pp);
            if (artifact == null) continue;
            reportArtifacts.add(artifact);
        }
        project.setReportArtifacts(reportArtifacts);
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        List<Extension> extensions = project.getBuildExtensions();
        if (extensions != null) {
            for (Extension ext : extensions) {
                String version = StringUtils.isEmpty(ext.getVersion()) ? "RELEASE" : ext.getVersion();
                Artifact artifact = this.repositorySystem.createArtifact(ext.getGroupId(), ext.getArtifactId(), version, null, "jar");
                if (artifact == null) continue;
                hashSet.add(artifact);
            }
        }
        project.setExtensionArtifacts(hashSet);
        AbstractMap<String, Artifact> map2 = null;
        if (this.repositorySystem != null) {
            final DependencyManagement dependencyManagement = project.getDependencyManagement();
            map2 = dependencyManagement != null && dependencyManagement.getDependencies() != null && dependencyManagement.getDependencies().size() > 0 ? new AbstractMap<String, Artifact>(){
                HashMap<String, Artifact> delegate;

                @Override
                public Set<Map.Entry<String, Artifact>> entrySet() {
                    return Collections.unmodifiableSet(this.compute().entrySet());
                }

                @Override
                public Set<String> keySet() {
                    return Collections.unmodifiableSet(this.compute().keySet());
                }

                @Override
                public Collection<Artifact> values() {
                    return Collections.unmodifiableCollection(this.compute().values());
                }

                @Override
                public boolean containsValue(Object value2) {
                    return this.compute().containsValue(value2);
                }

                @Override
                public boolean containsKey(Object key) {
                    return this.compute().containsKey(key);
                }

                @Override
                public Artifact get(Object key) {
                    return this.compute().get(key);
                }

                HashMap<String, Artifact> compute() {
                    if (this.delegate == null) {
                        this.delegate = new HashMap();
                        for (Dependency d : dependencyManagement.getDependencies()) {
                            Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createDependencyArtifact(d);
                            if (artifact == null) continue;
                            this.delegate.put(d.getManagementKey(), artifact);
                        }
                    }
                    return this.delegate;
                }
            } : Collections.emptyMap();
        }
        project.setManagedVersionMap(map2);
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null) {
            try {
                r = project.getDistributionManagement().getRepository();
                if (!StringUtils.isEmpty(r.getId()) && !StringUtils.isEmpty(r.getUrl())) {
                    repo = MavenRepositorySystem.buildArtifactRepository(r);
                    this.repositorySystem.injectProxy(projectBuildingRequest.getRepositorySession(), Arrays.asList(repo));
                    this.repositorySystem.injectAuthentication(projectBuildingRequest.getRepositorySession(), Arrays.asList(repo));
                    project.setReleaseArtifactRepository(repo);
                }
            }
            catch (InvalidRepositoryException e) {
                throw new IllegalStateException("Failed to create release distribution repository for " + project.getId(), e);
            }
        }
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getSnapshotRepository() != null) {
            try {
                r = project.getDistributionManagement().getSnapshotRepository();
                if (!StringUtils.isEmpty(r.getId()) && !StringUtils.isEmpty(r.getUrl())) {
                    repo = MavenRepositorySystem.buildArtifactRepository(r);
                    this.repositorySystem.injectProxy(projectBuildingRequest.getRepositorySession(), Arrays.asList(repo));
                    this.repositorySystem.injectAuthentication(projectBuildingRequest.getRepositorySession(), Arrays.asList(repo));
                    project.setSnapshotArtifactRepository(repo);
                }
            }
            catch (InvalidRepositoryException e) {
                throw new IllegalStateException("Failed to create snapshot distribution repository for " + project.getId(), e);
            }
        }
    }

    private void initParent(MavenProject project, Map<String, MavenProject> projects, boolean buildParentIfNotExisting, ModelBuildingResult result2, ProjectBuildingRequest projectBuildingRequest) {
        Model parentModel;
        Model model = parentModel = result2.getModelIds().size() > 1 && !result2.getModelIds().get(1).isEmpty() ? result2.getRawModel(result2.getModelIds().get(1)) : null;
        if (parentModel != null) {
            MavenProject parent2;
            block11: {
                String parentGroupId = DefaultProjectBuilder.inheritedGroupId(result2, 1);
                String parentVersion = DefaultProjectBuilder.inheritedVersion(result2, 1);
                project.setParentArtifact(this.repositorySystem.createProjectArtifact(parentGroupId, parentModel.getArtifactId(), parentVersion));
                String parentModelId = result2.getModelIds().get(1);
                File parentPomFile = result2.getRawModel(parentModelId).getPomFile();
                parent2 = projects.get(parentModelId);
                if (parent2 == null && buildParentIfNotExisting) {
                    projectBuildingRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
                    if (parentPomFile != null) {
                        project.setParentFile(parentPomFile);
                        try {
                            parent2 = this.build(parentPomFile, projectBuildingRequest).getProject();
                        }
                        catch (ProjectBuildingException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.warn("Failed to build parent project for " + project.getId(), e);
                                break block11;
                            }
                            this.logger.warn("Failed to build parent project for " + project.getId());
                        }
                    } else {
                        Artifact parentArtifact = project.getParentArtifact();
                        try {
                            parent2 = this.build(parentArtifact, projectBuildingRequest).getProject();
                        }
                        catch (ProjectBuildingException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.warn("Failed to build parent project for " + project.getId(), e);
                            }
                            this.logger.warn("Failed to build parent project for " + project.getId());
                        }
                    }
                }
            }
            project.setParent(parent2);
            if (project.getParentFile() == null && parent2 != null) {
                project.setParentFile(parent2.getFile());
            }
        }
    }

    private static String inheritedGroupId(ModelBuildingResult result2, int modelIndex) {
        String groupId = null;
        String modelId = result2.getModelIds().get(modelIndex);
        if (!modelId.isEmpty()) {
            Model model = result2.getRawModel(modelId);
            groupId = model.getGroupId() != null ? model.getGroupId() : DefaultProjectBuilder.inheritedGroupId(result2, modelIndex + 1);
        }
        return groupId;
    }

    private static String inheritedVersion(ModelBuildingResult result2, int modelIndex) {
        String version = null;
        String modelId = result2.getModelIds().get(modelIndex);
        if (!modelId.isEmpty()) {
            Model model = result2.getRawModel(modelId);
            version = model.getVersion() != null ? model.getVersion() : DefaultProjectBuilder.inheritedVersion(result2, modelIndex + 1);
        }
        return version;
    }

    private String findProfilesXml(ModelBuildingResult result2, Map<File, Boolean> profilesXmls) {
        String modelId;
        Model model;
        File basedir;
        Iterator<String> iterator2 = result2.getModelIds().iterator();
        while (iterator2.hasNext() && (basedir = (model = result2.getRawModel(modelId = iterator2.next())).getProjectDirectory()) != null) {
            Boolean profilesXml = profilesXmls.get(basedir);
            if (profilesXml == null) {
                profilesXml = new File(basedir, "profiles.xml").exists();
                profilesXmls.put(basedir, profilesXml);
            }
            if (!profilesXml.booleanValue()) continue;
            return modelId;
        }
        return null;
    }

    private ReactorModelCache getModelCache() {
        return this.modelCache;
    }

    class InternalConfig {
        private final ProjectBuildingRequest request;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> repositories;
        private final ReactorModelPool modelPool;
        private final ReactorModelCache modelCache;

        InternalConfig(ProjectBuildingRequest request, ReactorModelPool modelPool, ReactorModelCache modelCache) {
            this.request = request;
            this.modelPool = modelPool;
            this.modelCache = modelCache;
            this.session = LegacyLocalRepositoryManager.overlay(request.getLocalRepository(), request.getRepositorySession(), DefaultProjectBuilder.this.repoSystem);
            this.repositories = RepositoryUtils.toRepos(request.getRemoteRepositories());
        }
    }

    static class InterimResult {
        File pomFile;
        ModelBuildingRequest request;
        ModelBuildingResult result;
        DefaultModelBuildingListener listener;
        boolean root;
        List<InterimResult> modules = Collections.emptyList();

        InterimResult(File pomFile, ModelBuildingRequest request, ModelBuildingResult result2, DefaultModelBuildingListener listener, boolean root2) {
            this.pomFile = pomFile;
            this.request = request;
            this.result = result2;
            this.listener = listener;
            this.root = root2;
        }
    }
}

