/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class TreeDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    private final DependencyVisitor visitor;
    private final Stack<Boolean> visits;

    public TreeDependencyVisitor(DependencyVisitor visitor2) {
        this.visitor = Objects.requireNonNull(visitor2, "dependency visitor delegate cannot be null");
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
        this.visits = new Stack();
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        boolean visited2 = this.visitedNodes.put(node, Boolean.TRUE) != null;
        this.visits.push(visited2);
        if (visited2) {
            return false;
        }
        return this.visitor.visitEnter(node);
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        Boolean visited2 = this.visits.pop();
        if (visited2.booleanValue()) {
            return true;
        }
        return this.visitor.visitLeave(node);
    }
}

