/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginProblemReporter;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public class PluginException
extends RuntimeException {
    private final PluginId myPluginId;

    public PluginException(@NotNull @NonNls String message2, Throwable cause, @Nullable PluginId pluginId) {
        if (message2 == null) {
            PluginException.$$$reportNull$$$0(0);
        }
        super(message2, cause);
        this.myPluginId = pluginId;
    }

    public PluginException(@NotNull Throwable e, @Nullable PluginId pluginId) {
        if (e == null) {
            PluginException.$$$reportNull$$$0(1);
        }
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
    }

    public PluginException(@NotNull @NonNls String message2, @Nullable PluginId pluginId) {
        if (message2 == null) {
            PluginException.$$$reportNull$$$0(2);
        }
        super(message2);
        this.myPluginId = pluginId;
    }

    @Override
    @NotNull
    @NonNls
    public String getMessage() {
        String message2 = super.getMessage();
        String string2 = this.myPluginId != null ? StringUtil.notNullize(message2) + " [Plugin: " + this.myPluginId + "]" : message2;
        if (string2 == null) {
            PluginException.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static PluginException createByClass(@NotNull @NonNls String errorMessage2, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (errorMessage2 == null) {
            PluginException.$$$reportNull$$$0(4);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(5);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage2, cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(6);
        }
        return pluginException;
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        if (cause == null) {
            PluginException.$$$reportNull$$$0(7);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(8);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(StringUtil.notNullize(cause.getMessage()), cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(9);
        }
        return pluginException;
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull @NonNls String errorMessage2, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (logger == null) {
            PluginException.$$$reportNull$$$0(10);
        }
        if (errorMessage2 == null) {
            PluginException.$$$reportNull$$$0(11);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(12);
        }
        logger.error(PluginException.createByClass(errorMessage2, cause, pluginClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/PluginException";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/PluginException";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createByClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logPluginError";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

