/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirDelegatedMemberScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.util.ImplementationStatus;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00b2\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0000\u001a@\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,2\u0006\u00105\u001a\u00020\b\u001a\u001a\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;\u001a\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?\u001a\u001e\u0010@\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/\u001a \u0010D\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/H\u0002\u001a \u0010E\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020!H\u0002\u001a\u0012\u0010H\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\u0010\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L*\u00020N\u001a\f\u0010O\u001a\u0004\u0018\u00010P*\u00020*\u001a\u0014\u0010Q\u001a\u0004\u0018\u000109*\u00020P2\u0006\u0010)\u001a\u00020*\u001a\u0018\u0010R\u001a\u0004\u0018\u00010N*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010S\u001a\u00020J\u001a\u0018\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020?2\u0006\u0010I\u001a\u00020J\u001a\u001c\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\"2\u0006\u0010I\u001a\u00020J\u001a\"\u0010U\u001a\u00020V*\u0006\u0012\u0002\b\u00030W2\u0006\u0010X\u001a\u00020Y2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030[\u001a\u000e\u0010\\\u001a\u0004\u0018\u00010]*\u0004\u0018\u00010^\u001a\f\u0010_\u001a\u00020\b*\u00020?H\u0002\u001a\u0012\u0010`\u001a\u00020a*\u00020b2\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010c\u001a\u00020\b*\u0006\u0012\u0002\b\u00030d\u001a\u0012\u0010e\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\n\u0010f\u001a\u00020\b*\u00020b\u001a\u001c\u0010g\u001a\u00020\b*\u00020h2\u0006\u0010)\u001a\u00020i2\b\u0010j\u001a\u0004\u0018\u00010h\u001a\u0012\u0010k\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\"\u0010l\u001a\u00020\b*\u0006\u0012\u0002\b\u00030[2\n\u0010m\u001a\u0006\u0012\u0002\b\u00030[2\u0006\u0010I\u001a\u00020J\u001a\u001c\u0010l\u001a\u00020\b*\u00020h2\u0006\u0010)\u001a\u00020i2\b\u0010j\u001a\u0004\u0018\u00010h\u001a\u0012\u0010n\u001a\u00020\b*\u00020o2\u0006\u0010p\u001a\u00020P\u001a\u001a\u0010n\u001a\u00020\b*\u0006\u0012\u0002\b\u00030W2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030[\u001a\f\u0010q\u001a\u0004\u0018\u00010a*\u00020P\u001a\u001c\u0010r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010)\u001a\u00020*\u001a$\u0010s\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030d0 *\u00020t2\u0006\u0010u\u001a\u00020P2\u0006\u0010)\u001a\u00020*\u001a\u0014\u0010v\u001a\u00020\b*\u00020w2\u0006\u0010X\u001a\u00020YH\u0002\u001a\u0018\u0010x\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0002092\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010y\u001a\u0004\u0018\u00010N*\u00020z2\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010y\u001a\u0004\u0018\u00010N*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010y\u001a\u0004\u0018\u00010N*\u0002092\u0006\u0010I\u001a\u00020J\u001a\f\u0010{\u001a\u0004\u0018\u00010]*\u00020|\u001a\u0012\u0010}\u001a\u00020~*\u00020P2\u0006\u0010)\u001a\u00020*\u001a\u0016\u0010}\u001a\u00020~*\u0006\u0012\u0002\b\u00030[2\u0006\u0010)\u001a\u00020*\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u0006\u0012\u0002\b\u00030\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\b*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\b*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0018\u0010\u0019\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\"\u0018\u0010\u001b\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\"\u0018\u0010\u001d\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\"!\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 *\u0006\u0012\u0002\b\u00030\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$*\u000e\b\u0002\u0010\u007f\"\u00030\u0080\u00012\u00030\u0080\u0001\u00a8\u0006\u0081\u0001"}, d2={"INLINE_ONLY_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassKind", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassKind;", "hasValOrVar", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getHasValOrVar", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Z", "isConflictingOrNotInvariant", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Z", "isDelegated", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)Z", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "matchesDataClassSyntheticMemberSignatures", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "typeParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getTypeParameterSymbols", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/util/List;", "checkCondition", "", "condition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeMismatch", "lValueOriginalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "assignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "rValue", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isInitializer", "extractArgumentTypeRefAndSource", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "index", "", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "annotated", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isSubtypeForTypeMismatch", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "subtype", "supertype", "isSubtypeOfForFunctionalTypeReturningUnit", "lowerThanBound", "argument", "typeParameterSymbol", "canHaveSubtypes", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "collectEnumEntries", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "findNonInterfaceSupertype", "fullyExpandedClass", "useSiteSession", "getContainingClassSymbol", "getImplementationStatus", "Lorg/jetbrains/kotlin/util/ImplementationStatus;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "parentClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "hasBody", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isFunctionForExpectTypeFromCastFeature", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "isInlineClass", "isInlineOnly", "isSubtypeOf", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "isSubtypeOfThrowable", "isSupertypeOf", "other", "isVisibleInClass", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "parentClass", "modality", "outerClassSymbol", "overriddenFunctions", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "containingClass", "subjectToManyNotImplemented", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirIntersectionCallableSymbol;", "toClassLikeSymbol", "toRegularClassSymbol", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toVisibilityOrNull", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "unsubstitutedScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "TargetLists", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetLists;", "checkers"})
public final class FirHelpersKt {
    @NotNull
    private static final ClassId INLINE_ONLY_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClass $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClassSymbol<?> $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> toClassLikeSymbol(@NotNull FirTypeRef $this$toClassLikeSymbol, @NotNull FirSession session2) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$toClassLikeSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef $this$coneTypeSafe$iv = $this$toClassLikeSymbol;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        FirBasedSymbol<?> firBasedSymbol = (coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : TypeUtilsKt.toSymbol(coneClassLikeType, session2);
        return firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
    }

    public static final boolean isSupertypeOf(@NotNull FirClassSymbol<?> $this$isSupertypeOf, @NotNull FirClassSymbol<?> other, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf, session2, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull ConeClassLikeType $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toRegularClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirBasedSymbol<?> firBasedSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default($this$toRegularClassSymbol, session2, null, 2, null), session2);
        return firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull ConeKotlinType $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toRegularClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeClassLikeType coneClassLikeType = $this$toRegularClassSymbol instanceof ConeClassLikeType ? (ConeClassLikeType)$this$toRegularClassSymbol : null;
        return coneClassLikeType == null ? null : FirHelpersKt.toRegularClassSymbol(coneClassLikeType, session2);
    }

    public static final boolean isInlineClass(@NotNull ConeKotlinType $this$isInlineClass, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isInlineClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isInlineClass, session2);
        if (firRegularClassSymbol == null) {
            bl = false;
        } else {
            FirRegularClassSymbol $this$isInline$iv = firRegularClassSymbol;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getResolvedStatus().isInline();
        }
        return bl;
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull FirTypeRef $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toRegularClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$toRegularClassSymbol), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirDeclaration $this$getContainingClassSymbol, @NotNull FirSession session2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirCallableDeclaration firCallableDeclaration;
        Intrinsics.checkNotNullParameter($this$getContainingClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirDeclaration $this$safeAs$iv = $this$getContainingClassSymbol;
        boolean $i$f$safeAs = false;
        FirDeclaration firDeclaration = $this$safeAs$iv;
        if (!(firDeclaration instanceof FirCallableDeclaration)) {
            firDeclaration = null;
        }
        return (firCallableDeclaration = (FirCallableDeclaration)firDeclaration) == null ? null : ((coneClassLikeLookupTag = ClassMembersKt.containingClass(firCallableDeclaration)) == null ? null : LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2));
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirBasedSymbol<?> $this$getContainingClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getContainingClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.getContainingClassSymbol($this$getContainingClassSymbol.getFir(), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> outerClassSymbol(@NotNull FirClassLikeSymbol<?> $this$outerClassSymbol, @NotNull CheckerContext context2) {
        ClassId classId;
        Intrinsics.checkNotNullParameter($this$outerClassSymbol, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!($this$outerClassSymbol instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId2 = $this$outerClassSymbol.getClassId().getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        ClassId outerClassId = classId = classId2;
        return MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(outerClassId);
    }

    @Nullable
    public static final FirRegularClassSymbol fullyExpandedClass(@NotNull FirClassLikeSymbol<?> $this$fullyExpandedClass, @NotNull FirSession useSiteSession) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter($this$fullyExpandedClass, "<this>");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$fullyExpandedClass;
        if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)$this$fullyExpandedClass;
        } else if (firClassLikeSymbol instanceof FirTypeAliasSymbol) {
            FirClassLikeSymbol firClassLikeSymbol2;
            ConeClassLikeType coneClassLikeType;
            FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)$this$fullyExpandedClass).getResolvedExpandedTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            FirBasedSymbol<?> firBasedSymbol = (coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : TypeUtilsKt.toSymbol(coneClassLikeType, useSiteSession);
            FirClassLikeSymbol firClassLikeSymbol3 = firClassLikeSymbol2 = firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
            firRegularClassSymbol = firClassLikeSymbol2 == null ? null : FirHelpersKt.fullyExpandedClass(firClassLikeSymbol2, useSiteSession);
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }

    @Nullable
    public static final FirClass findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter($this$findClosestClassOrObject, "<this>");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName($this$overriddenFunctions.getSymbol().getCallableId().getCallableName(), overriddenFunctions.1.INSTANCE);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions.getSymbol(), (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)new Function1<FirNamedFunctionSymbol, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List<FirFunctionSymbol<?>> $overriddenFunctions;
            {
                this.$overriddenFunctions = $overriddenFunctions;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
        });
        return overriddenFunctions2;
    }

    @Nullable
    public static final Visibility getVisibility(@Nullable KtModifierList $this$getVisibility) {
        KtModifierKeywordToken ktModifierKeywordToken;
        KtModifierList ktModifierList = $this$getVisibility;
        return ktModifierList == null ? null : ((ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType(ktModifierList)) == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken));
    }

    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter($this$toVisibilityOrNull, "<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter($this$modality, "<this>");
        FirClass firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)((Object)$this$modality);
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context2) {
        LighterASTNode lighterASTNode2;
        Object object;
        Intrinsics.checkNotNullParameter($this$implicitModality, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass klass = firClass;
        FirSourceElement firSourceElement = $this$implicitModality.getSource();
        if (firSourceElement == null) {
            return Modality.FINAL;
        }
        FirSourceElement source = firSourceElement;
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        if (LightTreePositioningStrategiesKt.overrideModifier(tree, source.getLighterASTNode()) != null) {
            IElementType iElementType;
            object = klass.getSource();
            if (object == null) {
                iElementType = null;
            } else {
                FirSourceElement firSourceElement2;
                FirSourceElement it = firSourceElement2 = object;
                boolean bl = false;
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.modalityModifier(tree, it.getLighterASTNode());
                iElementType = lighterASTNode3 == null ? null : lighterASTNode3.getTokenType();
            }
            IElementType klassModalityTokenType = iElementType;
            if (Intrinsics.areEqual(klassModalityTokenType, KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.OPEN_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.SEALED_KEYWORD)) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((lighterASTNode2 = LightTreePositioningStrategiesKt.visibilityModifier(tree, source.getLighterASTNode())) == null ? null : lighterASTNode2.getTokenType(), KtTokens.PRIVATE_KEYWORD)) {
            if (!($this$implicitModality instanceof FirDeclaration)) {
                object = "Failed requirement.";
                throw new IllegalArgumentException(object.toString());
            }
            return FirHelpersKt.hasBody((FirDeclaration)((Object)$this$implicitModality)) ? Modality.OPEN : Modality.ABSTRACT;
        }
        return Modality.FINAL;
    }

    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirPropertyAccessor firPropertyAccessor;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasBody;
        boolean bl = firDeclaration instanceof FirSimpleFunction ? ((FirSimpleFunction)$this$hasBody).getBody() != null && !(((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) : (firDeclaration instanceof FirProperty ? !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) || !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getGetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) : false);
        return bl;
    }

    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass $this$findNonInterfaceSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$findNonInterfaceSupertype, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        for (FirTypeRef superTypeRef : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            FirClassSymbol symbol2;
            ConeClassLikeLookupTag lookupTag;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            FirClassSymbol firClassSymbol;
            ConeClassLikeType coneClassLikeType;
            ConeKotlinType $this$safeAs$iv = FirTypeUtilsKt.getConeType(superTypeRef);
            boolean $i$f$safeAs = false;
            ConeKotlinType coneKotlinType = $this$safeAs$iv;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)coneKotlinType) == null || (firClassSymbol = (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(lookupTag = coneClassLikeType.getLookupTag(), context2.getSession())) instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null) == null || (symbol2 = firClassSymbol).getClassKind() == ClassKind.INTERFACE) continue;
            return superTypeRef;
        }
        return null;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        return Intrinsics.areEqual($this$isIterator.getCalleeReference().getName().asString(), "<iterator>");
    }

    public static final boolean isSubtypeOfThrowable(@NotNull ConeKotlinType $this$isSubtypeOfThrowable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfThrowable, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isSupertypeOf(session2.getBuiltinTypes().getThrowableType().getType(), SessionUtilsKt.getTypeContext(session2), TypeExpansionUtilsKt.fullyExpandedType($this$isSubtypeOfThrowable, session2));
    }

    public static final boolean getHasValOrVar(@NotNull FirValueParameter $this$hasValOrVar) {
        Intrinsics.checkNotNullParameter($this$hasValOrVar, "<this>");
        Object object = $this$hasValOrVar.getSource();
        if (object == null) {
            return false;
        }
        FirSourceElement source = object;
        object = KtParameter.VAL_VAR_TOKEN_SET;
        Intrinsics.checkNotNullExpressionValue(object, "VAL_VAR_TOKEN_SET");
        return FirSourceUtilsKt.getChild$default(source, (TokenSet)object, 0, 0, 6, null) != null;
    }

    public static final boolean isSupertypeOf(@NotNull KotlinTypeMarker $this$isSupertypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, type2, $this$isSupertypeOf, false, 8, null);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinTypeMarker $this$isSubtypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, $this$isSubtypeOf, type2, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canHaveSubtypes(@NotNull ConeKotlinType $this$canHaveSubtypes, @NotNull FirSession session2) {
        FirRegularClassSymbol classSymbol;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter($this$canHaveSubtypes, "<this>");
                Intrinsics.checkNotNullParameter(session2, "session");
                if (ConeTypeUtilsKt.isMarkedNullable($this$canHaveSubtypes)) {
                    return true;
                }
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$canHaveSubtypes, session2);
                if (firRegularClassSymbol == null) {
                    return true;
                }
                classSymbol = firRegularClassSymbol;
                FirClassSymbol $this$isEnumClass$iv = classSymbol;
                boolean $i$f$isEnumClass = false;
                ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                boolean $i$f$isEnumClass2 = false;
                if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block19;
                FirRegularClassSymbol $this$isExpect$iv = classSymbol;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getResolvedStatus().isExpect()) break block19;
                FirRegularClassSymbol $this$modality$iv = classSymbol;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) break block20;
            }
            return true;
        }
        Iterable $this$forEachIndexed$iv = classSymbol.getTypeParameterSymbols();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterSymbol;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)item$iv;
            int idx = n;
            boolean bl = false;
            ConeTypeProjection typeProjection = $this$canHaveSubtypes.getTypeArguments()[idx];
            if (ConeTypesKt.isStarProjection(typeProjection)) {
                return true;
            }
            Intrinsics.checkNotNull(ConeTypesKt.getType(typeProjection));
            Variance variance = typeParameterSymbol.getVariance();
            int n2 = WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
            block0 : switch (n2) {
                case 1: {
                    ConeKotlinType argument2;
                    ProjectionKind projectionKind = typeProjection.getKind();
                    int n3 = WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()];
                    switch (n3) {
                        case 1: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol) && !FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 2: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol)) break block0;
                            return true;
                        }
                        case 3: {
                            if (!FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    break;
                }
                case 2: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.OUT ? FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol) : FirHelpersKt.canHaveSubtypes(argument2, session2))) break;
                    return true;
                }
                case 3: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.IN ? FirHelpersKt.canHaveSubtypes(argument2, session2) : FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean lowerThanBound(ConeInferenceContext context2, ConeKotlinType argument2, FirTypeParameterSymbol typeParameterSymbol) {
        Iterable $this$forEach$iv = typeParameterSymbol.getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef boundTypeRef = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(argument2, FirTypeUtilsKt.getConeType(boundTypeRef)) || !FirHelpersKt.isSubtypeOf(argument2, context2, FirTypeUtilsKt.getConeType(boundTypeRef))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInlineOnly(@NotNull FirMemberDeclaration $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter($this$isInlineOnly, "<this>");
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOnly;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && FirAnnotationUtilsKt.hasAnnotation((FirAnnotatedDeclaration)((Object)$this$isInlineOnly), INLINE_ONLY_ANNOTATION_CLASS_ID);
    }

    public static final boolean isSubtypeForTypeMismatch(@NotNull ConeInferenceContext context2, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        ConeKotlinType subtypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(subtype, context2.getSession());
        ConeKotlinType supertypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(supertype2, context2.getSession());
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, (KotlinTypeMarker)subtypeFullyExpanded, (KotlinTypeMarker)supertypeFullyExpanded, false, 8, null) || FirHelpersKt.isSubtypeOfForFunctionalTypeReturningUnit(SessionUtilsKt.getTypeContext(context2.getSession()), subtypeFullyExpanded, supertypeFullyExpanded);
    }

    private static final boolean isSubtypeOfForFunctionalTypeReturningUnit(ConeInferenceContext context2, ConeKotlinType subtype, ConeKotlinType supertype2) {
        ConeClassLikeType coneClassLikeType;
        if (!InferenceUtilsKt.isBuiltinFunctionalType(supertype2, context2.getSession())) {
            return false;
        }
        ConeTypeProjection functionalTypeReturnType = ArraysKt.lastOrNull(supertype2.getTypeArguments());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = functionalTypeReturnType instanceof ConeClassLikeType ? (ConeClassLikeType)functionalTypeReturnType : null;
        if (coneClassLikeType == null ? false : ConeTypeUtilsKt.isUnit(coneClassLikeType)) {
            List<ConeTypeProjection> superTypeArgs = ArraysKt.dropLast(supertype2.getTypeArguments(), 1);
            List<ConeTypeProjection> subTypeArgs = ArraysKt.dropLast(subtype.getTypeArguments(), 1);
            if (superTypeArgs.size() != subTypeArgs.size()) {
                return false;
            }
            int n = 0;
            int n2 = superTypeArgs.size();
            while (n < n2) {
                int i;
                ConeKotlinType coneKotlinType;
                if ((coneKotlinType = ConeTypesKt.getType(subTypeArgs.get(i = n++))) == null) {
                    return false;
                }
                ConeKotlinType subTypeArg = coneKotlinType;
                ConeKotlinType coneKotlinType2 = ConeTypesKt.getType(superTypeArgs.get(i));
                if (coneKotlinType2 == null) {
                    return false;
                }
                ConeKotlinType superTypeArg = coneKotlinType2;
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)subTypeArg, (KotlinTypeMarker)superTypeArg, false, 8, null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableDeclaration $this$isVisibleInClass, @NotNull FirClass parentClass) {
        Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
        Intrinsics.checkNotNullParameter(parentClass, "parentClass");
        return FirHelpersKt.isVisibleInClass($this$isVisibleInClass.getSymbol(), parentClass.getSymbol());
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableSymbol<?> $this$isVisibleInClass, @NotNull FirClassSymbol<?> parentClassSymbol) {
        boolean $i$f$getVisibility;
        FirCallableSymbol<?> $this$visibility$iv;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
                Intrinsics.checkNotNullParameter(parentClassSymbol, "parentClassSymbol");
                FqName fqName2 = parentClassSymbol.getClassId().getPackageFqName();
                Intrinsics.checkNotNullExpressionValue(fqName2, "parentClassSymbol.classId.packageFqName");
                FqName classPackage = fqName2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Private.INSTANCE)) break block2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if ($this$visibility$iv.getResolvedStatus().getVisibility().visibleFromPackage(classPackage, $this$isVisibleInClass.getCallableId().getPackageName())) break block3;
            }
            return false;
        }
        $this$visibility$iv = $this$isVisibleInClass;
        $i$f$getVisibility = false;
        return !Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Internal.INSTANCE) || Intrinsics.areEqual($this$isVisibleInClass.getModuleData(), parentClassSymbol.getModuleData()) && !$this$isVisibleInClass.getModuleData().getFriendDependencies().contains(parentClassSymbol.getModuleData());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final ImplementationStatus getImplementationStatus(@NotNull FirCallableSymbol<?> $this$getImplementationStatus, @NotNull SessionHolder sessionHolder, @NotNull FirClassSymbol<?> parentClassSymbol) {
        block23: {
            block24: {
                block22: {
                    block20: {
                        block19: {
                            block21: {
                                block18: {
                                    Intrinsics.checkNotNullParameter($this$getImplementationStatus, "<this>");
                                    Intrinsics.checkNotNullParameter(sessionHolder, "sessionHolder");
                                    Intrinsics.checkNotNullParameter(parentClassSymbol, "parentClassSymbol");
                                    containingClassSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$getImplementationStatus, sessionHolder.getSession());
                                    symbol = $this$getImplementationStatus;
                                    if (Intrinsics.areEqual(FirDelegatedMemberScopeKt.getMultipleDelegatesWithTheSameSignature($this$getImplementationStatus), true) && Intrinsics.areEqual(containingClassSymbol, parentClassSymbol)) {
                                        return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                    }
                                    if (!(symbol instanceof FirIntersectionCallableSymbol)) break block20;
                                    if (containingClassSymbol == parentClassSymbol && FirHelpersKt.subjectToManyNotImplemented((FirIntersectionCallableSymbol)symbol, sessionHolder)) {
                                        return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                    }
                                    $this$any$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v0 = false;
                                    } else {
                                        for (E element$iv : $this$any$iv) {
                                            it = (FirCallableSymbol)element$iv;
                                            $i$a$-any-FirHelpersKt$getImplementationStatus$1 = false;
                                            $this$unwrapFakeOverrides$iv = (FirCallableDeclaration)it.getFir();
                                            $i$f$unwrapFakeOverrides = false;
                                            current$iv = $this$unwrapFakeOverrides$iv;
                                            while (true) {
                                                $this$originalIfFakeOverride$iv$iv = current$iv;
                                                $i$f$originalIfFakeOverride = false;
                                                $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                $i$f$getOriginalForSubstitutionOverride = false;
                                                v1 = var18_22 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) != false ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                                                if (var18_22 == null) {
                                                    $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                    $i$f$getBaseForIntersectionOverride = false;
                                                    v2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                                                } else {
                                                    v2 = var19_23 = var18_22;
                                                }
                                                if (var19_23 == null) break;
                                                current$iv = next$iv = var19_23;
                                            }
                                            fir = current$iv;
                                            $this$isAbstract$iv = fir;
                                            $i$f$isAbstract = false;
                                            if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT != false && (($this$isAbstract$iv = ($i$f$isAbstract = FirHelpersKt.getContainingClassSymbol(fir, sessionHolder.getSession())) instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)$i$f$isAbstract : null) == null ? null : $this$isAbstract$iv.getClassKind()) == ClassKind.CLASS)) continue;
                                            v0 = true;
                                            break block18;
                                        }
                                        v0 = false;
                                    }
                                }
                                if (!v0) break block20;
                                $this$none$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                $i$f$none = false;
                                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block21;
                                v3 = true;
                                break block19;
                            }
                            for (E element$iv : $this$none$iv) {
                                it = (FirCallableSymbol)element$iv;
                                $i$a$-none-FirHelpersKt$getImplementationStatus$2 = false;
                                fir = (FirCallableDeclaration)it.getFir();
                                if (!Intrinsics.areEqual(fir.getOrigin(), FirDeclarationOrigin.Delegated.INSTANCE)) ** GOTO lbl-1000
                                $this$isAbstract$iv = fir;
                                $i$f$isAbstract = false;
                                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                                    v4 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v4 = false;
                                }
                                if (!v4) continue;
                                v3 = false;
                                break block19;
                            }
                            v3 = true;
                        }
                        if (v3) {
                            return ImplementationStatus.NOT_IMPLEMENTED;
                        }
                    }
                    if ($this$getImplementationStatus instanceof FirNamedFunctionSymbol) {
                        if (parentClassSymbol instanceof FirRegularClassSymbol) {
                            $this$isData$iv = (FirRegularClassSymbol)parentClassSymbol;
                            $i$f$isData = false;
                            if ($this$isData$iv.getResolvedStatus().isData() && FirHelpersKt.getMatchesDataClassSyntheticMemberSignatures((FirNamedFunctionSymbol)$this$getImplementationStatus)) {
                                return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                            }
                        }
                        $this$isSuspend$iv = $this$getImplementationStatus;
                        $i$f$isSuspend = false;
                        if ($this$isSuspend$iv.getResolvedStatus().isSuspend()) {
                            return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                        }
                    }
                    $this$isFinal$iv = $this$getImplementationStatus;
                    $i$f$isFinal = false;
                    var7_7 /* !! */  = $this$isFinal$iv.getResolvedStatus().getModality();
                    if (!(var7_7 /* !! */  == null ? true : (modality$iv = var7_7 /* !! */ ) == Modality.FINAL)) break block22;
                    v5 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
                    break block23;
                }
                if (containingClassSymbol != parentClassSymbol || !Intrinsics.areEqual($this$getImplementationStatus.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) break block24;
                v5 = ImplementationStatus.ALREADY_IMPLEMENTED;
                break block23;
            }
            if (!(containingClassSymbol instanceof FirRegularClassSymbol)) ** GOTO lbl-1000
            $this$isExpect$iv = (FirRegularClassSymbol)containingClassSymbol;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getResolvedStatus().isExpect()) {
                v5 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
            } else lbl-1000:
            // 2 sources

            {
                $this$isAbstract$iv = $this$getImplementationStatus;
                $i$f$isAbstract = false;
                v5 = $this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT != false ? ImplementationStatus.NOT_IMPLEMENTED : ImplementationStatus.INHERITED_OR_SYNTHESIZED;
            }
        }
        return v5;
    }

    private static final boolean subjectToManyNotImplemented(FirIntersectionCallableSymbol $this$subjectToManyNotImplemented, SessionHolder sessionHolder) {
        int nonAbstractCountInClass = 0;
        int nonAbstractCountInInterface = 0;
        int abstractCountInInterface = 0;
        for (FirCallableSymbol<?> intersectionSymbol : $this$subjectToManyNotImplemented.getIntersections()) {
            FirRegularClassSymbol containingClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)intersectionSymbol, sessionHolder.getSession());
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            boolean hasInterfaceContainer = (firRegularClassSymbol == null ? null : firRegularClassSymbol.getClassKind()) == ClassKind.INTERFACE;
            FirCallableSymbol<?> $this$modality$iv = intersectionSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.ABSTRACT) {
                if (hasInterfaceContainer) {
                    int n = nonAbstractCountInInterface;
                    nonAbstractCountInInterface = n + 1;
                } else {
                    int n = nonAbstractCountInClass;
                    nonAbstractCountInClass = n + 1;
                }
            } else if (hasInterfaceContainer) {
                int n = abstractCountInInterface;
                abstractCountInInterface = n + 1;
            }
            if (nonAbstractCountInClass + nonAbstractCountInInterface > 1) {
                return true;
            }
            if (nonAbstractCountInInterface <= 0 || abstractCountInInterface <= 0) continue;
            return true;
        }
        return false;
    }

    private static final boolean getMatchesDataClassSyntheticMemberSignatures(FirNamedFunctionSymbol $this$matchesDataClassSyntheticMemberSignatures) {
        Name name2 = $this$matchesDataClassSyntheticMemberSignatures.getCallableId().getCallableName();
        return Intrinsics.areEqual(name2, OperatorNameConventions.EQUALS) && FirHelpersKt.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual(name2, DefaultNamesKt.getHASHCODE_NAME()) && FirHelpersKt.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual(name2, OperatorNameConventions.TO_STRING) && FirHelpersKt.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
    }

    private static final boolean getMatchesEqualsSignature(FirNamedFunctionSymbol $this$matchesEqualsSignature) {
        List<FirValueParameterSymbol> valueParameters2 = $this$matchesEqualsSignature.getValueParameterSymbols();
        return valueParameters2.size() == 1 && ConeTypeUtilsKt.isNullableAny(FirTypeUtilsKt.getConeType(valueParameters2.get(0).getResolvedReturnTypeRef()));
    }

    private static final boolean getMatchesHashCodeSignature(FirNamedFunctionSymbol $this$matchesHashCodeSignature) {
        return $this$matchesHashCodeSignature.getValueParameterSymbols().isEmpty();
    }

    private static final boolean getMatchesToStringSignature(FirNamedFunctionSymbol $this$matchesToStringSignature) {
        return $this$matchesToStringSignature.getValueParameterSymbols().isEmpty();
    }

    public static final boolean isDelegated(@NotNull Name $this$isDelegated) {
        Intrinsics.checkNotNullParameter($this$isDelegated, "<this>");
        String string2 = $this$isDelegated.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString()");
        return StringsKt.startsWith$default(string2, "<$$delegate_", false, 2, null);
    }

    public static final boolean isConflictingOrNotInvariant(@NotNull ConeTypeProjection $this$isConflictingOrNotInvariant) {
        Intrinsics.checkNotNullParameter($this$isConflictingOrNotInvariant, "<this>");
        return $this$isConflictingOrNotInvariant.getKind() != ProjectionKind.INVARIANT || $this$isConflictingOrNotInvariant instanceof ConeKotlinTypeConflictingProjection;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void checkTypeMismatch(@NotNull ConeKotlinType lValueOriginalType, @Nullable FirVariableAssignment assignment, @NotNull FirExpression rValue, @NotNull CheckerContext context2, @NotNull FirSourceElement source, @NotNull DiagnosticReporter reporter2, boolean isInitializer) {
        FirCallableSymbol<?> firCallableSymbol;
        ConeInferenceContext typeContext;
        Intrinsics.checkNotNullParameter(lValueOriginalType, "lValueOriginalType");
        Intrinsics.checkNotNullParameter(rValue, "rValue");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        ConeKotlinType lValueType = lValueOriginalType;
        ConeKotlinType rValueType = FirTypeUtilsKt.getConeType(rValue.getTypeRef());
        if (source.getKind() instanceof FirFakeSourceElementKind.DesugaredIncrementOrDecrement && !ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType tempType = rValueType;
            rValueType = lValueType;
            lValueType = tempType;
        }
        if (FirHelpersKt.isSubtypeForTypeMismatch(typeContext = SessionUtilsKt.getTypeContext(context2.getSession()), rValueType, lValueType)) return;
        if (rValueType instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)rValueType).getLookupTag().getClassId(), StandardClassIds.INSTANCE.getInt()) && ConeTypeUtilsKt.isIntegerTypeOrNullableIntegerTypeOfAnySize(TypeExpansionUtilsKt.fullyExpandedType(lValueType, context2.getSession())) && rValueType.getNullability() == ConeNullability.NOT_NULL) {
            return;
        }
        if (CompilerConeAttributesKt.isExtensionFunctionType(lValueType)) return;
        if (CompilerConeAttributesKt.isExtensionFunctionType(rValueType)) {
            return;
        }
        FirVariableAssignment firVariableAssignment = assignment;
        if (firVariableAssignment == null) {
            firCallableSymbol = null;
        } else {
            FirReference firReference = firVariableAssignment.getCalleeReference();
            firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(firReference);
        }
        FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
        FirPropertySymbol resolvedSymbol = firCallableSymbol2 instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol2 : null;
        if (resolvedSymbol != null && lValueType instanceof ConeCapturedType) {
            ProjectionKind projectionKind;
            ProjectionKind projectionKind2 = projectionKind = ((ConeCapturedType)lValueType).getConstructor().getProjection().getKind();
            boolean bl = false;
            boolean bl2 = projectionKind2 == ProjectionKind.STAR || projectionKind2 == ProjectionKind.OUT;
            if (bl2) {
                DiagnosticReporterKt.reportOn$default(reporter2, assignment.getSource(), FirErrors.INSTANCE.getSETTER_PROJECTED_OUT(), (Object)resolvedSymbol, context2, null, 16, null);
                return;
            }
        }
        if (FirTypeUtilsKt.isNullLiteral(rValue) && lValueType.getNullability() == ConeNullability.NOT_NULL) {
            DiagnosticReporterKt.reportOn$default(reporter2, rValue.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), context2, null, 8, null);
            return;
        }
        if (isInitializer) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, context2, null, 32, null);
            return;
        }
        if (!(source.getKind() instanceof FirFakeSourceElementKind.DesugaredIncrementOrDecrement)) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getASSIGNMENT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, context2, null, 32, null);
            return;
        }
        if (!ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType coneKotlinType = rValueType;
            rValueType = lValueType;
            lValueType = coneKotlinType;
        }
        if (ConeTypeUtilsKt.isUnit(rValueType)) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getINC_DEC_SHOULD_NOT_RETURN_UNIT(), context2, null, 8, null);
            return;
        }
        DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getRESULT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, context2, null, 32, null);
    }

    public static final void checkCondition(@NotNull FirExpression condition, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneType;
        Intrinsics.checkNotNullParameter(condition, "condition");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirTypeRef $this$coneTypeSafe$iv = condition.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        ConeKotlinType coneKotlinType3 = coneType = (coneKotlinType = coneKotlinType2) == null ? null : ConeTypesKt.lowerBoundIfFlexible(coneKotlinType);
        if (coneType != null && !(coneType instanceof ConeClassErrorType) && !FirHelpersKt.isSubtypeOf(coneType, SessionUtilsKt.getTypeContext(context2.getSession()), context2.getSession().getBuiltinTypes().getBooleanType().getType())) {
            DiagnosticReporterKt.reportOn$default(reporter2, condition.getSource(), FirErrors.INSTANCE.getCONDITION_TYPE_MISMATCH(), (Object)coneType, context2, null, 16, null);
        }
    }

    @Nullable
    public static final FirTypeRefSource extractArgumentTypeRefAndSource(@Nullable FirTypeRef typeRef, int index2) {
        if (typeRef instanceof FirResolvedTypeRef) {
            FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
            if (delegatedTypeRef instanceof FirUserTypeRef) {
                int currentIndex = index2;
                List<FirQualifierPart> qualifier = ((FirUserTypeRef)delegatedTypeRef).getQualifier();
                int n = qualifier.size() - 1;
                if (0 <= n) {
                    do {
                        int i;
                        List<FirTypeProjection> typeArguments2;
                        if (currentIndex < (typeArguments2 = qualifier.get(i = n--).getTypeArgumentList().getTypeArguments()).size()) {
                            FirTypeRefSource firTypeRefSource;
                            List<FirTypeProjection> list2 = typeArguments2;
                            FirTypeProjection typeArgument = CollectionsKt.getOrNull(list2, currentIndex);
                            if (typeArgument != null) {
                                list2 = typeArgument instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)typeArgument : null;
                                firTypeRefSource = new FirTypeRefSource(list2 == null ? null : ((FirTypeProjectionWithVariance)((Object)list2)).getTypeRef(), typeArgument.getSource());
                            } else {
                                firTypeRefSource = null;
                            }
                            return firTypeRefSource;
                        }
                        currentIndex -= typeArguments2.size();
                    } while (0 <= n);
                }
            } else if (delegatedTypeRef instanceof FirFunctionTypeRef) {
                List<FirValueParameter> valueParameters2 = ((FirFunctionTypeRef)delegatedTypeRef).getValueParameters();
                if (index2 < valueParameters2.size()) {
                    List<FirValueParameter> list3 = valueParameters2;
                    FirTypeRef valueParamTypeRef = list3.get(index2).getReturnTypeRef();
                    return new FirTypeRefSource(valueParamTypeRef, valueParamTypeRef.getSource());
                }
                if (index2 == valueParameters2.size()) {
                    FirTypeRef returnTypeRef = ((FirFunctionTypeRef)delegatedTypeRef).getReturnTypeRef();
                    return new FirTypeRefSource(returnTypeRef, returnTypeRef.getSource());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntrySymbol> collectEnumEntries(@NotNull FirRegularClassSymbol $this$collectEnumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$collectEnumEntries, "<this>");
        boolean bl2 = bl = $this$collectEnumEntries.getClassKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$filterIsInstance$iv = $this$collectEnumEntries.getDeclarationSymbols();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntrySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ClassKind getClassKind(@NotNull FirClassLikeSymbol<?> $this$classKind) {
        Intrinsics.checkNotNullParameter($this$classKind, "<this>");
        FirClassSymbol firClassSymbol = $this$classKind instanceof FirClassSymbol ? (FirClassSymbol)$this$classKind : null;
        return firClassSymbol == null ? null : firClassSymbol.getClassKind();
    }

    @Nullable
    public static final List<FirTypeParameterSymbol> getTypeParameterSymbols(@NotNull FirBasedSymbol<?> $this$typeParameterSymbols) {
        Intrinsics.checkNotNullParameter($this$typeParameterSymbols, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$typeParameterSymbols;
        return firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirClassSymbol ? ((FirClassSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirTypeAliasSymbol ? ((FirTypeAliasSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : null));
    }

    public static final boolean isFunctionForExpectTypeFromCastFeature(@NotNull FirFunctionSymbol<?> $this$isFunctionForExpectTypeFromCastFeature) {
        boolean bl;
        Object object;
        FirTypeParameterSymbol typeParameterSymbol;
        block5: {
            Intrinsics.checkNotNullParameter($this$isFunctionForExpectTypeFromCastFeature, "<this>");
            FirTypeParameterSymbol firTypeParameterSymbol = CollectionsKt.singleOrNull($this$isFunctionForExpectTypeFromCastFeature.getTypeParameterSymbols());
            if (firTypeParameterSymbol == null) {
                return false;
            }
            typeParameterSymbol = firTypeParameterSymbol;
            ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType($this$isFunctionForExpectTypeFromCastFeature.getResolvedReturnTypeRef());
            ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible(returnType2);
            object = coneKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneKotlinType : null;
            if (!Intrinsics.areEqual(object == null ? null : ((ConeTypeParameterType)object).getLookupTag(), typeParameterSymbol.toLookupTag())) {
                return false;
            }
            Iterable $this$any$iv = $this$isFunctionForExpectTypeFromCastFeature.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (!FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType(it.getResolvedReturnTypeRef(), typeParameterSymbol)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return !bl && !((object = $this$isFunctionForExpectTypeFromCastFeature.getResolvedReceiverTypeRef()) == null ? false : FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType((FirTypeRef)object, typeParameterSymbol));
    }

    @NotNull
    public static final AnnotationTargetList getActualTargetList(@NotNull FirDeclaration annotated) {
        AnnotationTargetList annotationTargetList;
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        FirDeclaration firDeclaration = annotated;
        if (firDeclaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)((Object)annotated);
            boolean $i$f$isInner = false;
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)annotated;
            boolean $i$f$isCompanion = false;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)annotated;
            boolean $i$f$isLocal = false;
            AnnotationTargetList annotationTargetList2 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(((FirRegularClass)annotated).getClassKind(), $this$isInner$iv.getStatus().isInner(), $this$isCompanion$iv.getStatus().isCompanion(), $this$isLocal$iv.getSymbol().getClassId().isLocal()), null, null, 6, null);
            annotationTargetList = annotationTargetList2;
        } else if (firDeclaration instanceof FirEnumEntry) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)((Object)annotated);
            boolean $i$f$isInner = false;
            AnnotationTargetList annotationTargetList3 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, $this$isInner$iv.getStatus().isInner(), false, false), null, null, 6, null);
            annotationTargetList = annotationTargetList3;
        } else if (firDeclaration instanceof FirProperty) {
            FirSourceElement $this$isInner$iv;
            annotationTargetList = ((FirProperty)annotated).isLocal() ? (Intrinsics.areEqual(($this$isInner$iv = annotated.getSource()) == null ? null : $this$isInner$iv.getKind(), FirFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE()) : (FirHelpersKt.getActualTargetList$isMember(((FirProperty)annotated).getSymbol().getCallableId()) ? (Intrinsics.areEqual(($this$isInner$iv = annotated.getSource()) == null ? null : $this$isInner$iv.getKind(), FirFakeSourceElementKind.PropertyFromParameter.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.T_MEMBER_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null)) : AnnotationTargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null));
        } else if (firDeclaration instanceof FirValueParameter) {
            annotationTargetList = FirHelpersKt.getHasValOrVar((FirValueParameter)annotated) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL();
        } else if (firDeclaration instanceof FirConstructor) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_CONSTRUCTOR();
        } else if (firDeclaration instanceof FirAnonymousFunction) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FUNCTION_EXPRESSION();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)annotated;
            boolean $i$f$isLocal = false;
            annotationTargetList = Intrinsics.areEqual($this$isLocal$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (FirHelpersKt.getActualTargetList$isMember(((FirSimpleFunction)annotated).getSymbol().getCallableId()) ? AnnotationTargetLists.INSTANCE.getT_MEMBER_FUNCTION() : AnnotationTargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION());
        } else {
            FirSourceElement firSourceElement;
            annotationTargetList = firDeclaration instanceof FirTypeAlias ? AnnotationTargetLists.INSTANCE.getT_TYPEALIAS() : (firDeclaration instanceof FirPropertyAccessor ? (((FirPropertyAccessor)annotated).isGetter() ? AnnotationTargetLists.INSTANCE.getT_PROPERTY_GETTER() : AnnotationTargetLists.INSTANCE.getT_PROPERTY_SETTER()) : (firDeclaration instanceof FirFile ? AnnotationTargetLists.INSTANCE.getT_FILE() : (firDeclaration instanceof FirTypeParameter ? AnnotationTargetLists.INSTANCE.getT_TYPE_PARAMETER() : (firDeclaration instanceof FirAnonymousInitializer ? AnnotationTargetLists.INSTANCE.getT_INITIALIZER() : (firDeclaration instanceof FirAnonymousObject ? (Intrinsics.areEqual((firSourceElement = annotated.getSource()) == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.EnumInitializer.INSTANCE) ? new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, false, false, false), null, null, 6, null) : AnnotationTargetLists.INSTANCE.getT_OBJECT_LITERAL()) : AnnotationTargetLists.INSTANCE.getEMPTY())))));
        }
        return annotationTargetList;
    }

    private static final boolean isSupertypeOf$isSupertypeOf(FirClassSymbol<?> $this$isSupertypeOf_u24isSupertypeOf, FirSession $session, FirClassSymbol<?> other, Set<FirClassSymbol<?>> exclude) {
        for (FirResolvedTypeRef it : other.getResolvedSuperTypeRefs()) {
            FirClassSymbol candidate2;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(it, $session);
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol == null ? null : FirHelpersKt.fullyExpandedClass(firClassLikeSymbol, $session);
            FirClassSymbol firClassSymbol = firRegularClassSymbol instanceof FirClassSymbol ? (FirClassSymbol)firRegularClassSymbol : null;
            if (firClassSymbol == null || exclude.contains(candidate2 = firClassSymbol)) continue;
            exclude.add(candidate2);
            if (Intrinsics.areEqual(candidate2, $this$isSupertypeOf_u24isSupertypeOf)) {
                return true;
            }
            if (!FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf_u24isSupertypeOf, $session, candidate2, exclude)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isFunctionForExpectTypeFromCastFeature$isBadType(FirTypeRef $this$isFunctionForExpectTypeFromCastFeature_u24isBadType, FirTypeParameterSymbol typeParameterSymbol) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneTypeSafe$iv = $this$isFunctionForExpectTypeFromCastFeature_u24isBadType;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        return !((coneKotlinType = coneKotlinType2) == null ? false : !ConeTypeUtilsKt.contains(coneKotlinType, (Function1<? super ConeKotlinType, Boolean>)new Function1<ConeKotlinType, Boolean>(typeParameterSymbol){
            final /* synthetic */ FirTypeParameterSymbol $typeParameterSymbol;
            {
                this.$typeParameterSymbol = $typeParameterSymbol;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConeKotlinType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible(it);
                ConeTypeParameterType coneTypeParameterType = coneKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneKotlinType : null;
                return Intrinsics.areEqual(coneTypeParameterType == null ? null : coneTypeParameterType.getLookupTag(), this.$typeParameterSymbol.toLookupTag());
            }
        }));
    }

    private static final boolean getActualTargetList$isMember(CallableId $this$getActualTargetList_u24isMember) {
        return $this$getActualTargetList_u24isMember.getClassId() != null || $this$getActualTargetList_u24isMember.isLocal();
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.InlineOnly"));
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(FqName(\"kotlin.internal.InlineOnly\"))");
        INLINE_ONLY_ANNOTATION_CLASS_ID = classId;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

