/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUpperBoundViolatedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUpperBoundViolatedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirUpperBoundViolatedExpressionChecker INSTANCE = new FirUpperBoundViolatedExpressionChecker();

    private FirUpperBoundViolatedExpressionChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        List<FirTypeParameterSymbol> list2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirReference calleReference = expression2.getCalleeReference();
        FirCallableSymbol calleeSymbol = null;
        if (calleReference instanceof FirResolvedNamedReference) {
            calleeSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(calleReference);
        } else if (calleReference instanceof FirErrorNamedReference) {
            ConeDiagnostic diagnostic = ((FirErrorNamedReference)calleReference).getDiagnostic();
            if (diagnostic instanceof ConeInapplicableCandidateError && ((ConeInapplicableCandidateError)diagnostic).getApplicability() == CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER) {
                return;
            }
            FirBasedSymbol<?> firBasedSymbol = ((FirErrorNamedReference)calleReference).getCandidateSymbol();
            calleeSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        }
        List<FirTypeProjection> typeArguments2 = null;
        List typeArgumentRefsAndSources = null;
        if (calleeSymbol instanceof FirConstructorSymbol) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expression2.getTypeArguments();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirTypeProjectionWithVariance firTypeProjectionWithVariance = it instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)it : null;
                FirTypeRefSource firTypeRefSource = new FirTypeRefSource(firTypeProjectionWithVariance == null ? null : firTypeProjectionWithVariance.getTypeRef(), it.getSource());
                collection.add(firTypeRefSource);
            }
            typeArgumentRefsAndSources = (List)destination$iv$iv;
            object = calleeSymbol.getDispatchReceiverType();
            FirRegularClassSymbol firRegularClassSymbol = object == null ? null : TypeUtilsKt.toSymbol((ConeKotlinType)object, context2.getSession());
            FirRegularClassSymbol prototypeClass = firRegularClassSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firRegularClassSymbol : null;
            list2 = (firRegularClassSymbol = prototypeClass) == null ? null : firRegularClassSymbol.getTypeParameterSymbols();
        } else {
            typeArguments2 = expression2.getTypeArguments();
            FirCallableSymbol firCallableSymbol = calleeSymbol;
            list2 = firCallableSymbol == null ? null : firCallableSymbol.getTypeParameterSymbols();
        }
        List<FirTypeParameterSymbol> typeParameters2 = list2;
        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(expression2.getTypeRef(), context2, reporter2, typeParameters2, typeArguments2, typeArgumentRefsAndSources, false, false, 192, null);
    }
}

