/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ%\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J?\u0010\u0011\u001a\u00020\u00002$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0016J\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0004`\u0006J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping;", "", "parameterToCallArgumentMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "diagnostics", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "(Ljava/util/LinkedHashMap;Ljava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "getParameterToCallArgumentMap", "()Ljava/util/LinkedHashMap;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "numDefaults", "toArgumentToParameterMapping", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toString", "", "resolve"})
public final class ArgumentMapping {
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap;
    @NotNull
    private final List<ResolutionDiagnostic> diagnostics;

    public ArgumentMapping(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics2) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, "parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
        this.parameterToCallArgumentMap = parameterToCallArgumentMap;
        this.diagnostics = diagnostics2;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getParameterToCallArgumentMap() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirExpression, FirValueParameter> toArgumentToParameterMapping() {
        LinkedHashMap<FirExpression, FirValueParameter> argumentToParameterMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        Map $this$forEach$iv = this.parameterToCallArgumentMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$valueParameter$resolvedArgument = element$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $dstr$valueParameter$resolvedArgument;
            FirValueParameter valueParameter2 = (FirValueParameter)entry.getKey();
            Object object = $dstr$valueParameter$resolvedArgument;
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object.getValue();
            if ((object = resolvedArgument) instanceof ResolvedCallArgument.SimpleArgument) {
                Map map2 = argumentToParameterMapping;
                FirExpression firExpression2 = ((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument();
                map2.put(firExpression2, valueParameter2);
                continue;
            }
            if (object instanceof ResolvedCallArgument.VarargArgument) {
                Iterable $this$forEach$iv2 = resolvedArgument.getArguments();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    FirExpression it = (FirExpression)element$iv2;
                    boolean bl2 = false;
                    Map map3 = argumentToParameterMapping;
                    map3.put(it, valueParameter2);
                }
                continue;
            }
            if (!Intrinsics.areEqual(object, ResolvedCallArgument.DefaultArgument.INSTANCE)) continue;
        }
        return argumentToParameterMapping;
    }

    /*
     * WARNING - void declaration
     */
    public final int numDefaults() {
        int n;
        Collection<ResolvedCallArgument> collection = this.parameterToCallArgumentMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "parameterToCallArgumentMap.values");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int n2;
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it, ResolvedCallArgument.DefaultArgument.INSTANCE) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> component1() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> component2() {
        return this.diagnostics;
    }

    @NotNull
    public final ArgumentMapping copy(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics2) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, "parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
        return new ArgumentMapping(parameterToCallArgumentMap, diagnostics2);
    }

    public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping, LinkedHashMap linkedHashMap, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            linkedHashMap = argumentMapping.parameterToCallArgumentMap;
        }
        if ((n & 2) != 0) {
            list2 = argumentMapping.diagnostics;
        }
        return argumentMapping.copy(linkedHashMap, list2);
    }

    @NotNull
    public String toString() {
        return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
    }

    public int hashCode() {
        int result2 = this.parameterToCallArgumentMap.hashCode();
        result2 = result2 * 31 + ((Object)this.diagnostics).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArgumentMapping)) {
            return false;
        }
        ArgumentMapping argumentMapping = (ArgumentMapping)other;
        if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping.parameterToCallArgumentMap)) {
            return false;
        }
        return Intrinsics.areEqual(this.diagnostics, argumentMapping.diagnostics);
    }
}

