/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutorByMap;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "substitution", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSubstitution", "()Ljava/util/Map;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "substituteType", "type", "toString", "", "resolve"})
public final class ConeSubstitutorByMap
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeKotlinType> substitution;
    @NotNull
    private final FirSession useSiteSession;

    public ConeSubstitutorByMap(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(substitution, "substitution");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        super(SessionUtilsKt.getTypeContext(useSiteSession));
        this.substitution = substitution;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> getSubstitution() {
        return this.substitution;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeKotlinType coneKotlinType = this.updateNullabilityIfNeeded(this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol()), type2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType result2 = coneKotlinType;
        if (TypeUtilsKt.isUnsafeVarianceType(type2, this.useSiteSession)) {
            coneKotlinType = InferenceComponentsKt.getInferenceComponents(this.useSiteSession).getApproximator().approximateToSuperType(result2, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
            return coneKotlinType == null ? result2 : coneKotlinType;
        }
        return result2;
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> component1() {
        return this.substitution;
    }

    @NotNull
    public final FirSession component2() {
        return this.useSiteSession;
    }

    @NotNull
    public final ConeSubstitutorByMap copy(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(substitution, "substitution");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        return new ConeSubstitutorByMap(substitution, useSiteSession);
    }

    public static /* synthetic */ ConeSubstitutorByMap copy$default(ConeSubstitutorByMap coneSubstitutorByMap, Map map2, FirSession firSession, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = coneSubstitutorByMap.substitution;
        }
        if ((n & 2) != 0) {
            firSession = coneSubstitutorByMap.useSiteSession;
        }
        return coneSubstitutorByMap.copy(map2, firSession);
    }

    @NotNull
    public String toString() {
        return "ConeSubstitutorByMap(substitution=" + this.substitution + ", useSiteSession=" + this.useSiteSession + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.substitution).hashCode();
        result2 = result2 * 31 + this.useSiteSession.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConeSubstitutorByMap)) {
            return false;
        }
        ConeSubstitutorByMap coneSubstitutorByMap = (ConeSubstitutorByMap)other;
        if (!Intrinsics.areEqual(this.substitution, coneSubstitutorByMap.substitution)) {
            return false;
        }
        return Intrinsics.areEqual(this.useSiteSession, coneSubstitutorByMap.useSiteSession);
    }
}

