/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "process", "", "files", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "InheritorsCollector", "InheritorsTransformer", "resolve"})
public final class FirSealedClassInheritorsProcessor
extends FirGlobalResolveProcessor {
    public FirSealedClassInheritorsProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(session2, scopeSession);
    }

    @Override
    public void process(@NotNull Collection<? extends FirFile> files2) {
        FirFile it;
        Intrinsics.checkNotNullParameter(files2, "files");
        Map sealedClassInheritorsMap = new LinkedHashMap();
        InheritorsCollector inheritorsCollector = new InheritorsCollector(this.getSession());
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            it.accept(inheritorsCollector, sealedClassInheritorsMap);
        }
        $this$forEach$iv = files2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            FirTransformerUtilKt.transformSingle((FirElement)it, new InheritorsTransformer(sealedClassInheritorsMap), null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00042\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "extractClassFromTypeRef", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitRegularClass", "regularClass", "resolve"})
    public static final class InheritorsCollector
    extends FirDefaultVisitor<Unit, Map<FirRegularClass, List<ClassId>>> {
        @NotNull
        private final FirSession session;

        public InheritorsCollector(@NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(session2, "session");
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Map<FirRegularClass, List<ClassId>> data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitFile(@NotNull FirFile file2, @NotNull Map<FirRegularClass, List<ClassId>> data2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(data2, "data");
            Iterable $this$forEach$iv = file2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data2);
            }
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<FirRegularClass, List<ClassId>> data2) {
            FirDeclaration it;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data2, "data");
            Iterable $this$forEach$iv = regularClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data2);
            }
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
                data2.computeIfAbsent(regularClass, InheritorsCollector::visitRegularClass$lambda-2);
            }
            FirSymbolProvider symbolProvider2 = MainSessionComponentsKt.getSymbolProvider(this.session);
            for (FirTypeRef typeRef : regularClass.getSuperTypeRefs()) {
                FirDeclaration parent2;
                Modality modality;
                Object object = this.extractClassFromTypeRef(symbolProvider2, typeRef);
                FirRegularClass it2 = object;
                boolean bl = false;
                FirRegularClass firRegularClass = it2;
                if (firRegularClass == null) {
                    modality = null;
                } else {
                    FirMemberDeclaration $this$modality$iv2 = firRegularClass;
                    boolean $i$f$getModality2 = false;
                    modality = $this$modality$iv2.getStatus().getModality();
                }
                if ((it = modality == Modality.SEALED ? object : null) == null || !Intrinsics.areEqual(FirDeclarationUtilKt.getClassId((FirClass)(parent2 = it)).getPackageFqName(), FirDeclarationUtilKt.getClassId(regularClass).getPackageFqName())) continue;
                object = data2.computeIfAbsent((FirRegularClass)parent2, InheritorsCollector::visitRegularClass$lambda-4);
                Intrinsics.checkNotNullExpressionValue(object, "data.computeIfAbsent(parent) { mutableListOf() }");
                List inheritors = (List)object;
                ((Collection)inheritors).add(regularClass.getSymbol().getClassId());
            }
        }

        private final FirRegularClass extractClassFromTypeRef(FirSymbolProvider symbolProvider2, FirTypeRef typeRef) {
            FirRegularClass firRegularClass;
            ConeLookupTagBasedType coneLookupTagBasedType;
            FirClassifierSymbol<?> firClassifierSymbol = FirTypeUtilsKt.getConeType(typeRef);
            ConeLookupTagBasedType coneLookupTagBasedType2 = coneLookupTagBasedType = firClassifierSymbol instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)((Object)firClassifierSymbol) : null;
            if (coneLookupTagBasedType == null) {
                return null;
            }
            ConeClassifierLookupTag lookupTag = coneLookupTagBasedType.getLookupTag();
            firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag(symbolProvider2, lookupTag);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> classLikeSymbol = firClassifierSymbol;
            if ((firClassifierSymbol = classLikeSymbol) instanceof FirRegularClassSymbol) {
                firRegularClass = (FirRegularClass)((FirRegularClassSymbol)classLikeSymbol).getFir();
            } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
                FirPhaseManagerKt.ensureResolved((FirBasedSymbol)classLikeSymbol, FirResolvePhase.SUPER_TYPES);
                firRegularClass = this.extractClassFromTypeRef(symbolProvider2, ((FirTypeAlias)((FirTypeAliasSymbol)classLikeSymbol).getFir()).getExpandedTypeRef());
            } else {
                firRegularClass = null;
            }
            return firRegularClass;
        }

        private static final List visitRegularClass$lambda-2(FirRegularClass it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new ArrayList();
        }

        private static final List visitRegularClass$lambda-4(FirRegularClass it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new ArrayList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0002\u0010\bJ)\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "inheritorsMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Ljava/util/Map;)V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "resolve"})
    public static final class InheritorsTransformer
    extends FirTransformer<Object> {
        @NotNull
        private final Map<FirRegularClass, List<ClassId>> inheritorsMap;

        public InheritorsTransformer(@NotNull Map<FirRegularClass, List<ClassId>> inheritorsMap) {
            Intrinsics.checkNotNullParameter(inheritorsMap, "inheritorsMap");
            this.inheritorsMap = inheritorsMap;
        }

        @Override
        @NotNull
        public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            return element;
        }

        @Override
        @NotNull
        public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            return (FirFile)file2.transformChildren(this, data2);
        }

        @Override
        @NotNull
        public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
            List<ClassId> inheritors;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED && (inheritors = this.inheritorsMap.remove(regularClass)) != null) {
                SealedClassInheritorsKt.setSealedClassInheritors(regularClass, inheritors);
            }
            if (this.inheritorsMap.isEmpty()) {
                return regularClass;
            }
            return (FirRegularClass)regularClass.transformChildren(this, data2);
        }
    }
}

