/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KClassProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001eH\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "_arguments", "", "Lkotlin/reflect/KTypeProjection;", "_classifier", "Lkotlin/reflect/KClassifier;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "equals", "", "other", "", "getArguments", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getClassifier", "hashCode", "", "toString", "", "getVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "ir.interpreter"})
public final class KTypeState
extends ReflectionState {
    @NotNull
    private final IrType irType;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private KClassifier _classifier;
    @Nullable
    private List<KTypeProjection> _arguments;

    public KTypeState(@NotNull IrType irType, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        this.irType = irType;
        this.irClass = irClass2;
    }

    @NotNull
    public final IrType getIrType() {
        return this.irType;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Nullable
    public final KClassifier getClassifier(@NotNull CallInterceptor callInterceptor) {
        KClassifier kClassifier;
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        if (this._classifier != null) {
            KClassifier kClassifier2 = this._classifier;
            Intrinsics.checkNotNull(kClassifier2);
            return kClassifier2;
        }
        IrSymbolOwner classifier2 = IrTypesKt.getClassifierOrFail(this.irType).getOwner();
        if (classifier2 instanceof IrClass) {
            kClassifier = new KClassProxy(new KClassState((IrClass)classifier2, (IrClass)callInterceptor.getIrBuiltIns().getKClassClass().getOwner()), callInterceptor);
        } else if (classifier2 instanceof IrTypeParameter) {
            IrClass kTypeParameterIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeParameterClass$ir_interpreter().getOwner();
            kClassifier = new KTypeParameterProxy(new KTypeParameterState((IrTypeParameter)classifier2, kTypeParameterIrClass), callInterceptor);
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        KClassifier kClassifier3 = this._classifier = kClassifier;
        Intrinsics.checkNotNull(kClassifier3);
        return kClassifier3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KTypeProjection> getArguments(@NotNull CallInterceptor callInterceptor) {
        Collection<KTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        if (this._arguments != null) {
            List<KTypeProjection> list2 = this._arguments;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        Object object = callInterceptor.getEnvironment();
        Map<Class<?>, IrClass> map2 = ((IrInterpreterEnvironment)object).getJavaClassToIrClass$ir_interpreter();
        Pair pair = TuplesKt.to(KTypeProjection.class, callInterceptor.getEnvironment().getKTypeProjectionClass$ir_interpreter().getOwner());
        map2.put(pair.getFirst(), (IrClass)pair.getSecond());
        object = ((IrSimpleType)this.irType).getArguments();
        KTypeState kTypeState = this;
        boolean $i$f$map = false;
        pair = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KTypeProjection kTypeProjection;
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Variance variance = this.getVariance((IrTypeArgument)it);
            int n = variance == null ? -1 : WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
            switch (n) {
                case 1: {
                    IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull(irType);
                    kTypeProjection = KTypeProjection.Companion.invariant(new KTypeProxy(new KTypeState(irType, this.getIrClass()), callInterceptor));
                    break;
                }
                case 2: {
                    IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull(irType);
                    kTypeProjection = KTypeProjection.Companion.contravariant(new KTypeProxy(new KTypeState(irType, this.getIrClass()), callInterceptor));
                    break;
                }
                case 3: {
                    IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
                    Intrinsics.checkNotNull(irType);
                    kTypeProjection = KTypeProjection.Companion.covariant(new KTypeProxy(new KTypeState(irType, this.getIrClass()), callInterceptor));
                    break;
                }
                case -1: {
                    kTypeProjection = KTypeProjection.Companion.getSTAR();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KTypeProjection kTypeProjection2 = kTypeProjection;
            collection.add(kTypeProjection2);
        }
        collection = (List)destination$iv$iv;
        kTypeState._arguments = collection;
        List<KTypeProjection> list3 = this._arguments;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    private final Variance getVariance(IrTypeArgument $this$getVariance) {
        Variance variance;
        IrTypeArgument irTypeArgument = $this$getVariance;
        if (irTypeArgument instanceof IrSimpleType) {
            variance = Variance.INVARIANT;
        } else if (irTypeArgument instanceof IrTypeProjection) {
            variance = ((IrTypeProjection)$this$getVariance).getVariance();
        } else if (irTypeArgument instanceof IrStarProjection) {
            variance = null;
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return variance;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
        }
        KTypeState cfr_ignored_0 = (KTypeState)other;
        return Intrinsics.areEqual(this.irType, ((KTypeState)other).irType);
    }

    public int hashCode() {
        return this.irType.hashCode();
    }

    @NotNull
    public String toString() {
        return this.renderType(this.irType);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

