/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016JZ\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J@\u0010*\u001a\b\u0012\u0004\u0012\u00020+0$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J<\u00104\u001a\u0004\u0018\u0001052\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u0002072\u0006\u0010,\u001a\u00020-2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002JH\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)J:\u0010<\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)H\u0002Jn\u0010>\u001a\u00020?2*\u0010@\u001a&\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020/0A2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J8\u0010>\u001a\u00020?2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)J@\u0010G\u001a\u00020?2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)J:\u0010H\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020J2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)J8\u0010K\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020M2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)JN\u0010N\u001a\b\u0012\u0004\u0012\u00020+0$2\u0006\u0010.\u001a\u00020O2\u0006\u0010P\u001a\u0002012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\f\u0010R\u001a\u00020\u001e*\u000203H\u0002J\u000e\u0010S\u001a\u0004\u0018\u000103*\u000203H\u0002J\u001c\u0010T\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010$*\u0002032\u0006\u0010U\u001a\u00020OH\u0002J\f\u0010V\u001a\u000203*\u000203H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getContractProvider", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "initializeFunctionDescriptorAndExplicitReturnType", "", "container", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "containingDescriptor", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedParameterTypes", "functionTypeExpected", "getReceiverType", "getValueParameters", "owner", "removeParameterNameAnnotation", "frontend"})
public final class FunctionDescriptorResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ModifiersChecker modifiersChecker;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final ContractParsingServices contractParsingServices;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final StorageManager storageManager;

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker, @NotNull ContractParsingServices contractParsingServices, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(typeResolver, "typeResolver");
        Intrinsics.checkNotNullParameter(descriptorResolver, "descriptorResolver");
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(modifiersChecker, "modifiersChecker");
        Intrinsics.checkNotNullParameter(overloadChecker, "overloadChecker");
        Intrinsics.checkNotNullParameter(contractParsingServices, "contractParsingServices");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
        this.contractParsingServices = contractParsingServices;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(containingDescriptor, "containingDescriptor");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor(function5, containingDescriptor, scope2, function2, trace, dataFlowInfo, simpleType2, inferenceSession);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(containingDescriptor, "containingDescriptor");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(expectedFunctionType, "expectedFunctionType");
        return this.resolveFunctionDescriptor(resolveFunctionExpressionDescriptor.1.INSTANCE, containingDescriptor, scope2, function2, trace, dataFlowInfo, expectedFunctionType, inferenceSession);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function2.getModifierList(), trace);
        Name name2 = function2.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue(name2, "function.nameAsSafeName");
        SimpleFunctionDescriptorImpl functionDescriptor = functionConstructor.invoke(containingDescriptor, annotations2, name2, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function2, functionDescriptor, trace, expectedFunctionType, dataFlowInfo, inferenceSession);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function2, functionDescriptor, trace, dataFlowInfo, inferenceSession);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        boolean bl;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl2 = bl = function2.getTypeReference() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Return type must be initialized early for function: " + function2.getText() + ", at: " + PsiDiagnosticUtils.atLocation(function2);
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = function2.hasBlockBody() ? (KotlinType)this.builtIns.getUnitType() : (function2.hasBody() ? this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope2, dataFlowInfo, function2, functionDescriptor, inferenceSession) : (KotlinType)ErrorUtils.createErrorType("No type, no body"));
        Intrinsics.checkNotNullExpressionValue(kotlinType, "when {\n            funct\u2026type, no body\")\n        }");
        KotlinType inferredReturnType = kotlinType;
        functionDescriptor.setReturnType(inferredReturnType);
    }

    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scope2, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        Iterator<ValueParameterDescriptor> it;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Map map2;
        Object it2;
        Object object;
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expectedFunctionType, "expectedFunctionType");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope2, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope2, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType, inferenceSession);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference == null) {
            kotlinType = null;
        } else {
            object = ktTypeReference;
            it2 = object;
            boolean bl = false;
            kotlinType = this.typeResolver.resolveType(headerScope, (KtTypeReference)it2, trace, true);
        }
        KotlinType returnType2 = kotlinType;
        object = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, container));
        Intrinsics.checkNotNullExpressionValue(object, "resolveVisibilityFromMod\u2026ity(function, container))");
        Object visibility2 = object;
        it2 = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(container, (DescriptorVisibility)visibility2, function2.hasBody()), trace.getBindingContext(), container);
        Intrinsics.checkNotNullExpressionValue(it2, "resolveMemberModalityFro\u2026text, container\n        )");
        Object modality = it2;
        LazyContractProvider contractProvider = this.getContractProvider(functionDescriptor, trace, scope2, dataFlowInfo, function2, inferenceSession);
        Map $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u2d2 = map2 = (Map)new LinkedHashMap();
        boolean $i$a$-apply-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$userData$22 = false;
        if (contractProvider != null) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u2d2.put(ContractProviderKey.INSTANCE, contractProvider);
        }
        if (receiverType != null && this.functionTypeExpected(expectedFunctionType) && !expectedFunctionType.getAnnotations().isEmpty()) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u2d2.put(DslMarkerUtils.FunctionTypeAnnotationsKey.INSTANCE, expectedFunctionType.getAnnotations());
        }
        Map userData = map2;
        Iterator<ValueParameterDescriptor> iterator2 = receiverType;
        if (iterator2 == null) {
            receiverParameterDescriptor = null;
        } else {
            KotlinType it3 = $i$a$-apply-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$userData$22 = iterator2;
            boolean bl = false;
            Annotations annotations2 = receiverType.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(AnnotationUseSiteTarget.RECEIVER)");
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, annotations2, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            receiverParameterDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(functionDescriptor, it3, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
        Iterator<ValueParameterDescriptor> $i$a$-apply-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$userData$22 = iterator2 = userData;
        Object object2 = visibility2;
        Object object3 = modality;
        KotlinType kotlinType2 = returnType2;
        List<ValueParameterDescriptor> list2 = valueParameterDescriptors;
        List<TypeParameterDescriptorImpl> list3 = typeParameterDescriptors;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = DescriptorUtils.getDispatchReceiverParameterIfNeeded(container);
        ReceiverParameterDescriptor receiverParameterDescriptor3 = extensionReceiver;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        boolean bl = false;
        boolean bl2 = !it.isEmpty();
        simpleFunctionDescriptorImpl.initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, (List<? extends TypeParameterDescriptor>)list3, list2, kotlinType2, (Modality)((Object)object3), (DescriptorVisibility)object2, (Map<? extends CallableDescriptor.UserDataKey<?>, ?>)((Object)(bl2 ? iterator2 : null)));
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setExpect(container instanceof PackageFragmentDescriptor && PsiUtilsKt.hasExpectModifier(function2) || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect());
        functionDescriptor.setActual(PsiUtilsKt.hasActualModifier(function2));
        iterator2 = receiverType;
        if (iterator2 != null) {
            Iterator<ValueParameterDescriptor> it4 = it = iterator2;
            boolean bl3 = false;
            ForceResolveUtil.forceResolveAllContents(it4.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final LazyContractProvider getContractProvider(SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, LexicalScope scope2, DataFlowInfo dataFlowInfo, KtFunction function2, InferenceSession inferenceSession) {
        if (!(function2 instanceof KtNamedFunction)) {
            return null;
        }
        boolean isContractsEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        boolean isAllowedOnMembers = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
        if (!isContractsEnabled || !((KtNamedFunction)function2).mayHaveContract(isAllowedOnMembers)) {
            return null;
        }
        return new LazyContractProvider(this.storageManager, (Function0<? extends Object>)new Function0<Object>(function2, this, trace, scope2, dataFlowInfo, functionDescriptor, inferenceSession){
            final /* synthetic */ KtFunction $function;
            final /* synthetic */ FunctionDescriptorResolver this$0;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ SimpleFunctionDescriptorImpl $functionDescriptor;
            final /* synthetic */ InferenceSession $inferenceSession;
            {
                this.$function = $function;
                this.this$0 = $receiver;
                this.$trace = $trace;
                this.$scope = $scope;
                this.$dataFlowInfo = $dataFlowInfo;
                this.$functionDescriptor = $functionDescriptor;
                this.$inferenceSession = $inferenceSession;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return AstLoadingFilter.forceAllowTreeLoading(((KtNamedFunction)this.$function).getContainingFile(), () -> getContractProvider.1.invoke$lambda-0(this.this$0, this.$trace, this.$scope, this.$dataFlowInfo, this.$function, this.$functionDescriptor, this.$inferenceSession));
            }

            private static final KotlinType invoke$lambda-0(FunctionDescriptorResolver this$0, BindingTrace $trace, LexicalScope $scope, DataFlowInfo $dataFlowInfo, KtFunction $function, SimpleFunctionDescriptorImpl $functionDescriptor, InferenceSession $inferenceSession) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($trace, "$trace");
                Intrinsics.checkNotNullParameter($scope, "$scope");
                Intrinsics.checkNotNullParameter($dataFlowInfo, "$dataFlowInfo");
                Intrinsics.checkNotNullParameter($function, "$function");
                Intrinsics.checkNotNullParameter($functionDescriptor, "$functionDescriptor");
                return FunctionDescriptorResolver.access$getExpressionTypingServices$p(this$0).getBodyExpressionType($trace, $scope, $dataFlowInfo, $function, $functionDescriptor, $inferenceSession);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        List list2;
        List<ValueParameterDescriptor> expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        List<Object> list3 = expectedValueParameters;
        if (list3 == null) {
            list2 = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
                KotlinType kotlinType2 = this.removeParameterNameAnnotation(kotlinType);
                collection.add(kotlinType2);
            }
            list2 = (List)destination$iv$iv;
        }
        List expectedParameterTypes = list2;
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && function2.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Object object = Name.identifier("it");
                Intrinsics.checkNotNullExpressionValue(object, "identifier(\"it\")");
                Name name2 = object;
                List list4 = expectedParameterTypes;
                Intrinsics.checkNotNull(list4);
                KotlinType kotlinType = (KotlinType)CollectionsKt.single(list4);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType3 = valueParameterDescriptor.getVarargElementType();
                object = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue(object, "NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name2, kotlinType, bl, bl2, bl3, kotlinType3, (SourceElement)object);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf(it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list5 = expectedParameterTypes;
                Intrinsics.checkNotNull(list5);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list5.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        list3 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list3, trace, expectedParameterTypes, inferenceSession);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(KotlinType $this$removeParameterNameAnnotation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if ($this$removeParameterNameAnnotation instanceof TypeUtils.SpecialType) {
            return $this$removeParameterNameAnnotation;
        }
        Object object = $this$removeParameterNameAnnotation.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
        if (object == null) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor parameterNameAnnotation = object;
        object = $this$removeParameterNameAnnotation.getAnnotations();
        Annotations.Companion companion = Annotations.Companion;
        KotlinType kotlinType = $this$removeParameterNameAnnotation;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, parameterNameAnnotation))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return TypeUtilsKt.replaceAnnotations(kotlinType, companion.create(list2));
    }

    private final boolean functionTypeExpected(KotlinType $this$functionTypeExpected) {
        return !TypeUtils.noExpectedType($this$functionTypeExpected) && FunctionTypesKt.isBuiltinFunctionalType($this$functionTypeExpected);
    }

    private final KotlinType getReceiverType(KotlinType $this$getReceiverType) {
        return this.functionTypeExpected($this$getReceiverType) ? FunctionTypesKt.getReceiverTypeFromFunctionType($this$getReceiverType) : null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(KotlinType $this$getValueParameters, FunctionDescriptor owner) {
        return this.functionTypeExpected($this$getValueParameters) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($this$getValueParameters)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(classElement, "classElement");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        Object object = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = object == null ? (KtPureElement)classElement : (KtPureElement)object;
        object = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkNotNullExpressionValue(object, "classElement.primaryConstructorParameters");
        return this.createConstructorDescriptor(scope2, classDescriptor, true, ktModifierList, ktPureElement, (List<? extends KtParameter>)object, trace, languageVersionSettings, inferenceSession);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtSecondaryConstructor constructor2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        return this.createConstructorDescriptor(scope2, classDescriptor, false, constructor2.getModifierList(), constructor2, constructor2.getValueParameters(), trace, languageVersionSettings, inferenceSession);
    }

    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor, boolean isPrimary, KtModifierList modifierList2, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters2, BindingTrace trace, LanguageVersionSettings languageVersionSettings, InferenceSession inferenceSession) {
        Object object = ClassConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList2, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        Intrinsics.checkNotNullExpressionValue(object, "create(\n            clas\u2026SourceElement()\n        )");
        ClassConstructorDescriptorImpl constructorDescriptor = object;
        constructorDescriptor.setExpect(classDescriptor.isExpect());
        object = modifierList2;
        constructorDescriptor.setActual((object == null ? false : PsiUtilsKt.hasActualModifier((KtModifierList)object)) || classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && classDescriptor.isActual());
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, constructorDescriptor, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl constructor2 = constructorDescriptor.initialize(this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters2, trace, null, inferenceSession), ModifiersChecker.resolveVisibilityFromModifiers(modifierList2, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor, languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage))));
        constructor2.setReturnType(classDescriptor.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters2, trace);
        }
        Intrinsics.checkNotNullExpressionValue(constructor2, "constructor");
        return constructor2;
    }

    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters2, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes, InferenceSession inferenceSession) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        int n = 0;
        int n2 = valueParameters2.size();
        while (n < n2) {
            Object object;
            Object object2;
            Object it;
            Object object3;
            Object object4;
            int i = n++;
            KtParameter valueParameter2 = valueParameters2.get(i);
            KtTypeReference typeReference = valueParameter2.getTypeReference();
            List<? extends KotlinType> list2 = expectedParameterTypes;
            if (list2 == null) {
                object4 = null;
            } else {
                it = object3 = list2;
                boolean bl = false;
                object2 = i < it.size() ? it.get(i) : null;
                if (object2 == null) {
                    object4 = null;
                } else {
                    it = object3 = object2;
                    boolean bl2 = false;
                    object4 = !TypeUtils.noExpectedType((KotlinType)it) ? object3 : null;
                }
            }
            Object expectedType2 = object4;
            Object type2 = null;
            if (typeReference != null) {
                type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                if (expectedType2 != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf((KotlinType)expectedType2, (KotlinType)type2)) {
                    trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter2), (KotlinType)expectedType2));
                }
            } else if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                boolean containsErrorType2 = TypeUtils.contains(expectedType2, resolveValueParameters.containsErrorType.1.INSTANCE);
                if (expectedType2 == null || containsErrorType2) {
                    trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter2)));
                }
                object2 = (it = expectedType2) == null ? (KotlinType)TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE : it;
                Intrinsics.checkNotNullExpressionValue(object2, "{\n                    va\u2026AM_TYPE\n                }");
                object = object2;
            } else {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter2)));
                object2 = ErrorUtils.createErrorType(Intrinsics.stringPlus("Type annotation was missing for parameter ", valueParameter2.getNameAsSafeName()));
                Intrinsics.checkNotNullExpressionValue(object2, "{\n                    tr\u2026Name}\")\n                }");
                object = type2 = (KotlinType)object2;
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure;
                boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                ModifiersChecker.ModifiersCheckingProcedure $this$resolveValueParameters_u24lambda_u2d10 = modifiersCheckingProcedure = this.modifiersChecker.withTrace(trace);
                boolean bl = false;
                $this$resolveValueParameters_u24lambda_u2d10.checkParameterHasNoValOrVar(valueParameter2, isConstructor ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
            }
            object3 = this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter2, i, (KotlinType)type2, trace, Annotations.Companion.getEMPTY(), inferenceSession);
            Intrinsics.checkNotNullExpressionValue(object3, "descriptorResolver.resol\u2026enceSession\n            )");
            Object valueParameterDescriptor = object3;
            ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, (VariableDescriptor)valueParameterDescriptor);
            parameterScope.addVariableDescriptor((VariableDescriptor)valueParameterDescriptor);
            result2.add(valueParameterDescriptor);
        }
        return result2;
    }

    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(FunctionDescriptorResolver $this) {
        return $this.expressionTypingServices;
    }
}

