/*
 * Decompiled with CFR 0.152.
 */
package org.jline.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jline.console.ArgDesc;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;

public abstract class AbstractCommandRegistry {
    private CmdRegistry cmdRegistry;
    private Exception exception;

    public CmdDesc doHelpDesc(String command2, List<String> info, CmdDesc cmdDesc) {
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append(command2.toString().toLowerCase()).append(" -  ");
        for (String s : info) {
            if (asb.length() == 0) {
                asb.append("\t");
            }
            asb.append(s);
            mainDesc.add(asb.toAttributedString());
            asb = new AttributedStringBuilder();
            asb.tabs(2);
        }
        asb = new AttributedStringBuilder();
        asb.tabs(7);
        asb.append("Usage:");
        for (AttributedString as : cmdDesc.getMainDesc()) {
            asb.append("\t");
            asb.append(as);
            mainDesc.add(asb.toAttributedString());
            asb = new AttributedStringBuilder();
            asb.tabs(7);
        }
        return new CmdDesc(mainDesc, new ArrayList<ArgDesc>(), cmdDesc.getOptsDesc());
    }

    public <T extends Enum<T>> void registerCommands(Map<T, String> commandName, Map<T, CommandMethods> commandExecute) {
        this.cmdRegistry = new EnumCmdRegistry<T>(commandName, commandExecute);
    }

    public void registerCommands(Map<String, CommandMethods> commandExecute) {
        this.cmdRegistry = new NameCmdRegistry(commandExecute);
    }

    public Object execute(CommandRegistry.CommandSession session2, String command2, String[] args2) throws Exception {
        this.exception = null;
        this.getCommandMethods(command2).execute().accept(new CommandInput(command2, args2, session2));
        if (this.exception != null) {
            throw this.exception;
        }
        return null;
    }

    public Object invoke(CommandRegistry.CommandSession session2, String command2, Object ... args2) throws Exception {
        Object out = null;
        this.exception = null;
        CommandMethods methods2 = this.getCommandMethods(command2);
        if (methods2.isConsumer()) {
            Object[] _args = new String[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                if (!(args2[i] instanceof String)) {
                    throw new IllegalArgumentException();
                }
                _args[i] = args2[i].toString();
            }
            methods2.execute().accept(new CommandInput(command2, _args, session2));
        } else {
            out = methods2.executeFunction().apply(new CommandInput(command2, args2, session2));
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return out;
    }

    public void saveException(Exception exception) {
        this.exception = exception;
    }

    public boolean hasCommand(String command2) {
        return this.cmdRegistry.hasCommand(command2);
    }

    public Set<String> commandNames() {
        return this.cmdRegistry.commandNames();
    }

    public Map<String, String> commandAliases() {
        return this.cmdRegistry.commandAliases();
    }

    public <V extends Enum<V>> void rename(V command2, String newName2) {
        this.cmdRegistry.rename(command2, newName2);
    }

    public void alias(String alias, String command2) {
        this.cmdRegistry.alias(alias, command2);
    }

    public SystemCompleter compileCompleters() {
        return this.cmdRegistry.compileCompleters();
    }

    public CommandMethods getCommandMethods(String command2) {
        return this.cmdRegistry.getCommandMethods(command2);
    }

    public Object registeredCommand(String command2) {
        return this.cmdRegistry.command(command2);
    }

    private static class NameCmdRegistry
    implements CmdRegistry {
        private Map<String, CommandMethods> commandExecute;
        private Map<String, String> aliasCommand = new HashMap<String, String>();

        public NameCmdRegistry(Map<String, CommandMethods> commandExecute) {
            this.commandExecute = commandExecute;
        }

        @Override
        public Set<String> commandNames() {
            return this.commandExecute.keySet();
        }

        @Override
        public Map<String, String> commandAliases() {
            return this.aliasCommand;
        }

        @Override
        public <V extends Enum<V>> void rename(V command2, String newName2) {
            throw new IllegalArgumentException();
        }

        @Override
        public void alias(String alias, String command2) {
            if (!this.commandExecute.containsKey(command2)) {
                throw new IllegalArgumentException("Command does not exists!");
            }
            this.aliasCommand.put(alias, command2);
        }

        @Override
        public boolean hasCommand(String name2) {
            return this.commandExecute.containsKey(name2) || this.aliasCommand.containsKey(name2);
        }

        @Override
        public SystemCompleter compileCompleters() {
            SystemCompleter out = new SystemCompleter();
            for (String c : this.commandExecute.keySet()) {
                out.add(c, this.commandExecute.get(c).compileCompleter().apply(c));
            }
            out.addAliases(this.aliasCommand);
            return out;
        }

        @Override
        public String command(String name2) {
            if (this.commandExecute.containsKey(name2)) {
                return name2;
            }
            if (this.aliasCommand.containsKey(name2)) {
                return this.aliasCommand.get(name2);
            }
            return null;
        }

        @Override
        public CommandMethods getCommandMethods(String command2) {
            return this.commandExecute.get(this.command(command2));
        }
    }

    private static class EnumCmdRegistry<T extends Enum<T>>
    implements CmdRegistry {
        private Map<T, String> commandName;
        private Map<String, T> nameCommand = new HashMap<String, T>();
        private Map<T, CommandMethods> commandExecute;
        private Map<String, String> aliasCommand = new HashMap<String, String>();

        public EnumCmdRegistry(Map<T, String> commandName, Map<T, CommandMethods> commandExecute) {
            this.commandName = commandName;
            this.commandExecute = commandExecute;
            this.doNameCommand();
        }

        private void doNameCommand() {
            this.nameCommand = this.commandName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }

        @Override
        public Set<String> commandNames() {
            return this.nameCommand.keySet();
        }

        @Override
        public Map<String, String> commandAliases() {
            return this.aliasCommand;
        }

        @Override
        public <V extends Enum<V>> void rename(V command2, String newName2) {
            if (this.nameCommand.containsKey(newName2)) {
                throw new IllegalArgumentException("Duplicate command name!");
            }
            if (!this.commandName.containsKey(command2)) {
                throw new IllegalArgumentException("Command does not exists!");
            }
            this.commandName.put(command2, newName2);
            this.doNameCommand();
        }

        @Override
        public void alias(String alias, String command2) {
            if (!this.nameCommand.keySet().contains(command2)) {
                throw new IllegalArgumentException("Command does not exists!");
            }
            this.aliasCommand.put(alias, command2);
        }

        @Override
        public boolean hasCommand(String name2) {
            return this.nameCommand.containsKey(name2) || this.aliasCommand.containsKey(name2);
        }

        @Override
        public SystemCompleter compileCompleters() {
            SystemCompleter out = new SystemCompleter();
            for (Map.Entry<T, String> entry : this.commandName.entrySet()) {
                out.add(entry.getValue(), this.commandExecute.get(entry.getKey()).compileCompleter().apply(entry.getValue()));
            }
            out.addAliases(this.aliasCommand);
            return out;
        }

        public T command(String name2) {
            Enum out = null;
            if (!this.hasCommand(name2)) {
                throw new IllegalArgumentException("Command does not exists!");
            }
            if (this.aliasCommand.containsKey(name2)) {
                name2 = this.aliasCommand.get(name2);
            }
            if (!this.nameCommand.containsKey(name2)) {
                throw new IllegalArgumentException("Command does not exists!");
            }
            out = (Enum)this.nameCommand.get(name2);
            return (T)out;
        }

        @Override
        public CommandMethods getCommandMethods(String command2) {
            return this.commandExecute.get(this.command(command2));
        }
    }

    private static interface CmdRegistry {
        public boolean hasCommand(String var1);

        public Set<String> commandNames();

        public Map<String, String> commandAliases();

        public Object command(String var1);

        public <V extends Enum<V>> void rename(V var1, String var2);

        public void alias(String var1, String var2);

        public SystemCompleter compileCompleters();

        public CommandMethods getCommandMethods(String var1);
    }
}

