/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import com.sun.jna.LastErrorException;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jna.win.JnaWinConsoleWriter;
import org.jline.terminal.impl.jna.win.Kernel32;
import org.jline.terminal.impl.jna.win.WindowsAnsiWriter;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;

public class JnaWinSysTerminal
extends AbstractWindowsTerminal {
    private static final Pointer consoleIn = Kernel32.INSTANCE.GetStdHandle(-10);
    private static final Pointer consoleOut = Kernel32.INSTANCE.GetStdHandle(-11);
    private char[] focus = new char[]{'\u001b', '[', ' '};
    private char[] mouse = new char[]{'\u001b', '[', 'M', ' ', ' ', ' '};
    private final Kernel32.INPUT_RECORD[] inputEvents = new Kernel32.INPUT_RECORD[1];
    private final IntByReference eventsRead = new IntByReference();

    public static JnaWinSysTerminal createTerminal(String name2, String type2, boolean ansiPassThrough, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        Writer writer;
        if (ansiPassThrough) {
            if (type2 == null) {
                type2 = OSUtils.IS_CONEMU ? "windows-conemu" : "windows";
            }
            writer = new JnaWinConsoleWriter(consoleOut);
        } else {
            IntByReference mode = new IntByReference();
            Kernel32.INSTANCE.GetConsoleMode(consoleOut, mode);
            try {
                Kernel32.INSTANCE.SetConsoleMode(consoleOut, mode.getValue() | 4);
                if (type2 == null) {
                    type2 = "windows-vtp";
                }
                writer = new JnaWinConsoleWriter(consoleOut);
            }
            catch (LastErrorException e) {
                if (OSUtils.IS_CONEMU) {
                    if (type2 == null) {
                        type2 = "windows-conemu";
                    }
                    writer = new JnaWinConsoleWriter(consoleOut);
                }
                if (type2 == null) {
                    type2 = "windows";
                }
                writer = new WindowsAnsiWriter(new BufferedWriter(new JnaWinConsoleWriter(consoleOut)), consoleOut);
            }
        }
        JnaWinSysTerminal terminal = new JnaWinSysTerminal(writer, name2, type2, encoding, codepage, nativeSignals, signalHandler);
        if (!paused) {
            terminal.resume();
        }
        return terminal;
    }

    public static boolean isWindowsConsole() {
        try {
            IntByReference mode = new IntByReference();
            Kernel32.INSTANCE.GetConsoleMode(consoleOut, mode);
            return true;
        }
        catch (LastErrorException e) {
            return false;
        }
    }

    JnaWinSysTerminal(Writer writer, String name2, String type2, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(writer, name2, type2, encoding, codepage, nativeSignals, signalHandler);
        this.strings.put(InfoCmp.Capability.key_mouse, "\\E[M");
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.INSTANCE.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        IntByReference mode = new IntByReference();
        Kernel32.INSTANCE.GetConsoleMode(consoleIn, mode);
        return mode.getValue();
    }

    @Override
    protected void setConsoleMode(int mode) {
        Kernel32.INSTANCE.SetConsoleMode(consoleIn, mode);
    }

    @Override
    public Size getSize() {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Size(info.windowWidth(), info.windowHeight());
    }

    @Override
    public Size getBufferSize() {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Size(info.dwSize.X, info.dwSize.Y);
    }

    @Override
    protected boolean processConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD event = this.readConsoleInput(100);
        if (event == null) {
            return false;
        }
        switch (event.EventType) {
            case 1: {
                this.processKeyEvent(event.Event.KeyEvent);
                return true;
            }
            case 4: {
                this.raise(Terminal.Signal.WINCH);
                return false;
            }
            case 2: {
                this.processMouseEvent(event.Event.MouseEvent);
                return true;
            }
            case 16: {
                this.processFocusEvent(event.Event.FocusEvent.bSetFocus);
                return true;
            }
        }
        return false;
    }

    private void processKeyEvent(Kernel32.KEY_EVENT_RECORD keyEvent) throws IOException {
        this.processKeyEvent(keyEvent.bKeyDown, keyEvent.wVirtualKeyCode, keyEvent.uChar.UnicodeChar, keyEvent.dwControlKeyState);
    }

    private void processFocusEvent(boolean hasFocus) throws IOException {
        if (this.focusTracking) {
            this.focus[2] = hasFocus ? 73 : 79;
            this.slaveInputPipe.write(this.focus);
        }
    }

    private void processMouseEvent(Kernel32.MOUSE_EVENT_RECORD mouseEvent) throws IOException {
        int dwEventFlags = mouseEvent.dwEventFlags;
        int dwButtonState = mouseEvent.dwButtonState;
        if (this.tracking == Terminal.MouseTracking.Off || this.tracking == Terminal.MouseTracking.Normal && dwEventFlags == 1 || this.tracking == Terminal.MouseTracking.Button && dwEventFlags == 1 && dwButtonState == 0) {
            return;
        }
        int cb = 0;
        if ((dwEventFlags &= 0xFFFFFFFD) == 4) {
            cb |= 0x40;
            if (dwButtonState >> 16 < 0) {
                cb |= 1;
            }
        } else {
            if (dwEventFlags == 8) {
                return;
            }
            cb = (dwButtonState & 1) != 0 ? (cb |= 0) : ((dwButtonState & 2) != 0 ? (cb |= 1) : ((dwButtonState & 4) != 0 ? (cb |= 2) : (cb |= 3)));
        }
        short cx = mouseEvent.dwMousePosition.X;
        short cy = mouseEvent.dwMousePosition.Y;
        this.mouse[3] = (char)(32 + cb);
        this.mouse[4] = (char)(32 + cx + 1);
        this.mouse[5] = (char)(32 + cy + 1);
        this.slaveInputPipe.write(this.mouse);
    }

    private Kernel32.INPUT_RECORD readConsoleInput(int dwMilliseconds) throws IOException {
        if (Kernel32.INSTANCE.WaitForSingleObject(consoleIn, dwMilliseconds) != 0) {
            return null;
        }
        Kernel32.INSTANCE.ReadConsoleInput(consoleIn, this.inputEvents, 1, this.eventsRead);
        if (this.eventsRead.getValue() == 1) {
            return this.inputEvents[0];
        }
        return null;
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Cursor(info.dwCursorPosition.X, info.dwCursorPosition.Y);
    }
}

