/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.HashMap;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.LinkedHashSet;
import javaslang.collection.Map;
import javaslang.collection.Maps;
import javaslang.collection.Queue;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.control.Option;

public final class LinkedHashMap<K, V>
implements Serializable,
Map<K, V> {
    private static final long serialVersionUID = 1L;
    private static final LinkedHashMap<?, ?> EMPTY = new LinkedHashMap(Queue.empty(), HashMap.empty());
    private final Queue<Tuple2<K, V>> list;
    private final HashMap<K, V> map;

    private LinkedHashMap(Queue<Tuple2<K, V>> list2, HashMap<K, V> map2) {
        this.list = list2;
        this.map = map2;
    }

    public static <K, V> LinkedHashMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> LinkedHashMap<K, V> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries2) {
        Objects.requireNonNull(entries2, "entries is null");
        if (entries2 instanceof LinkedHashMap) {
            return (LinkedHashMap)entries2;
        }
        Map map2 = HashMap.empty();
        Queue<Tuple2<K, V>> list2 = Queue.empty();
        for (Tuple2<K, V> tuple2 : entries2) {
            map2 = map2.put(tuple2);
            list2 = list2.append(tuple2);
        }
        return LinkedHashMap.wrap(list2, map2);
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> bimap(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        Iterator<Tuple2> entries2 = this.iterator().map((? super T entry) -> Tuple.of(keyMapper.apply((Object)entry._1), valueMapper.apply((Object)entry._2)));
        return LinkedHashMap.ofEntries(entries2);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public LinkedHashMap<K, V> distinct() {
        return Maps.distinct(this);
    }

    @Override
    public LinkedHashMap<K, V> distinctBy(Comparator<? super Tuple2<K, V>> comparator) {
        return Maps.distinctBy(this, this::createFromEntries, comparator);
    }

    @Override
    public <U> LinkedHashMap<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        return Maps.distinctBy(this, this::createFromEntries, keyExtractor);
    }

    @Override
    public LinkedHashMap<K, V> drop(long n) {
        return Maps.drop(this, this::createFromEntries, LinkedHashMap::empty, n);
    }

    @Override
    public LinkedHashMap<K, V> dropRight(long n) {
        return Maps.dropRight(this, this::createFromEntries, LinkedHashMap::empty, n);
    }

    @Override
    public LinkedHashMap<K, V> dropUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> dropWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> filter(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.filter(this, this::createFromEntries, predicate);
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(LinkedHashMap.empty(), (acc, entry) -> {
            for (Tuple2 mappedEntry : (Iterable)mapper.apply((Object)entry._1, (Object)entry._2)) {
                acc = acc.put(mappedEntry);
            }
            return acc;
        });
    }

    @Override
    public Option<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public <C> Map<C, LinkedHashMap<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> classifier2) {
        return Maps.groupBy(this, this::createFromEntries, classifier2);
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> grouped(long size) {
        return Maps.grouped(this, this::createFromEntries, size);
    }

    @Override
    public Tuple2<K, V> head() {
        return this.list.head();
    }

    @Override
    public LinkedHashMap<K, V> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty LinkedHashMap");
        }
        return LinkedHashMap.ofEntries(this.list.init());
    }

    @Override
    public Option<LinkedHashMap<K, V>> initOption() {
        return Maps.initOption(this);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return this.list.iterator();
    }

    @Override
    public Set<K> keySet() {
        return LinkedHashSet.wrap(this);
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(LinkedHashMap.empty(), (acc, entry) -> acc.put(entry.map(mapper)));
    }

    @Override
    public <W> LinkedHashMap<K, W> mapValues(Function<? super V, ? extends W> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.map((T k, U v) -> Tuple.of(k, mapper.apply((Object)v)));
    }

    @Override
    public LinkedHashMap<K, V> merge(Map<? extends K, ? extends V> that) {
        return Maps.merge(this, this::createFromEntries, that);
    }

    @Override
    public <U extends V> LinkedHashMap<K, V> merge(Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        return Maps.merge(this, this::createFromEntries, that, collisionResolution);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.partition(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> peek(Consumer<? super Tuple2<K, V>> action) {
        return Maps.peek(this, action);
    }

    @Override
    public LinkedHashMap<K, V> put(K key, V value2) {
        Queue<Tuple2<K, V>> newList = this.list;
        Map<K, V> newMap2 = this.map;
        if (this.containsKey(key)) {
            newList = newList.filter((? super T t) -> !Objects.equals(t._1, key));
            newMap2 = newMap2.remove((Object)key);
        }
        newList = newList.append(Tuple.of(key, value2));
        newMap2 = newMap2.put((Object)key, (Object)value2);
        return new LinkedHashMap<K, V>(newList, newMap2);
    }

    @Override
    public LinkedHashMap<K, V> put(Tuple2<? extends K, ? extends V> entry) {
        return Maps.put(this, entry);
    }

    @Override
    public LinkedHashMap<K, V> remove(K key) {
        if (this.containsKey(key)) {
            Queue<Tuple2<K, V>> newList = this.list.removeFirst(t -> Objects.equals(t._1, key));
            Map newMap2 = this.map.remove((Object)key);
            return LinkedHashMap.wrap(newList, newMap2);
        }
        return this;
    }

    @Override
    public LinkedHashMap<K, V> removeAll(Iterable<? extends K> keys2) {
        Objects.requireNonNull(keys2, "keys is null");
        HashSet toRemove = HashSet.ofAll(keys2);
        Queue<Tuple2<K, V>> newList = this.list.filter((? super T t) -> !toRemove.contains((Object)t._1));
        Map newMap2 = this.map.filter((T t) -> !toRemove.contains((Object)t._1));
        return newList.size() == this.size() ? this : LinkedHashMap.wrap(newList, newMap2);
    }

    @Override
    public LinkedHashMap<K, V> replace(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        if (!Objects.equals(currentElement, newElement) && this.contains(currentElement)) {
            Option<V> value2;
            Queue<Tuple2<Object, V>> newList = this.list;
            Map<Object, V> newMap2 = this.map;
            Object currentKey = currentElement._1;
            Object newKey = newElement._1;
            if (!Objects.equals(currentKey, newKey) && (value2 = newMap2.get(newKey)).isDefined()) {
                newList = newList.remove(Tuple.of(newKey, value2.get()));
            }
            newList = newList.replace(currentElement, newElement);
            newMap2 = ((HashMap)newMap2.remove(currentKey)).put(newElement);
            return LinkedHashMap.wrap(newList, newMap2);
        }
        return this;
    }

    @Override
    public LinkedHashMap<K, V> replaceAll(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replaceAll(this, currentElement, newElement);
    }

    @Override
    public LinkedHashMap<K, V> retainAll(Iterable<? extends Tuple2<K, V>> elements) {
        Objects.requireNonNull(elements, "elements is null");
        Map<K, V> result2 = LinkedHashMap.empty();
        for (Tuple2<K, V> entry : elements) {
            if (!this.contains(entry)) continue;
            result2 = result2.put(entry._1, entry._2);
        }
        return result2;
    }

    @Override
    public LinkedHashMap<K, V> scan(Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        return Maps.scan(this, LinkedHashMap::empty, zero, operation);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> sliding(long size) {
        return Maps.sliding(this, this::createFromEntries, size);
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> sliding(long size, long step) {
        return Maps.sliding(this, this::createFromEntries, size, step);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> span(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.span(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty LinkedHashMap");
        }
        return LinkedHashMap.ofEntries(this.list.tail());
    }

    @Override
    public Option<LinkedHashMap<K, V>> tailOption() {
        return Maps.tailOption(this);
    }

    @Override
    public LinkedHashMap<K, V> take(long n) {
        return Maps.take(this, this::createFromEntries, n);
    }

    @Override
    public LinkedHashMap<K, V> takeRight(long n) {
        return Maps.takeRight(this, this::createFromEntries, n);
    }

    @Override
    public LinkedHashMap<K, V> takeUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> takeWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public java.util.LinkedHashMap<K, V> toJavaMap() {
        return this.toJavaMap(java.util.LinkedHashMap::new, t -> t);
    }

    @Override
    public Seq<V> values() {
        return this.map((? super Tuple2<K, V> t) -> t._2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkedHashMap) {
            LinkedHashMap that = (LinkedHashMap)o;
            return this.list.equals(that.list);
        }
        return false;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashMap";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <K, V> LinkedHashMap<K, V> wrap(Queue<Tuple2<K, V>> list2, HashMap<K, V> map2) {
        return list2.isEmpty() ? LinkedHashMap.empty() : new LinkedHashMap<K, V>(list2, map2);
    }

    private LinkedHashMap<K, V> createFromEntries(Iterable<Tuple2<K, V>> tuples) {
        return LinkedHashMap.ofEntries(tuples);
    }
}

