/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiled.light.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/DecompiledLightClassesFactory;", "", "()V", "createClsJavaClassFromVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsClassImpl;", "mirrorFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "classFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "correspondingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "createLightClassForDecompiledKotlinFile", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;", "findCorrespondingLightClass", "decompiledClassOrObject", "rootLightClassForDecompiledFile", "getClassRelativeName", "Lorg/jetbrains/kotlin/name/FqName;", "getLightClassForDecompiledClassOrObject", "light-classes-for-decompiled"})
public final class DecompiledLightClassesFactory {
    @NotNull
    public static final DecompiledLightClassesFactory INSTANCE = new DecompiledLightClassesFactory();

    private DecompiledLightClassesFactory() {
    }

    @Nullable
    public final KtLightClassForDecompiledDeclaration getLightClassForDecompiledClassOrObject(@NotNull KtClassOrObject decompiledClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(decompiledClassOrObject, "decompiledClassOrObject");
        Intrinsics.checkNotNullParameter(project, "project");
        if (decompiledClassOrObject instanceof KtEnumEntry) {
            return null;
        }
        PsiFile psiFile = decompiledClassOrObject.getContainingFile();
        KtClsFile ktClsFile = psiFile instanceof KtClsFile ? (KtClsFile)psiFile : null;
        if (ktClsFile == null) {
            return null;
        }
        KtClsFile containingKtFile = ktClsFile;
        KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration = this.createLightClassForDecompiledKotlinFile(containingKtFile, project);
        if (ktLightClassForDecompiledDeclaration == null) {
            return null;
        }
        KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = ktLightClassForDecompiledDeclaration;
        return this.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightClassForDecompiledDeclaration findCorrespondingLightClass(KtClassOrObject decompiledClassOrObject, KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile) {
        FqName fqName2 = this.getClassRelativeName(decompiledClassOrObject);
        if (fqName2 == null) {
            return null;
        }
        FqName relativeFqName = fqName2;
        Iterator<Name> iterator2 = relativeFqName.pathSegments().iterator();
        Name base2 = iterator2.next();
        if (!Intrinsics.areEqual(rootLightClassForDecompiledFile.getName(), base2.asString())) {
            return null;
        }
        KtLightClassForDecompiledDeclaration current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            void value$iv;
            Name name2 = iterator2.next();
            String string2 = name2.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
            PsiClass innerClass = current.findInnerClassByName(string2, false);
            boolean bl = innerClass != null;
            boolean $i$f$checkWithAttachment = false;
            if (value$iv == false) {
                KotlinExceptionWithAttachments e$iv;
                boolean bl2 = false;
                String string3 = "Could not find corresponding inner/nested class " + relativeFqName + " in class " + decompiledClassOrObject.getFqName() + "\nFile: " + decompiledClassOrObject.getContainingKtFile().getVirtualFile().getName();
                KotlinExceptionWithAttachments it = e$iv = new KotlinExceptionWithAttachments(string3);
                boolean bl3 = false;
                it.withAttachment("decompiledClassOrObject", decompiledClassOrObject.getText());
                it.withAttachment("fileClass", Reflection.getOrCreateKotlinClass(decompiledClassOrObject.getContainingFile().getClass()));
                it.withAttachment("file", decompiledClassOrObject.getContainingFile().getText());
                it.withAttachment("root", rootLightClassForDecompiledFile.getText());
                throw e$iv;
            }
            Intrinsics.checkNotNull(innerClass, "null cannot be cast to non-null type org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration");
            current = (KtLightClassForDecompiledDeclaration)innerClass;
        }
        return current;
    }

    private final FqName getClassRelativeName(KtClassOrObject decompiledClassOrObject) {
        Name name2 = decompiledClassOrObject.getNameAsName();
        if (name2 == null) {
            return null;
        }
        Name name3 = name2;
        KtClassOrObject parent2 = PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, KtClassOrObject.class, true);
        if (parent2 == null) {
            boolean bl = decompiledClassOrObject.isTopLevel();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return FqName.topLevel(name3);
        }
        FqName fqName2 = this.getClassRelativeName(parent2);
        return fqName2 != null ? fqName2.child(name3) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(@NotNull KtClsFile file2, @NotNull Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(project, "project");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Iterable $this$filterIsInstance$iv = file2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtClassOrObject classOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((List)destination$iv$iv);
        ClsClassImpl clsClassImpl = this.createClsJavaClassFromVirtualFile(file2, virtualFile3, classOrObject, project);
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl javaClsClass = clsClassImpl;
        PsiClass psiClass = javaClsClass;
        PsiElement psiElement = javaClsClass.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "javaClsClass.parent");
        return new KtLightClassForDecompiledDeclaration(psiClass, psiElement, file2, classOrObject);
    }

    @Nullable
    public final ClsClassImpl createClsJavaClassFromVirtualFile(@NotNull KtFile mirrorFile, @NotNull VirtualFile classFile, @Nullable KtClassOrObject correspondingClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(mirrorFile, "mirrorFile");
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(project, "project");
        PsiJavaFileStubImpl psiJavaFileStubImpl = ClsJavaStubByVirtualFileCache.Companion.getInstance(project).get(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl javaFileStub = psiJavaFileStubImpl;
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        PsiManager psiManager2 = PsiManager.getInstance(mirrorFile.getProject());
        Intrinsics.checkNotNullExpressionValue(psiManager2, "getInstance(mirrorFile.project)");
        PsiManager manager = psiManager2;
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(manager, classFile);
        ClsFileImpl fakeFile2 = new ClsFileImpl(correspondingClassOrObject, javaFileStub, mirrorFile, classFileViewProvider){
            final /* synthetic */ KtClassOrObject $correspondingClassOrObject;
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ KtFile $mirrorFile;
            {
                this.$correspondingClassOrObject = $correspondingClassOrObject;
                this.$javaFileStub = $javaFileStub;
                this.$mirrorFile = $mirrorFile;
                super($super_call_param$1);
            }

            @NotNull
            public PsiElement getNavigationElement() {
                if (this.$correspondingClassOrObject != null) {
                    PsiFile psiFile = this.$correspondingClassOrObject.getNavigationElement().getContainingFile();
                    Intrinsics.checkNotNullExpressionValue(psiFile, "correspondingClassOrObje\u2026ionElement.containingFile");
                    return psiFile;
                }
                PsiElement psiElement = super.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue(psiElement, "super.getNavigationElement()");
                return psiElement;
            }

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public KtFile getMirror() {
                return this.$mirrorFile;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        PsiClass[] psiClassArray = fakeFile2.getClasses();
        Intrinsics.checkNotNullExpressionValue(psiClassArray, "fakeFile.classes");
        Object object = ArraysKt.single((Object[])psiClassArray);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        return (ClsClassImpl)object;
    }
}

