/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;
import org.jetbrains.kotlin.com.google.inject.internal.SingleMemberInjector;
import org.jetbrains.kotlin.com.google.inject.internal.SingleParameterInjector;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;

final class SingleMethodInjector
implements SingleMemberInjector {
    private final InjectorImpl.MethodInvoker methodInvoker;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        int modifiers2 = method.getModifiers();
        if (!Modifier.isPublic(modifiers2) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(){

            @Override
            public Object invoke(Object target, Object ... parameters2) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(target, parameters2);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext context, Object o) throws InternalProvisionException {
        Object[] parameters2 = SingleParameterInjector.getAll(context, this.parameterInjectors);
        try {
            this.methodInvoker.invoke(o, parameters2);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw InternalProvisionException.errorInjectingMethod(cause).addSource(this.injectionPoint);
        }
    }
}

