/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.VisibilityUtil;
import org.jetbrains.kotlin.com.intellij.util.text.UniqueNameGenerator;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeImpl.class);
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "";
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        return "";
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return "Diamond Type";
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text2) {
        if (text2 == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(0);
        }
        return text2.isEmpty();
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(1);
        }
        return visitor2.visitDiamondType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject(this.myManager, this.getResolveScope())};
        if (psiTypeArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @Override
    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = this.getNewExpression();
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    private PsiNewExpression getNewExpression() {
        PsiElement typeElementWithDiamondTypeArgument = this.myTypeElement.getParent();
        return PsiTreeUtil.getParentOfType(typeElementWithDiamondTypeArgument, PsiNewExpression.class, true, PsiTypeElement.class);
    }

    @Override
    @Nullable
    public JavaResolveResult getStaticFactory() {
        PsiNewExpression newExpression = this.getNewExpression();
        return newExpression != null ? PsiDiamondTypeImpl.getStaticFactory(newExpression, newExpression) : null;
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context) {
        PsiElement resolve2;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && !PsiUtil.isLanguageLevel9OrHigher(newExpression) && (resolve2 = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = PsiTreeUtil.getChildOfType(newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context);
        if (anonymousClass != null && PsiUtil.isLanguageLevel9OrHigher(newExpression)) {
            InferredAnonymousTypeVisitor anonymousTypeVisitor = new InferredAnonymousTypeVisitor(context);
            for (PsiType type2 : inferenceResult.getInferredTypes()) {
                Boolean accepted = type2.accept(anonymousTypeVisitor);
                if (accepted == null || accepted.booleanValue()) continue;
                return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
            }
        }
        return inferenceResult;
    }

    private static JavaResolveResult getStaticFactory(PsiNewExpression newExpression, PsiElement context) {
        return context == newExpression && !MethodCandidateInfo.isOverloadCheck(newExpression.getArgumentList()) ? (JavaResolveResult)CachedValuesManager.getCachedValue(newExpression, () -> new CachedValueProvider.Result<JavaResolveResult>(PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, newExpression), PsiModificationTracker.MODIFICATION_COUNT)) : PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, context);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(PsiNewExpression newExpression, PsiElement context) {
        JavaResolveResult staticFactoryCandidateInfo = PsiDiamondTypeImpl.getStaticFactory(newExpression, context);
        if (staticFactoryCandidateInfo == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        if (!(staticFactoryCandidateInfo instanceof MethodCandidateInfo)) {
            return PsiDiamondType.DiamondInferenceResult.UNRESOLVED_CONSTRUCTOR;
        }
        LOG.assertTrue(!PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow(newExpression, PsiUtil.getLanguageLevel(newExpression)), "diamond evaluation during overload resolution");
        PsiSubstitutor substitutor2 = staticFactoryCandidateInfo.getSubstitutor();
        final String errorMessage2 = ((MethodCandidateInfo)staticFactoryCandidateInfo).getInferenceErrorMessageAssumeAlreadyComputed();
        if (errorMessage2 == null && ((MethodCandidateInfo)staticFactoryCandidateInfo).isErased()) {
            return PsiDiamondType.DiamondInferenceResult.RAW_RESULT;
        }
        PsiMethod staticFactory = ((MethodCandidateInfo)staticFactoryCandidateInfo).getElement();
        PsiTypeParameter[] parameters2 = staticFactory.getTypeParameters();
        PsiElement staticFactoryContext = staticFactory.getContext();
        PsiClass psiClass = PsiTreeUtil.getContextOfType(staticFactoryContext, PsiClass.class, false);
        if (psiClass == null) {
            LOG.error("failed for expression:" + newExpression);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result2 = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>"){

            @Override
            public String getErrorMessage() {
                return errorMessage2 != null ? PsiDiamondType.DiamondInferenceResult.NULL_RESULT.getErrorMessage() : super.getErrorMessage();
            }
        };
        if (errorMessage2 == null && PsiUtil.isRawSubstitutor(staticFactory, substitutor2)) {
            if (!PsiUtil.isLanguageLevel8OrHigher(newExpression) && PsiUtil.skipParenthesizedExprUp(newExpression.getParent()) instanceof PsiExpressionList) {
                for (PsiTypeParameter ignored : parameters2) {
                    result2.addInferredType(PsiType.getJavaLangObject(newExpression.getManager(), GlobalSearchScope.allScope(newExpression.getProject())));
                }
            }
            return result2;
        }
        block1: for (PsiTypeParameter parameter : parameters2) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual(classParameter.getName(), parameter.getName())) continue;
                result2.addInferredType(substitutor2.substitute(parameter));
                continue block1;
            }
        }
        return result2;
    }

    private static JavaResolveResult getStaticFactoryCandidateInfo(@NotNull PsiNewExpression newExpression, PsiElement context) {
        if (newExpression == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(4);
        }
        return ourDiamondGuard.doPreventingRecursion(context, false, () -> {
            PsiMethod staticFactory;
            PsiExpressionList argumentList2 = newExpression.getArgumentList();
            if (argumentList2 == null) {
                return null;
            }
            PsiFile containingFile = argumentList2.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            JavaMethodsConflictResolver resolver = new JavaMethodsConflictResolver(argumentList2, null, PsiUtil.getLanguageLevel(containingFile), containingFile);
            List<CandidateInfo> results = PsiDiamondTypeImpl.collectStaticFactories(newExpression);
            CandidateInfo result2 = results != null ? resolver.resolveConflict(new ArrayList<CandidateInfo>(results)) : null;
            PsiMethod psiMethod = staticFactory = result2 != null ? (PsiMethod)result2.getElement() : null;
            if (staticFactory == null) {
                return JavaResolveResult.EMPTY;
            }
            MethodCandidateInfo staticFactoryCandidateInfo = PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result2, context, false, argumentList2);
            if (!staticFactory.isVarArgs()) {
                return staticFactoryCandidateInfo;
            }
            ArrayList<CandidateInfo> conflicts = new ArrayList<CandidateInfo>();
            conflicts.add(staticFactoryCandidateInfo);
            conflicts.add(PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result2, context, true, argumentList2));
            return resolver.resolveConflict(conflicts);
        });
    }

    @Nullable
    public static List<CandidateInfo> collectStaticFactories(PsiNewExpression newExpression) {
        return (List)CachedValuesManager.getCachedValue(newExpression, () -> new CachedValueProvider.Result<List<CandidateInfo>>(PsiDiamondTypeImpl.collectStaticFactoriesInner(newExpression), PsiModificationTracker.MODIFICATION_COUNT));
    }

    private static List<CandidateInfo> collectStaticFactoriesInner(final PsiNewExpression newExpression) {
        final PsiExpressionList argumentList2 = newExpression.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        final PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return null;
        }
        ArrayList candidates2 = new ArrayList();
        PsiMethod[] constructors2 = psiClass.getConstructors();
        if (constructors2.length == 0) {
            constructors2 = new PsiMethod[]{null};
        }
        PsiFile containingFile = argumentList2.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(argumentList2, containingFile, new PsiConflictResolver[0], candidates2){

            @Override
            protected boolean isAccepted(@NotNull PsiMethod candidate2) {
                if (candidate2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            protected PsiClass getContainingClass(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (newExpression.getAnonymousClass() != null) {
                    return PsiTreeUtil.getContextOfType((PsiElement)argumentList2, PsiClass.class, false);
                }
                return psiClass;
            }

            @Override
            protected boolean acceptVarargs() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "candidate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondTypeImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAccepted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContainingClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor2.setArgumentList(argumentList2);
        for (PsiMethod constructor2 : constructors2) {
            PsiTypeParameter[] params = PsiDiamondTypeImpl.getAllTypeParams(constructor2, psiClass);
            PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor2, psiClass, params, newExpression.getClassReference());
            if (staticFactory == null) continue;
            processor2.add(staticFactory, PsiSubstitutor.EMPTY);
        }
        return processor2.getResults();
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
        if (classReference != null) {
            String text2 = classReference.getReferenceName();
            if (text2 != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference.getQualifier();
                String qualifier = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName2 = StringUtil.getQualifiedName(qualifier, text2);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly(newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName2, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName2, newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor2, PsiClass containingClass, PsiTypeParameter[] params, PsiJavaCodeReferenceElement reference) {
        PsiElement qualifier;
        StringBuilder buf = new StringBuilder();
        String modifier = VisibilityUtil.getVisibilityModifier(constructor2 != null ? constructor2.getModifierList() : containingClass.getModifierList());
        if (!"packageLocal".equals(modifier)) {
            buf.append(modifier);
            buf.append(" ");
        }
        buf.append("static ");
        buf.append("<");
        UniqueNameGenerator generator2 = new UniqueNameGenerator();
        buf.append(StringUtil.join(params, psiTypeParameter -> {
            PsiClassType[] extendsListTypes;
            String extendsList = "";
            if (psiTypeParameter.getLanguage().isKindOf(JavaLanguage.INSTANCE) && (extendsListTypes = psiTypeParameter.getExtendsListTypes()).length > 0) {
                Function<PsiClassType, String> canonicalTypePresentationFun = type2 -> type2.getCanonicalText();
                extendsList = " extends " + StringUtil.join(extendsListTypes, canonicalTypePresentationFun, "&");
            }
            return generator2.generateUniqueName(psiTypeParameter.getName()) + extendsList;
        }, ", "));
        buf.append(">");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(containingClass.getProject());
        String qualifiedName2 = containingClass.getQualifiedName();
        PsiElement psiElement = qualifier = reference != null ? reference.getQualifier() : null;
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiClass) {
                String outerClassSubstitutedQName = elementFactory.createType((PsiClass)element, resolveResult.getSubstitutor()).getInternalCanonicalText();
                qualifiedName2 = outerClassSubstitutedQName + "." + containingClass.getName();
            }
        } else if (reference != null && qualifier == null && containingClass.getContainingClass() != null) {
            qualifiedName2 = null;
        }
        buf.append(qualifiedName2 != null ? qualifiedName2 : containingClass.getName());
        PsiTypeParameter[] parameters2 = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join(parameters2, psiTypeParameter -> psiTypeParameter.getName(), ", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor2 == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join(constructor2.getParameterList().getParameters(), new Function<PsiParameter, String>(){
                int myIdx;

                @Override
                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, ",")).append(")");
            PsiClassType[] types2 = constructor2.getThrowsList().getReferencedTypes();
            if (types2.length > 0) {
                buf.append("throws ").append(StringUtil.join(types2, type2 -> type2.getCanonicalText(), ", "));
            }
        }
        buf.append("{}");
        try {
            return elementFactory.createMethodFromText(buf.toString(), constructor2 != null ? constructor2 : containingClass);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static PsiTypeParameter @NotNull [] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        Collections.addAll(params, containingClass.getTypeParameters());
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        PsiTypeParameter[] psiTypeParameterArray = params.toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(5);
        }
        return psiTypeParameterArray;
    }

    private static MethodCandidateInfo createMethodCandidate(@NotNull MethodCandidateInfo staticFactoryMethod, final PsiElement parent2, final boolean varargs, final PsiExpressionList argumentList2) {
        if (staticFactoryMethod == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(6);
        }
        return new MethodCandidateInfo(staticFactoryMethod.getElement(), PsiSubstitutor.EMPTY, !staticFactoryMethod.isAccessible(), false, argumentList2, parent2, null, null){
            private PsiType[] myExpressionTypes;

            @Override
            public boolean isVarargs() {
                return varargs;
            }

            @Override
            protected PsiElement getParent() {
                return parent2;
            }

            @Override
            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null) {
                    PsiType[] expressionTypes = argumentList2.getExpressionTypes();
                    if (MethodCandidateInfo.isOverloadCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }
        };
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors2;
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(7);
        }
        for (PsiMethod method : constructors2 = psiClass.getConstructors()) {
            if (!method.getParameterList().isEmpty()) continue;
            return true;
        }
        return constructors2.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(8);
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                PsiType type2 = parameter.getType();
                Boolean accept = type2.accept(new PsiTypeVisitor<Boolean>(){

                    @Override
                    public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                        if (arrayType == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return arrayType.getComponentType().accept(this);
                    }

                    @Override
                    public Boolean visitClassType(@NotNull PsiClassType classType) {
                        if (classType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        for (PsiType psiType2 : classType.getParameters()) {
                            Boolean typeParamFound;
                            if (psiType2 == null || (typeParamFound = psiType2.accept(this)) == null || !typeParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType(classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    @Override
                    public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                        PsiType bound;
                        if (wildcardType == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        if ((bound = wildcardType.getBound()) == null) {
                            return false;
                        }
                        return bound.accept(this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "arrayType";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "classType";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "wildcardType";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondTypeImpl$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitArrayType";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClassType";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitWildcardType";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (accept == null || !accept.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticFactoryMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypeParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFactoryCandidateInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "haveConstructorsGenericsParameters";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InferredAnonymousTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private final PsiElement myExpression;

        InferredAnonymousTypeVisitor(PsiElement expression2) {
            this.myExpression = expression2;
        }

        @Override
        @Nullable
        public Boolean visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            if (capturedWildcardType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType2) {
            if (intersectionType2 == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            if (classType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) != null) {
                if (psiClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)psiClass)) {
                    return false;
                }
                if (!PsiUtil.isAccessible(psiClass, this.myExpression, null)) {
                    return false;
                }
                for (PsiType psiType2 : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    Boolean accepted = psiType2 != null ? psiType2.accept(this) : null;
                    if (accepted == null || accepted.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intersectionType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondTypeImpl$InferredAnonymousTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCapturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntersectionType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

