/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J&\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/daemon/report/BuildReportICReporter;", "Lorg/jetbrains/kotlin/build/report/ICReporterBase;", "Lorg/jetbrains/kotlin/build/report/RemoteICReporter;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "rootDir", "Ljava/io/File;", "isVerbose", "", "(Lorg/jetbrains/kotlin/daemon/common/CompilationResults;Ljava/io/File;Z)V", "icLogLines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "recompilationReason", "Ljava/util/HashMap;", "flush", "", "report", "message", "Lkotlin/Function0;", "reportCompileIteration", "incremental", "sourceFiles", "", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "reportMarkDirty", "affectedFiles", "", "reason", "reportVerbose", "kotlin-daemon"})
public final class BuildReportICReporter
extends ICReporterBase
implements RemoteICReporter {
    @NotNull
    private final CompilationResults compilationResults;
    private final boolean isVerbose;
    @NotNull
    private final ArrayList<String> icLogLines;
    @NotNull
    private final HashMap<File, String> recompilationReason;

    public BuildReportICReporter(@NotNull CompilationResults compilationResults, @NotNull File rootDir, boolean isVerbose) {
        Intrinsics.checkNotNullParameter(compilationResults, "compilationResults");
        Intrinsics.checkNotNullParameter(rootDir, "rootDir");
        super(rootDir);
        this.compilationResults = compilationResults;
        this.isVerbose = isVerbose;
        this.icLogLines = new ArrayList();
        this.recompilationReason = new HashMap();
    }

    public /* synthetic */ BuildReportICReporter(CompilationResults compilationResults, File file2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(compilationResults, file2, bl);
    }

    @Override
    public void report(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.icLogLines.add(message.invoke());
    }

    @Override
    public void reportVerbose(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.isVerbose) {
            this.report(message);
        }
    }

    @Override
    public void reportCompileIteration(boolean incremental, @NotNull Collection<? extends File> sourceFiles2, @NotNull ExitCode exitCode) {
        Intrinsics.checkNotNullParameter(sourceFiles2, "sourceFiles");
        Intrinsics.checkNotNullParameter((Object)exitCode, "exitCode");
        if (!incremental) {
            return;
        }
        this.icLogLines.add("Compile iteration:");
        for (File file2 : sourceFiles2) {
            String string2;
            block6: {
                block5: {
                    string2 = this.recompilationReason.get(file2);
                    if (string2 == null) break block5;
                    String it = string2;
                    boolean bl = false;
                    String string3 = " <- " + it;
                    string2 = string3;
                    if (string3 != null) break block6;
                }
                string2 = "";
            }
            String reason = string2;
            this.icLogLines.add("  " + this.relativeOrCanonical(file2) + reason);
        }
        this.recompilationReason.clear();
    }

    @Override
    public void reportMarkDirty(@NotNull Iterable<? extends File> affectedFiles, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(affectedFiles, "affectedFiles");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Iterable<? extends File> $this$forEach$iv = affectedFiles;
        boolean $i$f$forEach = false;
        Iterator<? extends File> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            File element$iv;
            File it = element$iv = iterator2.next();
            boolean bl = false;
            ((Map)this.recompilationReason).put(it, reason);
        }
    }

    @Override
    public void flush() {
        this.compilationResults.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), this.icLogLines);
    }
}

