/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAmbiguousAnonymousTypeChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAmbiguousAnonymousTypeChecker INSTANCE = new FirAmbiguousAnonymousTypeChecker();

    private FirAmbiguousAnonymousTypeChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter2, "reporter");
            if (!(declaration instanceof FirSimpleFunction) && !(declaration instanceof FirProperty)) {
                return;
            }
            if (!(declaration instanceof FirCallableDeclaration)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            Iterable $this$any$iv = context.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(DeclarationUtilsKt.isLocalMember(it) || it instanceof FirAnonymousObject)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isInline2 = false;
        if (!TypeUtilsKt.shouldHideLocalType(TypeUtilsKt.visibilityForApproximation(declaration, CollectionsKt.lastOrNull(context.getContainingDeclarations())), $this$isInline$iv.getStatus().isInline())) {
            return;
        }
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(((FirCallableDeclaration)declaration).getReturnTypeRef()), context.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
        if (classSymbol instanceof FirAnonymousObjectSymbol) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            Iterable $i$f$isInline2 = ((FirAnonymousObjectSymbol)classSymbol).getResolvedSuperTypeRefs();
            KtDiagnosticFactory1<Collection<ConeKotlinType>> ktDiagnosticFactory1 = FirErrors.INSTANCE.getAMBIGUOUS_ANONYMOUS_TYPE_INFERRED();
            AbstractKtSourceElement abstractKtSourceElement = declaration.getSource();
            DiagnosticReporter diagnosticReporter = reporter2;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)collection, (DiagnosticContext)context, null, 16, null);
        }
    }
}

