/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J,\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001fj\b\u0012\u0004\u0012\u00020\u0016` 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u0013*\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010%\u001a\u00020\u0013*\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "cloneableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "javaLangFqName", "reservedFunctionNames", "", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCloneableId", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isNotFinalReadOnly", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "primaryConstructorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isRecursiveInlineClassType", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRelatedToParameter", "parameter", "isSubtypeOfCloneable", "checkers"})
public final class FirInlineClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirInlineClassDeclarationChecker INSTANCE = new FirInlineClassDeclarationChecker();
    @NotNull
    private static final Set<String> reservedFunctionNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirInlineClassDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        block47: {
            block46: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter2, "reporter");
                if (!DeclarationUtilsKt.isInlineOrValueClass(declaration)) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block46;
                FirClassLikeDeclaration $this$isLocal$iv = declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block47;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), (DiagnosticContext)context, null, 8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), (DiagnosticContext)context, null, 8, null);
        }
        for (FirTypeRef supertypeEntry : declaration.getSuperTypeRefs()) {
            boolean bl;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context.getSession());
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                ClassKind entry = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                bl = entry == ClassKind.INTERFACE;
            } else {
                bl = false;
            }
            if (bl) continue;
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, supertypeEntry, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), context, null, 8, null);
        }
        if (this.isSubtypeOfCloneable(declaration, context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), (DiagnosticContext)context, null, 8, null);
        }
        FirConstructor primaryConstructor2 = null;
        Map primaryConstructorParametersByName = MapsKt.emptyMap();
        Map primaryConstructorPropertiesByName = new LinkedHashMap();
        Set primaryConstructorParametersSymbolsSet = SetsKt.emptySet();
        for (FirDeclaration firDeclaration : declaration.getDeclarations()) {
            FirDeclaration $i$f$isInterface2 = firDeclaration;
            if ($i$f$isInterface2 instanceof FirConstructor) {
                FirBlock body2;
                if (((FirConstructor)firDeclaration).isPrimary()) {
                    void $this$mapTo$iv$iv;
                    Object object;
                    void $this$associateByTo$iv$iv;
                    primaryConstructor2 = (FirConstructor)firDeclaration;
                    Iterable $this$associateBy$iv = ((FirConstructor)firDeclaration).getValueParameters();
                    boolean $i$f$associateBy = false;
                    int capacity$iv232 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                    Iterable iterable = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.put(it.getName(), element$iv$iv);
                    }
                    Map $this$map$iv = primaryConstructorParametersByName = destination$iv$iv;
                    boolean $i$f$map = false;
                    Map capacity$iv232 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        Object element$iv$iv;
                        element$iv$iv = item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        FirValueParameter parameter = (FirValueParameter)element$iv$iv.getValue();
                        object.add(parameter.getSymbol());
                    }
                    primaryConstructorParametersSymbolsSet = CollectionsKt.toSet((List)destination$iv$iv2);
                    continue;
                }
                if (((FirConstructor)firDeclaration).getBody() == null) continue;
                Intrinsics.checkNotNull(((FirConstructor)firDeclaration).getBody());
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(firDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext context2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl = false;
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), context2, null, 8, null);
                    continue;
                }
                CheckerContext context3 = (CheckerContext)((MutableDiagnosticContext)context);
                boolean bl = false;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), context3, null, 8, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)firDeclaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, firDeclaration, FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), context, null, 8, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirSimpleFunction) {
                String functionName;
                Intrinsics.checkNotNullExpressionValue(((FirSimpleFunction)firDeclaration).getName().asString(), "innerDeclaration.name.asString()");
                if (!reservedFunctionNames.contains(functionName)) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, firDeclaration, FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), functionName, context, null, 16, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirField) {
                FirCallableSymbol<?> symbol2;
                FirDeclaration $this$isSynthetic$iv = firDeclaration;
                boolean $i$f$isSynthetic = false;
                if (!Intrinsics.areEqual($this$isSynthetic$iv.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                FirExpression firExpression2 = ((FirField)firDeclaration).getInitializer();
                FirCallableSymbol<Object> firCallableSymbol = symbol2 = firExpression2 != null ? FirExpressionUtilKt.toResolvedCallableSymbol(firExpression2) : null;
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && symbol2 != null && CollectionsKt.contains(primaryConstructorParametersSymbolsSet, symbol2)) continue;
                FirTypeRef firTypeRef = ((FirField)firDeclaration).getReturnTypeRef();
                Intrinsics.checkNotNull(firTypeRef, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
                FirTypeRef firTypeRef2 = ((FirResolvedTypeRef)firTypeRef).getDelegatedTypeRef();
                KtSourceElement delegatedTypeRefSource = firTypeRef2 != null ? firTypeRef2.getSource() : null;
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(firDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext context4 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context4, null, 8, null);
                    continue;
                }
                CheckerContext context5 = (CheckerContext)((MutableDiagnosticContext)context);
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context5, null, 8, null);
                continue;
            }
            if (!($i$f$isInterface2 instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)firDeclaration, (FirValueParameter)primaryConstructorParametersByName.get(((FirProperty)firDeclaration).getName()))) {
                primaryConstructorPropertiesByName.put(((FirProperty)firDeclaration).getName(), firDeclaration);
                continue;
            }
            if (((FirProperty)firDeclaration).getDelegate() != null) {
                boolean $i$f$withSuppressedDiagnostics = false;
                List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(firDeclaration);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext context6 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl = false;
                    FirExpression firExpression3 = ((FirProperty)firDeclaration).getDelegate();
                    Intrinsics.checkNotNull(firExpression3);
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firExpression3.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context6, null, 8, null);
                    continue;
                }
                CheckerContext context7 = (CheckerContext)((MutableDiagnosticContext)context);
                boolean bl = false;
                FirExpression firExpression4 = ((FirProperty)firDeclaration).getDelegate();
                Intrinsics.checkNotNull(firExpression4);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)firExpression4.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context7, null, 8, null);
                continue;
            }
            if (!DeclarationAttributesKt.getHasBackingField((FirProperty)firDeclaration)) continue;
            KtSourceElement ktSourceElement = firDeclaration.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, firDeclaration, FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), context, null, 8, null);
        }
        Object object = primaryConstructor2;
        if (!((object != null && (object = ((FirConstructor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
            if (primaryConstructorParametersByName.isEmpty()) {
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructor2, FirErrors.INSTANCE.getVALUE_CLASS_EMPTY_CONSTRUCTOR(), context, null, 8, null);
                return;
            }
        } else if (primaryConstructorParametersByName.size() != 1) {
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructor2, FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), context, null, 8, null);
            return;
        }
        for (Map.Entry entry : primaryConstructorParametersByName.entrySet()) {
            boolean inlineClassHasGenericUnderlyingType;
            boolean bl;
            ConeKotlinType it;
            boolean bl2;
            CheckerContext context2;
            List<String> arguments$iv;
            boolean $i$f$withSuppressedDiagnostics;
            Name name2 = (Name)entry.getKey();
            FirValueParameter primaryConstructorParameter = (FirValueParameter)entry.getValue();
            boolean $i$f$withSuppressedDiagnostics2 = false;
            List<String> arguments$iv2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(primaryConstructor2);
            if (arguments$iv2 != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                CheckerContext context3 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                boolean bl3 = false;
                $i$f$withSuppressedDiagnostics = false;
                arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(primaryConstructorParameter);
                if (arguments$iv != null) {
                    DiagnosticContext diagnosticContext2 = ((MutableDiagnosticContext)context3).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    if (diagnosticContext2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    context2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext2));
                    bl2 = false;
                    if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name2))) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                        continue;
                    }
                    if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                        it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                        bl = false;
                        inlineClassHasGenericUnderlyingType = it instanceof ConeTypeParameterType || INSTANCE.isGenericArrayOfTypeParameter(it);
                        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && inlineClassHasGenericUnderlyingType) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
                        continue;
                    }
                    if (!INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context2.getSession())) continue;
                    FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context2, null, 8, null);
                    continue;
                }
                context2 = (CheckerContext)((MutableDiagnosticContext)context3);
                bl2 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name2))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                    bl = false;
                    inlineClassHasGenericUnderlyingType = it instanceof ConeTypeParameterType || INSTANCE.isGenericArrayOfTypeParameter(it);
                    if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && inlineClassHasGenericUnderlyingType) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
                    continue;
                }
                if (!INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context2.getSession())) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context2, null, 8, null);
                continue;
            }
            CheckerContext context9 = (CheckerContext)((MutableDiagnosticContext)context);
            boolean bl3 = false;
            $i$f$withSuppressedDiagnostics = false;
            arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(primaryConstructorParameter);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context9).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                context2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl2 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name2))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                    bl = false;
                    inlineClassHasGenericUnderlyingType = it instanceof ConeTypeParameterType || INSTANCE.isGenericArrayOfTypeParameter(it);
                    if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && inlineClassHasGenericUnderlyingType) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
                    continue;
                }
                if (!INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context2.getSession())) continue;
                FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context2, null, 8, null);
                continue;
            }
            CheckerContext context8 = (CheckerContext)((MutableDiagnosticContext)context9);
            boolean bl22 = false;
            if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name2))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context8, null, 8, null);
                continue;
            }
            if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                boolean bl4 = false;
                inlineClassHasGenericUnderlyingType = it instanceof ConeTypeParameterType || INSTANCE.isGenericArrayOfTypeParameter(it);
                if (context8.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && inlineClassHasGenericUnderlyingType) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context8, null, 16, null);
                continue;
            }
            if (!INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context8.getSession())) continue;
            FirDiagnosticReportHelpersKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), context8, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter) {
        FirValueParameter firValueParameter = parameter;
        if (!Intrinsics.areEqual($this$isRelatedToParameter.getName(), firValueParameter != null ? firValueParameter.getName() : null)) return false;
        KtSourceElement ktSourceElement = $this$isRelatedToParameter.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return false;
        return true;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType) {
        return FirTypeUtilsKt.isUnit($this$isInapplicableParameterType) || FirTypeUtilsKt.isNothing($this$isInapplicableParameterType) || FirTypeUtilsKt.getConeType($this$isInapplicableParameterType) instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType));
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull($this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !ArrayUtilsKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$isGenericArrayOfTypeParameter);
        if (coneKotlinType == null || (coneKotlinType = coneKotlinType.getType()) == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, FirSession session2) {
        return this.isRecursiveInlineClassType($this$isRecursiveInlineClassType, new HashSet<ConeKotlinType>(), session2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, HashSet<ConeKotlinType> visited2, FirSession session2) {
        boolean bl;
        boolean bl2;
        block7: {
            Object v3;
            block6: {
                void $this$firstOrNull$iv;
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isRecursiveInlineClassType, session2);
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
                if (firRegularClassSymbol == null) return false;
                Object object = firRegularClassSymbol2;
                FirRegularClassSymbol it = object;
                boolean bl3 = false;
                if (!DeclarationUtilsKt.isInlineOrValueClass(it)) return false;
                FirRegularClassSymbol firRegularClassSymbol3 = object;
                firRegularClassSymbol2 = firRegularClassSymbol3;
                if (firRegularClassSymbol3 == null) {
                    return false;
                }
                FirRegularClassSymbol asRegularClass = firRegularClassSymbol2;
                object = asRegularClass.getDeclarationSymbols();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirBasedSymbol it2 = (FirBasedSymbol)element$iv;
                    boolean bl4 = false;
                    if (!(it2 instanceof FirConstructorSymbol && ((FirConstructorSymbol)it2).isPrimary())) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            FirConstructorSymbol firConstructorSymbol = v3;
            if (firConstructorSymbol == null) {
                return false;
            }
            FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
            if (!visited2.add($this$isRecursiveInlineClassType)) return true;
            Iterable $this$any$iv = primaryConstructor2.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl5 = false;
                    if (!INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), visited2, session2)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
        }
        boolean it = bl = bl2;
        boolean bl6 = false;
        visited2.remove($this$isRecursiveInlineClassType);
        if (!bl) return false;
        return true;
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session2) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session2, false, null, 32, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    boolean bl3 = object != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session2, null, 2, null)) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? INSTANCE.isCloneableId((ClassId)object) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual($this$isCloneableId.getRelativeClassName(), cloneableFqName) && Intrinsics.areEqual($this$isCloneableId.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual($this$isCloneableId.getPackageFqName(), javaLangFqName);
    }

    static {
        String[] stringArray = new String[]{"box", "unbox", "equals", "hashCode"};
        reservedFunctionNames = SetsKt.setOf(stringArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }
}

