/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "description", "", "getDescription", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)Ljava/lang/String;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirNestedClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNestedClassChecker INSTANCE = new FirNestedClassChecker();

    private FirNestedClassChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        block9: {
            FirDeclaration firDeclaration;
            FirDeclaration containingDeclaration;
            block8: {
                block10: {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(context, "context");
                    Intrinsics.checkNotNullParameter(reporter2, "reporter");
                    if (declaration.getClassKind().isSingleton() || declaration.getClassKind() == ClassKind.ENUM_CLASS) {
                        FirClassLikeDeclaration $this$isLocal$iv = declaration;
                        boolean $i$f$isLocal = false;
                        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                            return;
                        }
                    }
                    FirDeclaration firDeclaration2 = CollectionsKt.lastOrNull(context.getContainingDeclarations());
                    if (firDeclaration2 == null) {
                        return;
                    }
                    containingDeclaration = firDeclaration2;
                    firDeclaration = containingDeclaration;
                    if (!(firDeclaration instanceof FirRegularClass)) break block8;
                    FirMemberDeclaration $this$isInner$iv = declaration;
                    boolean $i$f$isInner = false;
                    if ($this$isInner$iv.getStatus().isInner()) break block9;
                    $this$isInner$iv = (FirMemberDeclaration)containingDeclaration;
                    $i$f$isInner = false;
                    if ($this$isInner$iv.getStatus().isInner()) break block10;
                    FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)containingDeclaration;
                    boolean $i$f$isLocal = false;
                    if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block9;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration), (DiagnosticContext)context, null, 16, null);
                break block9;
            }
            if (firDeclaration instanceof FirClass && ((FirClass)containingDeclaration).getClassKind() == ClassKind.ENUM_ENTRY) {
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) {
                    FirRegularClass $this$isCompanion$iv = declaration;
                    boolean $i$f$isCompanion = false;
                    if (!$this$isCompanion$iv.getStatus().isCompanion()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration), (DiagnosticContext)context, null, 16, null);
                    }
                }
            }
        }
    }

    private final String getDescription(FirRegularClass $this$description) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$description.getClassKind().ordinal()]) {
            case 1: {
                string2 = "Class";
                break;
            }
            case 2: {
                string2 = "Interface";
                break;
            }
            case 3: {
                string2 = "Enum class";
                break;
            }
            case 4: {
                string2 = "Enum entry";
                break;
            }
            case 5: {
                string2 = "Annotation class";
                break;
            }
            case 6: {
                FirRegularClass $this$isCompanion$iv = $this$description;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) {
                    string2 = "Companion object";
                    break;
                }
                string2 = "Object";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.CLASS.ordinal()] = 1;
            nArray[ClassKind.INTERFACE.ordinal()] = 2;
            nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            nArray[ClassKind.OBJECT.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

