/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.OperatorNames;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "add", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "l", "r", "and", "andand", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "buildBinaryOperator", "name", "Lorg/jetbrains/kotlin/name/Name;", "buildUnaryOperator", "v", "div", "inv", "mod", "mul", "not", "or", "oror", "shl", "shr", "shru", "sub", "backend.js"})
public final class JsIrArithBuilder {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Symbols<JsIrBackendContext> symbols;

    public JsIrArithBuilder(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.symbols = this.context.getIr().getSymbols();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Symbols<JsIrBackendContext> getSymbols() {
        return this.symbols;
    }

    private final IrExpression buildBinaryOperator(Name name2, IrExpression l, IrExpression r) {
        IrCall irCall;
        IrSimpleFunctionSymbol symbol2;
        IrType irType = l.getType();
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        IrType irType2 = r.getType();
        Intrinsics.checkNotNull(irType2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = symbol2 = this.context.getOperatorByName(name2, irSimpleType, (IrSimpleType)irType2);
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        IrCall $this$buildBinaryOperator_u24lambda_u2d0 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irSimpleFunctionSymbol, null, null, null, 14, null);
        boolean bl = false;
        $this$buildBinaryOperator_u24lambda_u2d0.setDispatchReceiver(l);
        $this$buildBinaryOperator_u24lambda_u2d0.putValueArgument(0, r);
        return irCall;
    }

    private final IrExpression buildUnaryOperator(Name name2, IrExpression v) {
        IrCall irCall;
        IrType irType = v.getType();
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getOperatorByName(name2, (IrSimpleType)irType, null);
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        IrSimpleFunctionSymbol symbol2 = irSimpleFunctionSymbol;
        IrCall $this$buildUnaryOperator_u24lambda_u2d1 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, symbol2, null, null, null, 14, null);
        boolean bl = false;
        $this$buildUnaryOperator_u24lambda_u2d1.setDispatchReceiver(v);
        return irCall;
    }

    @NotNull
    public final IrExpression add(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getADD(), l, r);
    }

    @NotNull
    public final IrExpression sub(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSUB(), l, r);
    }

    @NotNull
    public final IrExpression mul(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getMUL(), l, r);
    }

    @NotNull
    public final IrExpression div(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getDIV(), l, r);
    }

    @NotNull
    public final IrExpression mod(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getMOD(), l, r);
    }

    @NotNull
    public final IrExpression and(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getAND(), l, r);
    }

    @NotNull
    public final IrExpression or(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getOR(), l, r);
    }

    @NotNull
    public final IrExpression shl(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHL(), l, r);
    }

    @NotNull
    public final IrExpression shr(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHR(), l, r);
    }

    @NotNull
    public final IrExpression shru(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHRU(), l, r);
    }

    @NotNull
    public final IrExpression not(@NotNull IrExpression v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getNOT(), v);
    }

    @NotNull
    public final IrExpression inv(@NotNull IrExpression v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getINV(), v);
    }

    @NotNull
    public final IrWhen andand(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return JsIrBuilder.INSTANCE.buildIfElse(this.context.getIrBuiltIns().getBooleanType(), l, r, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false));
    }

    @NotNull
    public final IrWhen oror(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(r, "r");
        return JsIrBuilder.INSTANCE.buildIfElse(this.context.getIrBuiltIns().getBooleanType(), l, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true), r);
    }
}

