/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator;", "", "baseDir", "Ljava/io/File;", "(Ljava/io/File;)V", "baseDirPath", "", "calculateRelativePathTo", "", "file", "js.sourcemap"})
public final class RelativePathCalculator {
    @NotNull
    private final List<File> baseDirPath;

    public RelativePathCalculator(@NotNull File baseDir) {
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        this.baseDirPath = CollectionsKt.asReversed(SequencesKt.toList(SequencesKt.generateSequence(baseDir.getCanonicalFile(), (Function1)baseDirPath.1.INSTANCE)));
    }

    @Nullable
    public final String calculateRelativePathTo(@NotNull File file2) {
        int i;
        Intrinsics.checkNotNullParameter(file2, "file");
        List<File> path2 = CollectionsKt.asReversed(SequencesKt.toList(SequencesKt.generateSequence(file2.getCanonicalFile(), (Function1)calculateRelativePathTo.path.1.INSTANCE)));
        if (!Intrinsics.areEqual(this.baseDirPath.get(0), path2.get(0))) {
            return null;
        }
        Iterable $this$takeWhile$iv = CollectionsKt.zip((Iterable)this.baseDirPath, (Iterable)path2);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            File second2;
            Pair pair = (Pair)item$iv;
            boolean bl = false;
            File first2 = (File)pair.component1();
            if (!Intrinsics.areEqual(first2, second2 = (File)pair.component2())) break;
            list$iv.add(item$iv);
        }
        int commonLength = ((List)list$iv).size();
        StringBuilder sb = new StringBuilder();
        int n = this.baseDirPath.size();
        for (i = commonLength; i < n; ++i) {
            sb.append("../");
        }
        n = path2.size();
        for (i = commonLength; i < n; ++i) {
            sb.append(path2.get(i).getName()).append('/');
        }
        sb.setLength(StringsKt.getLastIndex(sb));
        return sb.toString();
    }
}

