/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;

public class PluginContainer
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<Plugin> plugins;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation pluginsLocation;

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public PluginContainer clone() {
        try {
            PluginContainer copy2 = (PluginContainer)super.clone();
            if (this.plugins != null) {
                copy2.plugins = new ArrayList<Plugin>();
                for (Plugin item : this.plugins) {
                    copy2.plugins.add(item.clone());
                }
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case -475629664: {
                    if (!string2.equals("plugins")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.pluginsLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public void setLocation(Object key, InputLocation location) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case -475629664: {
                    if (!string2.equals("plugins")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location;
                    return;
                }
                case 1: {
                    this.pluginsLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }
}

