/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.interpolation.reflection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.reflection.ClassMap;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.util.StringUtils;

public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, WeakReference<ClassMap>> classMaps = new WeakHashMap();

    public static Object evaluate(String expression2, Object root2, boolean trimRootToken) throws Exception {
        Tokenizer tokenizer;
        boolean hasDots;
        Object value2 = root2;
        if (expression2 == null || "".equals(expression2.trim()) || !Character.isJavaIdentifierStart(expression2.charAt(0))) {
            return null;
        }
        boolean bl = hasDots = expression2.indexOf(46) >= 0;
        if (trimRootToken && hasDots) {
            tokenizer = new Tokenizer(expression2);
            tokenizer.nextPropertyName();
            if (tokenizer.getPosition() == -1) {
                return null;
            }
        } else {
            tokenizer = new Tokenizer("." + expression2);
        }
        int propertyPosition = tokenizer.getPosition();
        block5: while (value2 != null && tokenizer.peekChar() != -1) {
            switch (tokenizer.skipChar()) {
                case 91: {
                    value2 = ReflectionValueExtractor.getIndexedValue(expression2, propertyPosition, tokenizer.getPosition(), value2, tokenizer.nextToken(']'));
                    continue block5;
                }
                case 40: {
                    value2 = ReflectionValueExtractor.getMappedValue(expression2, propertyPosition, tokenizer.getPosition(), value2, tokenizer.nextToken(')'));
                    continue block5;
                }
                case 46: {
                    propertyPosition = tokenizer.getPosition();
                    value2 = ReflectionValueExtractor.getPropertyValue(value2, tokenizer.nextPropertyName());
                    continue block5;
                }
            }
            return null;
        }
        return value2;
    }

    private static Object getMappedValue(String expression2, int from2, int to, Object value2, String key) throws Exception {
        if (value2 == null || key == null) {
            return null;
        }
        if (value2 instanceof Map) {
            Object[] localParams = new Object[]{key};
            ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
            Method method = classMap.findMethod("get", localParams);
            return method.invoke(value2, localParams);
        }
        String message = String.format("The token '%s' at position '%d' refers to a java.util.Map, but the value seems is an instance of '%s'", expression2.subSequence(from2, to), from2, value2.getClass());
        throw new Exception(message);
    }

    private static Object getIndexedValue(String expression2, int from2, int to, Object value2, String indexStr) throws Exception {
        try {
            int index2 = Integer.parseInt(indexStr);
            if (value2.getClass().isArray()) {
                return Array.get(value2, index2);
            }
            if (value2 instanceof List) {
                ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
                Object[] localParams = new Object[]{index2};
                Method method = classMap.findMethod("get", localParams);
                return method.invoke(value2, localParams);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IndexOutOfBoundsException) {
                return null;
            }
            throw e;
        }
        String message = String.format("The token '%s' at position '%d' refers to a java.util.List or an array, but the value seems is an instance of '%s'", expression2.subSequence(from2, to), from2, value2.getClass());
        throw new Exception(message);
    }

    private static Object getPropertyValue(Object value2, String property2) throws Exception {
        if (value2 == null || property2 == null) {
            return null;
        }
        ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
        String methodBase = StringUtils.capitalizeFirstLetter(property2);
        String methodName = "get" + methodBase;
        Method method = classMap.findMethod(methodName, CLASS_ARGS);
        if (method == null) {
            methodName = "is" + methodBase;
            method = classMap.findMethod(methodName, CLASS_ARGS);
        }
        if (method == null) {
            return null;
        }
        return method.invoke(value2, OBJECT_ARGS);
    }

    private static ClassMap getClassMap(Class<?> clazz) {
        ClassMap classMap;
        WeakReference<ClassMap> softRef = classMaps.get(clazz);
        if (softRef == null || (classMap = (ClassMap)softRef.get()) == null) {
            classMap = new ClassMap(clazz);
            classMaps.put(clazz, new WeakReference<ClassMap>(classMap));
        }
        return classMap;
    }

    static class Tokenizer {
        final String expression;
        int idx;

        public Tokenizer(String expression2) {
            this.expression = expression2;
        }

        public int peekChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx) : -1;
        }

        public int skipChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx++) : -1;
        }

        public String nextToken(char delimiter) {
            int start = this.idx;
            while (this.idx < this.expression.length() && delimiter != this.expression.charAt(this.idx)) {
                ++this.idx;
            }
            if (this.idx <= start || this.idx >= this.expression.length()) {
                return null;
            }
            return this.expression.substring(start, this.idx++);
        }

        public String nextPropertyName() {
            int start = this.idx;
            while (this.idx < this.expression.length() && Character.isJavaIdentifierPart(this.expression.charAt(this.idx))) {
                ++this.idx;
            }
            if (this.idx <= start || this.idx > this.expression.length()) {
                return null;
            }
            return this.expression.substring(start, this.idx);
        }

        public int getPosition() {
            return this.idx < this.expression.length() ? this.idx : -1;
        }

        public String toString() {
            return this.idx < this.expression.length() ? this.expression.substring(this.idx) : "<EOF>";
        }
    }
}

