/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifact;

public abstract class AbstractArtifact
implements Artifact {
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    @Override
    public boolean isSnapshot() {
        return AbstractArtifact.isSnapshot(this.getVersion());
    }

    private static boolean isSnapshot(String version) {
        return version.endsWith("SNAPSHOT") || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    @Override
    public String getBaseVersion() {
        return AbstractArtifact.toBaseVersion(this.getVersion());
    }

    private static String toBaseVersion(String version) {
        Matcher m;
        String baseVersion = version == null ? null : (version.startsWith("[") || version.startsWith("(") ? version : ((m = SNAPSHOT_TIMESTAMP.matcher(version)).matches() ? (m.group(1) != null ? m.group(1) + "SNAPSHOT" : "SNAPSHOT") : version));
        return baseVersion;
    }

    private Artifact newInstance(String version, Map<String, String> properties2, File file2) {
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), version, file2, properties2);
    }

    @Override
    public Artifact setVersion(String version) {
        String current = this.getVersion();
        if (current.equals(version) || version == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(version, this.getProperties(), this.getFile());
    }

    @Override
    public Artifact setFile(File file2) {
        File current = this.getFile();
        if (Objects.equals(current, file2)) {
            return this;
        }
        return this.newInstance(this.getVersion(), this.getProperties(), file2);
    }

    @Override
    public Artifact setProperties(Map<String, String> properties2) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties2) || properties2 == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(this.getVersion(), AbstractArtifact.copyProperties(properties2), this.getFile());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value2 = this.getProperties().get(key);
        return value2 != null ? value2 : defaultValue;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties2) {
        if (properties2 != null && !properties2.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties2));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getGroupId());
        buffer.append(':').append(this.getArtifactId());
        buffer.append(':').append(this.getExtension());
        if (this.getClassifier().length() > 0) {
            buffer.append(':').append(this.getClassifier());
        }
        buffer.append(':').append(this.getVersion());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact that = (Artifact)obj;
        return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getExtension(), that.getExtension()) && Objects.equals(this.getClassifier(), that.getClassifier()) && Objects.equals(this.getFile(), that.getFile()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getExtension().hashCode();
        hash = hash * 31 + this.getClassifier().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractArtifact.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

