/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.impl.OfflineController;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.RepositoryOfflineException;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named
public class DefaultOfflineController
implements OfflineController {
    private static final Pattern SEP = Pattern.compile("\\s*,\\s*");

    @Override
    public void checkOffline(RepositorySystemSession session2, RemoteRepository repository) throws RepositoryOfflineException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (this.isOfflineProtocol(session2, repository) || this.isOfflineHost(session2, repository)) {
            return;
        }
        throw new RepositoryOfflineException(repository);
    }

    private boolean isOfflineProtocol(RepositorySystemSession session2, RemoteRepository repository) {
        String protocol;
        String[] protocols = this.getConfig(session2, "aether.offline.protocols");
        if (protocols != null && (protocol = repository.getProtocol()).length() > 0) {
            for (String p : protocols) {
                if (!p.equalsIgnoreCase(protocol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfflineHost(RepositorySystemSession session2, RemoteRepository repository) {
        String host;
        String[] hosts = this.getConfig(session2, "aether.offline.hosts");
        if (hosts != null && (host = repository.getHost()).length() > 0) {
            for (String h : hosts) {
                if (!h.equalsIgnoreCase(host)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getConfig(RepositorySystemSession session2, String key) {
        String value2 = ConfigUtils.getString(session2, "", key).trim();
        if (value2.isEmpty()) {
            return null;
        }
        return SEP.split(value2);
    }
}

