/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.SessionData;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdateCheck;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdateCheckManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.DefaultUpdateCheckManager$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Utils;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationDigest;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactTransferException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.MetadataNotFoundException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.MetadataTransferException;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultUpdateCheckManager
implements UpdateCheckManager,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUpdatePolicyAnalyzer.class);
    private TrackingFileManager trackingFileManager;
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    static final Object SESSION_CHECKS = new Object(){

        public String toString() {
            return "updateCheckManager.checks";
        }
    };

    @Override
    public void initService(ServiceLocator locator) {
        this.setTrackingFileManager(locator.getService(TrackingFileManager.class));
        this.setUpdatePolicyAnalyzer(locator.getService(UpdatePolicyAnalyzer.class));
    }

    public DefaultUpdateCheckManager setTrackingFileManager(TrackingFileManager trackingFileManager) {
        TrackingFileManager trackingFileManager2 = trackingFileManager;
        trackingFileManager2.getClass();
        this.trackingFileManager = trackingFileManager2;
        return this;
    }

    public DefaultUpdateCheckManager setUpdatePolicyAnalyzer(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.updatePolicyAnalyzer = Objects.requireNonNull(updatePolicyAnalyzer, "update policy analyzer cannot be null");
        return this;
    }

    @Override
    public void checkArtifact(RepositorySystemSession session2, UpdateCheck<Artifact, ArtifactTransferException> check2) {
        long lastUpdated;
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(check2, "check cannot be null");
        if (check2.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session2, check2.getLocalLastUpdated(), check2.getPolicy())) {
            LOGGER.debug("Skipped remote request for {}, locally installed artifact up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
            return;
        }
        Artifact artifact = check2.getItem();
        RemoteRepository repository = check2.getRepository();
        File artifactFile = Objects.requireNonNull(check2.getFile(), String.format("The artifact '%s' has no file attached", artifact));
        boolean fileExists = check2.isFileValid() && artifactFile.exists();
        File touchFile = this.getArtifactTouchFile(artifactFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session2, artifactFile, repository);
        String dataKey = this.getDataKey(repository);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? artifactFile.lastModified() : 0L;
        } else if (error.isEmpty()) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session2, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check2.setRequired(true);
        } else if (this.isAlreadyUpdated(session2, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check2.getItem());
            check2.setRequired(false);
            if (error != null) {
                check2.setException(this.newException(error, artifact, repository));
            }
        } else if (this.isUpdatedRequired(session2, lastUpdated, check2.getPolicy())) {
            check2.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached artifact up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session2, artifact, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check2.setRequired(false);
                check2.setException(this.newException(error, artifact, repository));
            } else {
                check2.setRequired(true);
            }
        }
    }

    private static int getCacheFlag(String error) {
        if (error == null || error.isEmpty()) {
            return 1;
        }
        return 2;
    }

    private ArtifactTransferException newException(String error, Artifact artifact, RemoteRepository repository) {
        if (error == null || error.isEmpty()) {
            return new ArtifactNotFoundException(artifact, repository, artifact + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new ArtifactTransferException(artifact, repository, artifact + " failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    @Override
    public void checkMetadata(RepositorySystemSession session2, UpdateCheck<Metadata, MetadataTransferException> check2) {
        long lastUpdated;
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(check2, "check cannot be null");
        if (check2.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session2, check2.getLocalLastUpdated(), check2.getPolicy())) {
            LOGGER.debug("Skipped remote request for {} locally installed metadata up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
            return;
        }
        Metadata metadata2 = check2.getItem();
        RemoteRepository repository = check2.getRepository();
        File metadataFile = Objects.requireNonNull(check2.getFile(), String.format("The metadata '%s' has no file attached", metadata2));
        boolean fileExists = check2.isFileValid() && metadataFile.exists();
        File touchFile = this.getMetadataTouchFile(metadataFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session2, metadataFile, repository);
        String dataKey = this.getDataKey(metadataFile);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? this.getLastUpdated(props, dataKey) : 0L;
        } else if (error.isEmpty()) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session2, metadataFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check2.setRequired(true);
        } else if (this.isAlreadyUpdated(session2, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check2.getItem());
            check2.setRequired(false);
            if (error != null) {
                check2.setException(this.newException(error, metadata2, repository));
            }
        } else if (this.isUpdatedRequired(session2, lastUpdated, check2.getPolicy())) {
            check2.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached metadata up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session2, metadata2, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check2.setRequired(false);
                check2.setException(this.newException(error, metadata2, repository));
            } else {
                check2.setRequired(true);
            }
        }
    }

    private MetadataTransferException newException(String error, Metadata metadata2, RemoteRepository repository) {
        if (error == null || error.isEmpty()) {
            return new MetadataNotFoundException(metadata2, repository, metadata2 + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new MetadataTransferException(metadata2, repository, metadata2 + " failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    private long getLastUpdated(Properties props, String key) {
        String value2 = props.getProperty(key + ".lastUpdated", "");
        try {
            return value2.length() > 0 ? Long.parseLong(value2) : 1L;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Cannot parse last updated date {}, ignoring it", (Object)value2, (Object)e);
            return 1L;
        }
    }

    private String getError(Properties props, String key) {
        return props.getProperty(key + ".error");
    }

    private File getArtifactTouchFile(File artifactFile) {
        return new File(artifactFile.getPath() + ".lastUpdated");
    }

    private File getMetadataTouchFile(File metadataFile) {
        return new File(metadataFile.getParent(), "resolver-status.properties");
    }

    private String getDataKey(RemoteRepository repository) {
        Set<String> mirroredUrls = Collections.emptySet();
        if (repository.isRepositoryManager()) {
            mirroredUrls = new TreeSet<String>();
            for (RemoteRepository mirroredRepository : repository.getMirroredRepositories()) {
                mirroredUrls.add(this.normalizeRepoUrl(mirroredRepository.getUrl()));
            }
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        for (String mirroredUrl : mirroredUrls) {
            buffer.append('+').append(mirroredUrl);
        }
        return buffer.toString();
    }

    private String getTransferKey(RepositorySystemSession session2, RemoteRepository repository) {
        return this.getRepoKey(session2, repository);
    }

    private String getDataKey(File metadataFile) {
        return metadataFile.getName();
    }

    private String getTransferKey(RepositorySystemSession session2, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName() + '/' + this.getRepoKey(session2, repository);
    }

    private String getRepoKey(RepositorySystemSession session2, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(128);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            buffer.append(AuthenticationDigest.forProxy(session2, repository)).append('@');
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        buffer.append(AuthenticationDigest.forRepository(session2, repository)).append('@');
        buffer.append(repository.getContentType()).append('-');
        buffer.append(repository.getId()).append('-');
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        return buffer.toString();
    }

    private String normalizeRepoUrl(String url) {
        String result2 = url;
        if (url != null && url.length() > 0 && !url.endsWith("/")) {
            result2 = url + '/';
        }
        return result2;
    }

    private String getUpdateKey(RepositorySystemSession session2, File file2, RemoteRepository repository) {
        return file2.getAbsolutePath() + '|' + this.getRepoKey(session2, repository);
    }

    private int getSessionState(RepositorySystemSession session2) {
        String mode = ConfigUtils.getString(session2, "enabled", "aether.updateCheckManager.sessionState");
        if (Boolean.parseBoolean(mode) || "enabled".equalsIgnoreCase(mode)) {
            return 0;
        }
        if ("bypass".equalsIgnoreCase(mode)) {
            return 1;
        }
        return 2;
    }

    private boolean isAlreadyUpdated(RepositorySystemSession session2, Object updateKey) {
        if (this.getSessionState(session2) >= 1) {
            return false;
        }
        SessionData data2 = session2.getData();
        Object checkedFiles = data2.get(SESSION_CHECKS);
        if (!(checkedFiles instanceof Map)) {
            return false;
        }
        return ((Map)checkedFiles).containsKey(updateKey);
    }

    private void setUpdated(RepositorySystemSession session2, Object updateKey) {
        if (this.getSessionState(session2) >= 2) {
            return;
        }
        SessionData data2 = session2.getData();
        Object checkedFiles = data2.computeIfAbsent(SESSION_CHECKS, DefaultUpdateCheckManager$$Lambda$0.INSTANCE);
        ((Map)checkedFiles).put(updateKey, Boolean.TRUE);
    }

    private boolean isUpdatedRequired(RepositorySystemSession session2, long lastModified, String policy) {
        return this.updatePolicyAnalyzer.isUpdatedRequired(session2, lastModified, policy);
    }

    private Properties read(File touchFile) {
        Properties props = this.trackingFileManager.read(touchFile);
        return props != null ? props : new Properties();
    }

    @Override
    public void touchArtifact(RepositorySystemSession session2, UpdateCheck<Artifact, ArtifactTransferException> check2) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(check2, "check cannot be null");
        File artifactFile = check2.getFile();
        File touchFile = this.getArtifactTouchFile(artifactFile);
        String updateKey = this.getUpdateKey(session2, artifactFile, check2.getRepository());
        String dataKey = this.getDataKey(check2.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session2, check2.getRepository());
        this.setUpdated(session2, updateKey);
        Properties props = this.write(touchFile, dataKey, transferKey, check2.getException());
        if (artifactFile.exists() && !this.hasErrors(props)) {
            touchFile.delete();
        }
    }

    private boolean hasErrors(Properties props) {
        for (Object key : props.keySet()) {
            if (!key.toString().endsWith(".error")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void touchMetadata(RepositorySystemSession session2, UpdateCheck<Metadata, MetadataTransferException> check2) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(check2, "check cannot be null");
        File metadataFile = check2.getFile();
        File touchFile = this.getMetadataTouchFile(metadataFile);
        String updateKey = this.getUpdateKey(session2, metadataFile, check2.getRepository());
        String dataKey = this.getDataKey(metadataFile);
        String transferKey = this.getTransferKey(session2, metadataFile, check2.getRepository());
        this.setUpdated(session2, updateKey);
        this.write(touchFile, dataKey, transferKey, check2.getException());
    }

    private Properties write(File touchFile, String dataKey, String transferKey, Exception error) {
        HashMap<String, String> updates = new HashMap<String, String>();
        String timestamp = Long.toString(System.currentTimeMillis());
        if (error == null) {
            updates.put(dataKey + ".error", null);
            updates.put(dataKey + ".lastUpdated", timestamp);
            updates.put(transferKey + ".lastUpdated", null);
        } else if (error instanceof ArtifactNotFoundException || error instanceof MetadataNotFoundException) {
            updates.put(dataKey + ".error", "");
            updates.put(dataKey + ".lastUpdated", timestamp);
            updates.put(transferKey + ".lastUpdated", null);
        } else {
            String msg2 = error.getMessage();
            if (msg2 == null || msg2.isEmpty()) {
                msg2 = error.getClass().getSimpleName();
            }
            updates.put(dataKey + ".error", msg2);
            updates.put(dataKey + ".lastUpdated", null);
            updates.put(transferKey + ".lastUpdated", timestamp);
        }
        return this.trackingFileManager.update(touchFile, updates);
    }

    private static /* synthetic */ Object lambda$setUpdated$0() {
        return new ConcurrentHashMap(256);
    }

    static /* synthetic */ Object accessor$DefaultUpdateCheckManager$lambda0() {
        return DefaultUpdateCheckManager.lambda$setUpdated$0();
    }
}

