/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.support;

import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.ReadWriteLockNamedLock$$Lambda$0;

public class ReadWriteLockNamedLock
extends NamedLockSupport {
    private final ThreadLocal<Deque<Step>> threadSteps = ThreadLocal.withInitial(ReadWriteLockNamedLock$$Lambda$0.INSTANCE);
    private final ReadWriteLock readWriteLock;

    public ReadWriteLockNamedLock(String name2, NamedLockFactorySupport factory2, ReadWriteLock readWriteLock) {
        super(name2, factory2);
        this.readWriteLock = readWriteLock;
    }

    @Override
    public boolean lockShared(long time, TimeUnit unit2) throws InterruptedException {
        Deque<Step> steps = this.threadSteps.get();
        if (this.readWriteLock.readLock().tryLock(time, unit2)) {
            steps.push(Step.SHARED);
            return true;
        }
        return false;
    }

    @Override
    public boolean lockExclusively(long time, TimeUnit unit2) throws InterruptedException {
        Deque<Step> steps = this.threadSteps.get();
        if (!steps.isEmpty() && !steps.contains((Object)Step.EXCLUSIVE)) {
            return false;
        }
        if (this.readWriteLock.writeLock().tryLock(time, unit2)) {
            steps.push(Step.EXCLUSIVE);
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        Deque<Step> steps = this.threadSteps.get();
        if (steps.isEmpty()) {
            throw new IllegalStateException("Wrong API usage: unlock without lock");
        }
        Step step = steps.pop();
        if (Step.SHARED == step) {
            this.readWriteLock.readLock().unlock();
        } else if (Step.EXCLUSIVE == step) {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private static final class Step
    extends Enum<Step> {
        public static final /* enum */ Step SHARED = new Step();
        public static final /* enum */ Step EXCLUSIVE = new Step();
        private static final /* synthetic */ Step[] $VALUES;

        public static Step[] values() {
            return (Step[])$VALUES.clone();
        }

        static {
            $VALUES = new Step[]{SHARED, EXCLUSIVE};
        }
    }
}

