/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyCollectionContext;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;

public final class AndDependencySelector
implements DependencySelector {
    private final Set<? extends DependencySelector> selectors;
    private int hashCode;

    public AndDependencySelector(DependencySelector ... selectors) {
        this.selectors = selectors != null && selectors.length > 0 ? new LinkedHashSet<DependencySelector>(Arrays.asList(selectors)) : Collections.emptySet();
    }

    private AndDependencySelector(Set<DependencySelector> selectors) {
        this.selectors = selectors != null && !selectors.isEmpty() ? selectors : Collections.emptySet();
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        for (DependencySelector dependencySelector : this.selectors) {
            if (dependencySelector.selectDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        int seen = 0;
        LinkedHashSet<DependencySelector> childSelectors = null;
        for (DependencySelector dependencySelector : this.selectors) {
            DependencySelector childSelector = dependencySelector.deriveChildSelector(context);
            if (childSelectors != null) {
                if (childSelector == null) continue;
                childSelectors.add(childSelector);
                continue;
            }
            if (dependencySelector != childSelector) {
                childSelectors = new LinkedHashSet<DependencySelector>();
                if (seen > 0) {
                    for (DependencySelector dependencySelector2 : this.selectors) {
                        if (childSelectors.size() >= seen) break;
                        childSelectors.add(dependencySelector2);
                    }
                }
                if (childSelector == null) continue;
                childSelectors.add(childSelector);
                continue;
            }
            ++seen;
        }
        if (childSelectors == null) {
            return this;
        }
        if (childSelectors.size() <= 1) {
            if (childSelectors.isEmpty()) {
                return null;
            }
            return (DependencySelector)childSelectors.iterator().next();
        }
        return new AndDependencySelector((Set<DependencySelector>)childSelectors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AndDependencySelector that = (AndDependencySelector)obj;
        return this.selectors.equals(that.selectors);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 17;
            this.hashCode = hash = hash * 31 + this.selectors.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        Iterator<? extends DependencySelector> iterator2 = this.selectors.iterator();
        while (iterator2.hasNext()) {
            DependencySelector selector = iterator2.next();
            builder2.append(selector.toString());
            if (!iterator2.hasNext()) continue;
            builder2.append(" && ");
        }
        return builder2.append(')').toString();
    }
}

