/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.bean;

import java.util.ArrayList;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.Scopes;
import org.jetbrains.kotlin.com.google.inject.matcher.Matcher;
import org.jetbrains.kotlin.com.google.inject.matcher.Matchers;
import org.jetbrains.kotlin.com.google.inject.spi.BindingScopingVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.DefaultBindingScopingVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.ProvisionListener;

public abstract class BeanScheduler {
    static final Object CYCLE_ACTIVATOR;
    static final Object CANDIDATE_CYCLE;
    static final Object CYCLE_CONFIRMED;
    public static final Module MODULE;
    static final ThreadLocal<Object[]> pendingHolder;

    static {
        CycleActivator cycleActivator;
        Object candidateCycle = new Object();
        Object cycleConfirmed = new Object();
        try {
            Binder.class.getMethod("bindListener", Matcher.class, ProvisionListener[].class);
            String detectCycles = System.getProperty("sisu.detect.cycles");
            cycleActivator = "false".equalsIgnoreCase(detectCycles) ? null : new CycleActivator();
            if ("pessimistic".equalsIgnoreCase(detectCycles)) {
                candidateCycle = cycleConfirmed;
            }
        }
        catch (Exception exception) {
            cycleActivator = null;
        }
        catch (LinkageError linkageError) {
            cycleActivator = null;
        }
        CYCLE_ACTIVATOR = cycleActivator;
        CANDIDATE_CYCLE = candidateCycle;
        CYCLE_CONFIRMED = cycleConfirmed;
        MODULE = new Module(){

            @Override
            public void configure(Binder binder) {
                if (CYCLE_ACTIVATOR != null) {
                    binder.bindListener(Matchers.any(), (ProvisionListener)CYCLE_ACTIVATOR);
                }
            }
        };
        pendingHolder = new ThreadLocal();
    }

    public static void detectCycle(Object value2) {
        Object pending;
        Object[] holder2;
        if (CYCLE_ACTIVATOR != null && Scopes.isCircularProxy(value2) && (holder2 = pendingHolder.get()) != null && CANDIDATE_CYCLE.equals(pending = holder2[0])) {
            holder2[0] = CYCLE_CONFIRMED;
        }
    }

    public final void schedule(Object bean) {
        Object[] holder2;
        if (CYCLE_ACTIVATOR != null && (holder2 = pendingHolder.get()) != null) {
            Object pending = holder2[0];
            if (CYCLE_CONFIRMED.equals(pending)) {
                holder2[0] = new Pending(bean);
                return;
            }
            if (pending instanceof Pending) {
                ((Pending)pending).add(bean);
                return;
            }
        }
        this.activate(bean);
    }

    protected abstract void activate(Object var1);

    static final class CycleActivator
    implements ProvisionListener {
        private static final BindingScopingVisitor<Boolean> IS_SCOPED = new DefaultBindingScopingVisitor<Boolean>(){

            @Override
            public Boolean visitNoScoping() {
                return Boolean.FALSE;
            }

            @Override
            protected Boolean visitOther() {
                return Boolean.TRUE;
            }
        };

        CycleActivator() {
        }

        @Override
        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
            if (Boolean.TRUE.equals(pi.getBinding().acceptScopingVisitor(IS_SCOPED))) {
                Object[] holder2 = pendingHolder.get();
                if (holder2 == null) {
                    holder2 = new Object[1];
                    pendingHolder.set(holder2);
                }
                if (holder2[0] == null) {
                    Object pending;
                    holder2[0] = CANDIDATE_CYCLE;
                    try {
                        pi.provision();
                    }
                    finally {
                        pending = holder2[0];
                        holder2[0] = null;
                    }
                    if (pending instanceof Pending) {
                        ((Pending)pending).activate();
                    }
                }
            }
        }
    }

    private final class Pending
    extends ArrayList<Object> {
        Pending(Object bean) {
            this.add(bean);
        }

        public void activate() {
            int i = 0;
            int size = this.size();
            while (i < size) {
                BeanScheduler.this.activate(this.get(i));
                ++i;
            }
        }
    }
}

