/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedConstructorCallChecker INSTANCE = new ProtectedConstructorCallChecker();

    private ProtectedConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        ConstructorDescriptor actualConstructor;
        DeclarationDescriptor scopeOwner;
        ConstructorDescriptor descriptor2;
        block7: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context, "context");
            Object obj = resolvedCall2.getResultingDescriptor();
            ConstructorDescriptor constructorDescriptor = obj instanceof ConstructorDescriptor ? (ConstructorDescriptor)obj : null;
            if (constructorDescriptor == null) {
                return;
            }
            descriptor2 = constructorDescriptor;
            ClassifierDescriptor classifierDescriptor = descriptor2.getContainingDeclaration().getOriginal();
            Intrinsics.checkNotNullExpressionValue(classifierDescriptor, "descriptor.containingDeclaration.original");
            ClassifierDescriptor constructorOwner = classifierDescriptor;
            scopeOwner = context.getScope().getOwnerDescriptor();
            ConstructorDescriptor constructorDescriptor2 = descriptor2 instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)descriptor2 : null;
            ConstructorDescriptor constructorDescriptor3 = constructorDescriptor2 != null && (constructorDescriptor2 = constructorDescriptor2.getUnderlyingConstructorDescriptor()) != null ? (ConstructorDescriptor)constructorDescriptor2 : (actualConstructor = descriptor2);
            if (!Intrinsics.areEqual(actualConstructor.getVisibility().normalize(), DescriptorVisibilities.PROTECTED)) {
                return;
            }
            if (!DescriptorVisibilityUtils.isVisibleWithAnyReceiver(descriptor2, scopeOwner, context.getLanguageVersionSettings())) {
                return;
            }
            KtExpression calleeExpression = resolvedCall2.getCall().getCalleeExpression();
            KtExpression ktExpression = calleeExpression;
            if (ktExpression instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression).getParent() instanceof KtSuperTypeCallEntry : ktExpression instanceof KtConstructorDelegationReferenceExpression) {
                return;
            }
            Sequence<DeclarationDescriptor> $this$any$iv = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
            boolean $i$f$any = false;
            Iterator<DeclarationDescriptor> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor element$iv;
                DeclarationDescriptor it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getOriginal() == constructorOwner)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (Intrinsics.areEqual(DescriptorVisibilityUtils.findInvisibleMember(DescriptorVisibilities.FALSE_IF_PROTECTED, descriptor2, scopeOwner, context.getLanguageVersionSettings()), actualConstructor.getOriginal())) {
            context.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on(reportOn, descriptor2));
        }
    }
}

