/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0006\u0012\u0013\u0014\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findRelevantDataClassPropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ClassifierUsage", "Companion", "ExperimentalityDiagnostic", "ExperimentalityDiagnostic2", "ExperimentalityDiagnostics", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final ExperimentalityDiagnostics USAGE_DIAGNOSTICS;

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, "resultingDescriptor");
        Set experimentalities = org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, (DeclarationDescriptor)resultingDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings(), null, false, false, 28, null);
        if (resultingDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)resultingDescriptor).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && (propertyDescriptor = this.findRelevantDataClassPropertyIfAny((FunctionDescriptor)resultingDescriptor, context)) != null) {
            Companion.reportNotAcceptedExperimentalities(SetsKt.plus(experimentalities, org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, propertyDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings(), null, false, false, 28, null)), reportOn, context);
            return;
        }
        Companion.reportNotAcceptedExperimentalities(experimentalities, reportOn, context);
    }

    private final PropertyDescriptor findRelevantDataClassPropertyIfAny(FunctionDescriptor $this$findRelevantDataClassPropertyIfAny, CallCheckerContext context) {
        String string2 = $this$findRelevantDataClassPropertyIfAny.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        Integer index2 = StringsKt.toIntOrNull(StringsKt.removePrefix(string2, (CharSequence)"component"));
        DeclarationDescriptor declarationDescriptor = $this$findRelevantDataClassPropertyIfAny.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).isData() && index2 != null) {
            ValueParameterDescriptor dataClassParameterDescriptor;
            Object object = ((ClassDescriptor)container).getUnsubstitutedPrimaryConstructor();
            ValueParameterDescriptor valueParameterDescriptor = object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.getOrNull(object, index2 - 1) : (dataClassParameterDescriptor = null);
            if (dataClassParameterDescriptor != null) {
                return (PropertyDescriptor)context.getTrace().getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, dataClassParameterDescriptor);
            }
        }
        return null;
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"level\")");
        LEVEL = name2;
        Name name3 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"message\")");
        MESSAGE = name3;
        Name name4 = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(\"WARNING\")");
        WARNING_LEVEL = name4;
        Name name5 = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(\"ERROR\")");
        ERROR_LEVEL = name5;
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = Errors.OPT_IN_USAGE;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "OPT_IN_USAGE");
        ExperimentalityDiagnostic experimentalityDiagnostic = new ExperimentalityDiagnostic2(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("should")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = Errors.OPT_IN_USAGE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory22, "OPT_IN_USAGE_ERROR");
        ExperimentalityDiagnostic experimentalityDiagnostic2 = new ExperimentalityDiagnostic2(diagnosticFactory22, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("must")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory23 = Errors.OPT_IN_USAGE_FUTURE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory23, "OPT_IN_USAGE_FUTURE_ERROR");
        USAGE_DIAGNOSTICS = new ExperimentalityDiagnostics(experimentalityDiagnostic, experimentalityDiagnostic2, new ExperimentalityDiagnostic2(diagnosticFactory23, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental due to signature types and its usage must be marked (will become an error in 1.6)")));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface ExperimentalityDiagnostic {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic2;", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "defaultMessage", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;)V", "getDefaultMessage", "()Lkotlin/jvm/functions/Function1;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    public static final class ExperimentalityDiagnostic2
    implements ExperimentalityDiagnostic {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<FqName, String> defaultMessage;

        public ExperimentalityDiagnostic2(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory2, @NotNull Function1<? super FqName, String> defaultMessage) {
            Intrinsics.checkNotNullParameter(factory2, "factory");
            Intrinsics.checkNotNullParameter(defaultMessage, "defaultMessage");
            this.factory = factory2;
            this.defaultMessage = defaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultMessage() {
            return this.defaultMessage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message) {
            String string2;
            FqName fqName3;
            PsiElement psiElement;
            DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2;
            BindingTrace bindingTrace;
            block4: {
                block3: {
                    void it;
                    String string3;
                    Intrinsics.checkNotNullParameter(trace, "trace");
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(fqName2, "fqName");
                    bindingTrace = trace;
                    diagnosticFactory2 = this.factory;
                    psiElement = element;
                    fqName3 = fqName2;
                    string2 = message;
                    if (string2 == null) break block3;
                    String string4 = string3 = string2;
                    FqName fqName4 = fqName3;
                    PsiElement psiElement2 = psiElement;
                    DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = diagnosticFactory2;
                    BindingTrace bindingTrace2 = bindingTrace;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    bindingTrace = bindingTrace2;
                    diagnosticFactory2 = diagnosticFactory22;
                    psiElement = psiElement2;
                    fqName3 = fqName4;
                    string2 = bl2 ? string3 : null;
                    if (string2 != null) break block4;
                }
                string2 = this.defaultMessage.invoke(fqName2);
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnosticFactory2.on(psiElement, fqName3, string2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "factory.on(element, fqNa\u2026: defaultMessage(fqName))");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "", "warning", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "error", "futureError", "(Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "getFutureError", "getWarning", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class ExperimentalityDiagnostics {
        @NotNull
        private final ExperimentalityDiagnostic warning;
        @NotNull
        private final ExperimentalityDiagnostic error;
        @NotNull
        private final ExperimentalityDiagnostic futureError;

        public ExperimentalityDiagnostics(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error, @NotNull ExperimentalityDiagnostic futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            this.warning = warning;
            this.error = error;
            this.futureError = futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostic getWarning() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic getError() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostic getFutureError() {
            return this.futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostic component1() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic component2() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostic component3() {
            return this.futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostics copy(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error, @NotNull ExperimentalityDiagnostic futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            return new ExperimentalityDiagnostics(warning, error, futureError);
        }

        public static /* synthetic */ ExperimentalityDiagnostics copy$default(ExperimentalityDiagnostics experimentalityDiagnostics, ExperimentalityDiagnostic experimentalityDiagnostic, ExperimentalityDiagnostic experimentalityDiagnostic2, ExperimentalityDiagnostic experimentalityDiagnostic3, int n, Object object) {
            if ((n & 1) != 0) {
                experimentalityDiagnostic = experimentalityDiagnostics.warning;
            }
            if ((n & 2) != 0) {
                experimentalityDiagnostic2 = experimentalityDiagnostics.error;
            }
            if ((n & 4) != 0) {
                experimentalityDiagnostic3 = experimentalityDiagnostics.futureError;
            }
            return experimentalityDiagnostics.copy(experimentalityDiagnostic, experimentalityDiagnostic2, experimentalityDiagnostic3);
        }

        @NotNull
        public String toString() {
            return "ExperimentalityDiagnostics(warning=" + this.warning + ", error=" + this.error + ", futureError=" + this.futureError + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.futureError.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExperimentalityDiagnostics)) {
                return false;
            }
            ExperimentalityDiagnostics experimentalityDiagnostics = (ExperimentalityDiagnostics)other;
            if (!Intrinsics.areEqual(this.warning, experimentalityDiagnostics.warning)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.error, experimentalityDiagnostics.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.futureError, experimentalityDiagnostics.futureError);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011J!\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J4\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bJ$\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J0\u0010#\u001a\u00020$*\u00020\u001d2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020$0\u0011H\u0082\bJ\u001c\u0010(\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010-\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J\u001c\u0010-\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002JD\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0/*\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u000200042\b\b\u0002\u00105\u001a\u00020$2\b\b\u0002\u00106\u001a\u00020$J2\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0/*\u0004\u0018\u0001072\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\f\u00108\u001a\b\u0012\u0004\u0012\u00020004H\u0002J\u001d\u00109\u001a\u0004\u0018\u00010\u001b*\u00020:2\b\b\u0002\u00105\u001a\u00020$H\u0000\u00a2\u0006\u0002\b;R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "LEVEL", "MESSAGE", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "WARNING_LEVEL", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "getDefaultDiagnosticMessage", "Lorg/jetbrains/kotlin/name/FqName;", "prefix", "getDefaultDiagnosticMessage$frontend", "reportNotAcceptedExperimentalities", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/Experimentality;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isElementAnnotatedWithOptIn", "isExperimentalityAccepted", "loadExperimentalities", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "visited", "", "useFutureError", "useMarkersFromContainer", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitedClassifiers", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            return new Function1<FqName, String>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkNotNullParameter(fqName2, "fqName");
                    String string2 = fqName2.asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "fqName.asString()");
                    return OptInNames.INSTANCE.buildDefaultDiagnosticMessage(this.$prefix, string2);
                }
            };
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull CheckerContext context) {
            Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context, "context");
            this.reportNotAcceptedExperimentalities(experimentalities, element, context.getLanguageVersionSettings(), context.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull ExperimentalityDiagnostics diagnostics2) {
            Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
            for (Experimentality experimentality : experimentalities) {
                ExperimentalityDiagnostic experimentalityDiagnostic;
                FqName annotationFqName = experimentality.component1();
                Experimentality.Severity severity = experimentality.component2();
                String message = experimentality.component3();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
                if (this.isExperimentalityAccepted(element, annotationFqName, languageVersionSettings, bindingContext)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        experimentalityDiagnostic = diagnostics2.getWarning();
                        break;
                    }
                    case 2: {
                        experimentalityDiagnostic = diagnostics2.getError();
                        break;
                    }
                    case 3: {
                        experimentalityDiagnostic = diagnostics2.getFutureError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ExperimentalityDiagnostic diagnostic = experimentalityDiagnostic;
                diagnostic.report(trace, element, annotationFqName, message);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $this$loadExperimentalities, @NotNull ModuleAnnotationsResolver moduleAnnotationsResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Set<DeclarationDescriptor> visited2, boolean useFutureError, boolean useMarkersFromContainer) {
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block14: {
                Object it;
                Intrinsics.checkNotNullParameter($this$loadExperimentalities, "<this>");
                Intrinsics.checkNotNullParameter(moduleAnnotationsResolver, "moduleAnnotationsResolver");
                Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
                Intrinsics.checkNotNullParameter(visited2, "visited");
                if (!visited2.add($this$loadExperimentalities)) {
                    return SetsKt.emptySet();
                }
                result2 = SmartSet.Companion.create();
                if ($this$loadExperimentalities instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$loadExperimentalities).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)$this$loadExperimentalities).getOverriddenDescriptors()) {
                        ClassDescriptor it2;
                        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "overridden");
                        result2.addAll(this.loadExperimentalities(callableMemberDescriptor, moduleAnnotationsResolver, languageVersionSettings, visited2, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false));
                        if (!useMarkersFromContainer) continue;
                        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)$this$loadExperimentalities).getContainingDeclaration();
                        if ((declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) == null) continue;
                        it2 = it2;
                        boolean bl2 = false;
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, it2, moduleAnnotationsResolver, languageVersionSettings, visited2, useFutureError, false, 16, null));
                    }
                    return result2;
                }
                for (AnnotationDescriptor annotationDescriptor : $this$loadExperimentalities.getAnnotations()) {
                    ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor, useFutureError) : null);
                }
                if ($this$loadExperimentalities instanceof CallableDescriptor && !($this$loadExperimentalities instanceof ClassConstructorDescriptor)) {
                    result2.addAll(this.loadExperimentalities(((CallableDescriptor)$this$loadExperimentalities).getReturnType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)$this$loadExperimentalities).getExtensionReceiverParameter();
                    result2.addAll(this.loadExperimentalities(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, moduleAnnotationsResolver, languageVersionSettings, visited2));
                    if ($this$loadExperimentalities instanceof FunctionDescriptor) {
                        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$this$loadExperimentalities).getValueParameters();
                        Intrinsics.checkNotNullExpressionValue(list2, "valueParameters");
                        Iterable $this$forEach$iv = list2;
                        boolean bl2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (ValueParameterDescriptor)element$iv;
                            boolean bl3 = false;
                            result2.addAll(Companion.loadExperimentalities(it.getType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                        }
                    }
                }
                if ($this$loadExperimentalities instanceof TypeAliasDescriptor) {
                    result2.addAll(this.loadExperimentalities(((TypeAliasDescriptor)$this$loadExperimentalities).getExpandedType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                }
                Iterable $this$any$iv = $this$loadExperimentalities.getAnnotations();
                boolean bl3 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadExperimentalities, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Experimentality it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, it, false, 1, null) == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                smartSet.addAll((List)destination$iv$iv);
            }
            DeclarationDescriptor container = $this$loadExperimentalities.getContainingDeclaration();
            if (useMarkersFromContainer && container instanceof ClassDescriptor && !($this$loadExperimentalities instanceof ConstructorDescriptor)) {
                result2.addAll(org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(this, container, moduleAnnotationsResolver, languageVersionSettings, visited2, useFutureError, false, 16, null));
            }
            return result2;
        }

        public static /* synthetic */ Set loadExperimentalities$default(Companion companion, DeclarationDescriptor declarationDescriptor, ModuleAnnotationsResolver moduleAnnotationsResolver, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            return companion.loadExperimentalities(declarationDescriptor, moduleAnnotationsResolver, languageVersionSettings, set, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Experimentality> loadExperimentalities(KotlinType $this$loadExperimentalities, ModuleAnnotationsResolver moduleAnnotationsResolver, LanguageVersionSettings languageVersionSettings, Set<DeclarationDescriptor> visitedClassifiers) {
            Set<Experimentality> set;
            KotlinType kotlinType = $this$loadExperimentalities;
            if (!(kotlinType != null ? !KotlinTypeKt.isError(kotlinType) : false)) {
                set = SetsKt.emptySet();
            } else if ($this$loadExperimentalities instanceof AbbreviatedType) {
                Set set2;
                ClassifierDescriptor classifierDescriptor = ((AbbreviatedType)$this$loadExperimentalities).getAbbreviation().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(this, classifierDescriptor, moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, 16, null) : (set2 = null)) == null) {
                    set2 = SetsKt.emptySet();
                }
                set = SetsKt.plus(set2, (Iterable)this.loadExperimentalities(((AbbreviatedType)$this$loadExperimentalities).getExpandedType(), moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers));
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Set set3;
                ClassifierDescriptor classifierDescriptor = $this$loadExperimentalities.getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(this, classifierDescriptor, moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, 16, null) : (set3 = null)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Iterable iterable = $this$loadExperimentalities.getArguments();
                Set set4 = set3;
                boolean $i$f$flatMap = false;
                void var7_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TypeProjection it = (TypeProjection)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.isStarProjection() ? SetsKt.emptySet() : Companion.loadExperimentalities(it.getType(), moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                set = SetsKt.plus(set4, (List)destination$iv$iv);
            }
            return set;
        }

        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadExperimentalityForMarkerAnnotation, boolean useFutureError) {
            Name name2;
            Intrinsics.checkNotNullParameter($this$loadExperimentalityForMarkerAnnotation, "<this>");
            AnnotationDescriptor annotationDescriptor = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor == null && (annotationDescriptor = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME())) == null) {
                return null;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments2 = experimental.getAllValueArguments();
            ConstantValue<?> constantValue = arguments2.get(LEVEL);
            EnumValue enumValue = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name3 = name2 = enumValue != null ? enumValue.getEnumEntryName() : null;
            Experimentality.Severity severity = Intrinsics.areEqual(name2, WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual(name2, ERROR_LEVEL) ? (useFutureError ? Experimentality.Severity.FUTURE_ERROR : Experimentality.Severity.ERROR) : (Experimentality.Companion.getDEFAULT_SEVERITY() == Experimentality.Severity.ERROR && useFutureError ? Experimentality.Severity.FUTURE_ERROR : Experimentality.Companion.getDEFAULT_SEVERITY()));
            constantValue = arguments2.get(MESSAGE);
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message = stringValue != null ? (String)stringValue.getValue() : null;
            return new Experimentality(DescriptorUtilsKt.getFqNameSafe($this$loadExperimentalityForMarkerAnnotation), severity, message);
        }

        public static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$frontend$default(Companion companion, ClassDescriptor classDescriptor, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor, bl);
        }

        private final boolean isExperimentalityAccepted(PsiElement $this$isExperimentalityAccepted, FqName annotationFqName, CheckerContext context) {
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            return this.isExperimentalityAccepted($this$isExperimentalityAccepted, annotationFqName, languageVersionSettings, bindingContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExperimentalityAccepted(@NotNull PsiElement $this$isExperimentalityAccepted, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter($this$isExperimentalityAccepted, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(annotationFqName.asString())) return true;
            Companion companion = this;
            PsiElement $this$anyParentMatches$iv = $this$isExperimentalityAccepted;
            boolean $i$f$anyParentMatches = false;
            PsiElement element$iv = $this$anyParentMatches$iv;
            while (true) {
                PsiElement psiElement;
                PsiElement element = element$iv;
                boolean bl = false;
                if (Companion.isDeclarationAnnotatedWith(element, annotationFqName, bindingContext)) return true;
                if (Companion.isElementAnnotatedWithOptIn(element, annotationFqName, bindingContext)) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                PsiElement psiElement2 = psiElement = element$iv.getParent();
                if (psiElement2 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue(psiElement2, "element.parent ?: return false");
                element$iv = psiElement;
            }
        }

        private final boolean isDeclarationAnnotatedWith(PsiElement $this$isDeclarationAnnotatedWith, FqName annotationFqName, BindingContext bindingContext) {
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor2 != null && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithOptIn(PsiElement $this$isElementAnnotatedWithOptIn, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithOptIn instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$this$isElementAnnotatedWithOptIn).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "annotationEntries");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 != null && CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getOPT_IN_FQ_NAMES(), descriptor2.getFqName())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl3;
                        Iterable $this$any$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                boolean bl4 = false;
                                if (annotationClass instanceof KClassValue) {
                                    KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                                    boolean bl5 = false;
                                    if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual(((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                        return true;
                                    }
                                    boolean bl6 = false;
                                    if (bl6) {
                                        return true;
                                    }
                                }
                                boolean bl7 = false;
                                if (!bl7) continue;
                                return true;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError2, "reportError");
            Intrinsics.checkNotNullParameter(reportWarning, "reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("ExperimentalUsageChecker"), languageVersionSettings, DeprecationSettings.Default.INSTANCE);
            Iterable $this$forEach$iv = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fqName2 = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(fqName2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString()) || Intrinsics.areEqual(fqName2, OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().asString())) continue;
                org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError2, fqName2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, DeprecationResolver deprecationResolver, Function1<? super String, Unit> $reportError, String fqName2) {
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor2 == null) {
                $reportWarning.invoke("Opt-in requirement marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies");
                return false;
            }
            if (org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, descriptor2, false, 1, null) == null) {
                $reportWarning.invoke("Class " + fqName2 + " is not an opt-in requirement marker");
                return false;
            }
            for (DescriptorBasedDeprecationInfo deprecation2 : deprecationResolver.getDeprecations(descriptor2)) {
                String string2;
                String string3;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                switch (WhenMappings.$EnumSwitchMapping$1[deprecation2.getDeprecationLevel().ordinal()]) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder2 = new StringBuilder().append("Opt-in requirement marker ").append(fqName2).append(" is deprecated");
                if (deprecation2.getMessage() != null) {
                    void it;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl = false;
                    String string4 = ". " + (String)it;
                    function12 = function13;
                    stringBuilder2 = stringBuilder3;
                    string3 = string4;
                } else {
                    string3 = string2 = null;
                }
                if (string3 == null) {
                    string2 = "";
                }
                function12.invoke(stringBuilder2.append(string2).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                nArray[Experimentality.Severity.FUTURE_ERROR.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinExperimentalOrOptIn", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsOptInArgument", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isUsageAsQualifier", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            void $this$getParentOfType$iv;
            ClassDescriptor targetClass;
            Object object;
            Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context, "context");
            Name name2 = targetDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "targetDescriptor.name");
            Name name3 = name2;
            if (Intrinsics.areEqual(name3, OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual(name3, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual(name3, OptInNames.INSTANCE.getOLD_USE_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual(name3, OptInNames.INSTANCE.getOPT_IN_FQ_NAME().shortName())) {
                FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(targetDescriptor);
                if (OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAMES().contains(fqName2) || OptInNames.INSTANCE.getOPT_IN_FQ_NAMES().contains(fqName2)) {
                    this.checkUsageOfKotlinExperimentalOrOptIn(element, context);
                    return;
                }
            }
            ClassDescriptor classDescriptor = (object = targetDescriptor) instanceof ClassDescriptor ? (ClassDescriptor)targetDescriptor : (targetClass = object instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
            if (targetClass != null && org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, targetClass, false, 1, null) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element)) {
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
                if (!this.isUsageAsOptInArgument(element, bindingContext)) {
                    context.getTrace().report(Errors.OPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN.on(element));
                }
            }
            object = element;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, strict$iv) == null) {
                Set experimentalities = new LinkedHashSet();
                CollectionsKt.addAll((Collection)experimentalities, org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, targetDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings(), null, false, false, 28, null));
                if (targetDescriptor instanceof TypeAliasDescriptor) {
                    DeclarationDescriptor[] declarationDescriptorArray = new DeclarationDescriptor[]{targetDescriptor};
                    experimentalities.addAll(Companion.loadExperimentalities(((TypeAliasDescriptor)targetDescriptor).getExpandedType(), this.moduleAnnotationsResolver, context.getLanguageVersionSettings(), SetsKt.mutableSetOf(declarationDescriptorArray)));
                }
                Companion.reportNotAcceptedExperimentalities(experimentalities, element, context);
            }
        }

        private final void checkUsageOfKotlinExperimentalOrOptIn(PsiElement element, CheckerContext context) {
            List<String> optInFqNames = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
            if (!(context.getLanguageVersionSettings().supportsFeature(LanguageFeature.OptInRelease) || optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString()) || optInFqNames.contains(OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().asString()))) {
                context.getTrace().report(Errors.OPT_IN_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context.getTrace().report(Errors.OPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            if ($this$isUsageAsQualifier instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$this$isUsageAsQualifier;
                PsiElement psiElement = qualifier.getParent();
                KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
                if (Intrinsics.areEqual(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null, qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsOptInArgument(PsiElement $this$isUsageAsOptInArgument, BindingContext bindingContext) {
            KtExpression ktExpression = $this$isUsageAsOptInArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsOptInArgument : null;
            PsiElement qualifier = ktExpression != null && (ktExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktExpression)) != null ? (PsiElement)ktExpression : $this$isUsageAsOptInArgument;
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            PsiElement entry = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl = false;
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotation2 = annotationDescriptor;
            boolean bl2 = false;
            if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getOPT_IN_FQ_NAMES(), annotation2.getFqName())) return true;
            if (!Intrinsics.areEqual(annotation2.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) return false;
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public Overrides(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "descriptor.overriddenDescriptors");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor member2 = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(member2, "member");
                Iterable iterable2 = org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, member2, this.moduleAnnotationsResolver, context.getLanguageVersionSettings(), null, false, false, 28, null);
                boolean $i$f$map = false;
                void var16_18 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to(experimentality, member2));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Map experimentalOverridden = MapsKt.toMap((List)destination$iv$iv);
            for (Map.Entry entry : experimentalOverridden.entrySet()) {
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair;
                Experimentality experimentality = (Experimentality)entry.getKey();
                CallableMemberDescriptor member3 = (CallableMemberDescriptor)entry.getValue();
                if (Companion.isExperimentalityAccepted(declaration, experimentality.getAnnotationFqName(), context)) continue;
                PsiElement psiElement = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
                if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
                PsiElement reportOn = psiElement;
                switch (WhenMappings.$EnumSwitchMapping$0[experimentality.getSeverity().ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE, "should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair2 = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)pair2.component1();
                String defaultMessageVerb = (String)pair2.component2();
                String string2 = member3.getContainingDeclaration().getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "member.containingDeclaration.name.asString()");
                String string3 = experimentality.getMessage();
                String string4 = experimentality.getAnnotationFqName().asString();
                Intrinsics.checkNotNullExpressionValue(string4, "experimentality.annotationFqName.asString()");
                String message = OptInNames.INSTANCE.buildOverrideMessage(string2, string3, defaultMessageVerb, string4);
                context.getTrace().report(diagnostic.on(reportOn, experimentality.getAnnotationFqName(), message));
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                nArray[Experimentality.Severity.FUTURE_ERROR.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

