/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BooleanColumnType;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.CompositeColumn;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B/\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0013\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004J+\u0010\u0016\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u0001H\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0004H\u0002\u00a2\u0006\u0002\u0010\u0018J,\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000f0\u00042\u0006\u0010\u001b\u001a\u0002H\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow;", "", "fieldIndex", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "data", "", "(Ljava/util/Map;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "database", "Lorg/jetbrains/exposed/sql/Database;", "getFieldIndex", "()Ljava/util/Map;", "get", "T", "c", "(Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/Object;", "getOrNull", "getRaw", "hasValue", "", "rawToColumnValue", "raw", "(Ljava/lang/Object;Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/Object;)V", "toString", "", "Companion", "NotInitializedValue", "exposed-core"})
public final class ResultRow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Expression<?>, Integer> fieldIndex;
    @NotNull
    private final Object[] data;
    @Nullable
    private final Database database;

    public ResultRow(@NotNull Map<Expression<?>, Integer> fieldIndex, @NotNull Object[] data) {
        Intrinsics.checkNotNullParameter(fieldIndex, (String)"fieldIndex");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.fieldIndex = fieldIndex;
        this.data = data;
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        this.database = transaction2 == null ? null : transaction2.getDb();
    }

    public /* synthetic */ ResultRow(Map map, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectArray = new Object[map.size()];
        }
        this(map, objectArray);
    }

    @NotNull
    public final Map<Expression<?>, Integer> getFieldIndex() {
        return this.fieldIndex;
    }

    public final <T> T get(@NotNull Expression<T> c) {
        T t;
        Intrinsics.checkNotNullParameter(c, (String)"c");
        T d = this.getRaw(c);
        if (d == null && c instanceof Column && ((Column)c).getDbDefaultValue$exposed_core() != null && !((Column)c).getColumnType().getNullable()) {
            SQLLogKt.getExposedLogger().warn("Column " + TransactionManager.Companion.current().fullIdentity((Column)c) + " is marked as not null, has default db value, but returns null. Possible have to re-read it from DB.");
        }
        Database database = this.database;
        if (database == null) {
            t = null;
        } else {
            DatabaseDialect databaseDialect = database.getDialect();
            if (databaseDialect == null) {
                t = null;
            } else {
                DatabaseDialect it = databaseDialect;
                boolean bl = false;
                t = DefaultKt.withDialect(it, (Function0)new Function0<T>(this, d, c){
                    final /* synthetic */ ResultRow this$0;
                    final /* synthetic */ T $d;
                    final /* synthetic */ Expression<T> $c;
                    {
                        this.this$0 = $receiver;
                        this.$d = $d;
                        this.$c = $c;
                        super(0);
                    }

                    public final T invoke() {
                        return (T)ResultRow.access$rawToColumnValue(this.this$0, this.$d, this.$c);
                    }
                });
            }
        }
        T t2 = t;
        return t2 == null ? (T)this.rawToColumnValue(d, c) : t2;
    }

    public final <T> void set(@NotNull Expression<? extends T> c, T value) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Integer n = this.fieldIndex.get(c);
        if (n == null) {
            throw new IllegalStateException((c + " is not in record set").toString());
        }
        int index = n;
        this.data[index] = value;
    }

    public final <T> boolean hasValue(@NotNull Expression<T> c) {
        boolean bl;
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Integer n = this.fieldIndex.get(c);
        if (n == null) {
            bl = false;
        } else {
            boolean bl2;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            bl = bl2 = !Intrinsics.areEqual((Object)this.data[it], (Object)NotInitializedValue.INSTANCE);
        }
        return bl;
    }

    @Nullable
    public final <T> T getOrNull(@NotNull Expression<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this.hasValue(c) ? (T)this.rawToColumnValue(this.getRaw(c), c) : null;
    }

    private final <T> T rawToColumnValue(T raw, Expression<T> c) {
        Object object;
        if (raw == null) {
            object = null;
        } else {
            if (Intrinsics.areEqual(raw, (Object)NotInitializedValue.INSTANCE)) {
                throw new IllegalStateException((c + " is not initialized yet").toString());
            }
            object = c instanceof ExpressionAlias && ((ExpressionAlias)c).getDelegate() instanceof ExpressionWithColumnType ? ((ExpressionWithColumnType)((ExpressionAlias)c).getDelegate()).getColumnType().valueFromDB(raw) : (c instanceof ExpressionWithColumnType ? ((ExpressionWithColumnType)c).getColumnType().valueFromDB(raw) : (c instanceof Op.OpBoolean ? BooleanColumnType.Companion.getINSTANCE$exposed_core().valueFromDB(raw) : (Object)raw));
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T getRaw(Expression<T> c) {
        int n;
        if (c instanceof CompositeColumn) {
            Iterable $this$associateWith$iv = ((CompositeColumn)c).getRealColumns();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                Column column = (Column)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                T t2 = this.getRaw((Expression)it);
                map.put(t, t2);
            }
            Map rawParts = result$iv;
            return ((CompositeColumn)c).restoreValueFromParts(rawParts);
        }
        Integer n2 = this.fieldIndex.get(c);
        if (n2 == null) {
            Integer n3;
            Column column = c instanceof Column ? (Column)c : null;
            Object object = column == null ? null : column.getColumnType();
            EntityIDColumnType entityIDColumnType = object instanceof EntityIDColumnType ? (EntityIDColumnType)object : null;
            if (entityIDColumnType == null) {
                n3 = null;
            } else {
                EntityIDColumnType it = entityIDColumnType;
                boolean bl = false;
                n3 = this.getFieldIndex().get(it.getIdColumn());
            }
            if (n3 == null) {
                Integer n4;
                Object v6;
                block14: {
                    Iterable $this$firstOrNull$iv = this.fieldIndex.keySet();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        Expression exp = (Expression)element$iv;
                        boolean bl2 = false;
                        if (exp instanceof Column) {
                            IColumnType iColumnType = ((Column)exp).getColumnType();
                            EntityIDColumnType entityIDColumnType2 = iColumnType instanceof EntityIDColumnType ? (EntityIDColumnType)iColumnType : null;
                            bl = Intrinsics.areEqual(entityIDColumnType2 == null ? null : entityIDColumnType2.getIdColumn(), c);
                        } else {
                            bl = exp instanceof ExpressionAlias ? Intrinsics.areEqual(((ExpressionAlias)exp).getDelegate(), c) : false;
                        }
                        if (!bl) continue;
                        v6 = element$iv;
                        break block14;
                    }
                    v6 = null;
                }
                object = v6;
                if (object == null) {
                    n4 = null;
                } else {
                    Object it = object;
                    boolean bl = false;
                    n4 = this.getFieldIndex().get(it);
                }
                Integer n5 = n4;
                if (n5 == null) {
                    throw new IllegalStateException((c + " is not in record set").toString());
                }
                n = n5;
            } else {
                n = n3;
            }
        } else {
            n = n2;
        }
        int index = n;
        return (T)this.data[index];
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.fieldIndex.entrySet(), null, null, null, (int)0, null, (Function1)new Function1<Map.Entry<? extends Expression<?>, ? extends Integer>, CharSequence>(this){
            final /* synthetic */ ResultRow this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<? extends Expression<?>, Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return "" + it.getKey() + '=' + ResultRow.access$getData$p(this.this$0)[((Number)it.getValue()).intValue()];
            }
        }, (int)31, null);
    }

    public static final /* synthetic */ Object access$rawToColumnValue(ResultRow $this, Object raw, Expression c) {
        return $this.rawToColumnValue(raw, c);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow$NotInitializedValue;", "", "()V", "exposed-core"})
    public static final class NotInitializedValue {
        @NotNull
        public static final NotInitializedValue INSTANCE = new NotInitializedValue();

        private NotInitializedValue() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rJ \u0010\u000f\u001a\u00020\u00042\u0018\u0010\u0010\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow$Companion;", "", "()V", "create", "Lorg/jetbrains/exposed/sql/ResultRow;", "rs", "Ljava/sql/ResultSet;", "fieldsIndex", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "createAndFillDefaults", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "createAndFillValues", "data", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResultRow create(@NotNull ResultSet rs, @NotNull Map<Expression<?>, Integer> fieldsIndex) {
            ResultRow resultRow;
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            Intrinsics.checkNotNullParameter(fieldsIndex, (String)"fieldsIndex");
            ResultRow $this$create_u24lambda_u2d1 = resultRow = new ResultRow(fieldsIndex, null, 2, null);
            boolean bl = false;
            Map<Expression<?>, Integer> $this$forEach$iv = fieldsIndex;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Expression<?>, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object value;
                Object object;
                Object object2;
                Map.Entry<Expression<?>, Integer> element$iv;
                Map.Entry<Expression<?>, Integer> $dstr$field$index = element$iv = iterator2.next();
                boolean bl2 = false;
                Expression<?> field = $dstr$field$index.getKey();
                int index = ((Number)$dstr$field$index.getValue()).intValue();
                Column column = field instanceof Column ? (Column)field : null;
                if (column == null) {
                    object2 = null;
                } else {
                    IColumnType iColumnType = column.getColumnType();
                    object2 = object = iColumnType == null ? null : iColumnType.readObject(rs, index + 1);
                }
                if (object2 == null) {
                    object = rs.getObject(index + 1);
                }
                ((ResultRow)$this$create_u24lambda_u2d1).data[index] = value = object;
            }
            return resultRow;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ResultRow createAndFillValues(@NotNull Map<Expression<?>, ? extends Object> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            HashMap fieldIndex = new HashMap(data.size());
            Object[] values2 = new Object[data.size()];
            Iterable $this$forEachIndexed$iv = data.entrySet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void columnAndValue;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry = (Map.Entry)item$iv;
                int i = n;
                boolean bl = false;
                Expression column = (Expression)columnAndValue.getKey();
                Object value = columnAndValue.getValue();
                Map map = fieldIndex;
                Integer n2 = i;
                map.put(column, n2);
                values2[i] = value;
            }
            return new ResultRow(fieldIndex, values2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ResultRow createAndFillDefaults(@NotNull List<? extends Column<?>> columns2) {
            ResultRow resultRow;
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)columns2);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                map.put(pair.getFirst(), pair.getSecond());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Object[] objectArray = null;
            Map map = destination$iv$iv;
            ResultRow $this$createAndFillDefaults_u24lambda_u2d5 = resultRow = new ResultRow(map, objectArray, n, defaultConstructorMarker);
            boolean bl = false;
            Iterable $this$forEach$iv = columns2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Column it = (Column)element$iv;
                boolean bl2 = false;
                Expression expression = it;
                Function0 function0 = it.getDefaultValueFun();
                Object object = function0 == null ? null : function0.invoke();
                if (object == null) {
                    object = !it.getColumnType().getNullable() ? NotInitializedValue.INSTANCE : null;
                }
                $this$createAndFillDefaults_u24lambda_u2d5.set(expression, object);
            }
            return resultRow;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

