/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class IdeaNotNullHelper {
    public static boolean removeHardcodedChecks(Statement root, StructMethod mt) {
        boolean checks_removed = false;
        while (IdeaNotNullHelper.findAndRemoveParameterCheck(root, mt)) {
            checks_removed = true;
        }
        while (IdeaNotNullHelper.findAndRemoveReturnCheck(root, mt)) {
            checks_removed = true;
        }
        return checks_removed;
    }

    private static boolean findAndRemoveParameterCheck(Statement stat, StructMethod mt) {
        Statement st = stat.getFirst();
        while (st.type == 15) {
            st = st.getFirst();
        }
        if (st.type == 2) {
            IfStatement ifstat = (IfStatement)st;
            Statement ifbranch = ifstat.getIfstat();
            Exprent if_condition = ifstat.getHeadexprent().getCondition();
            boolean is_notnull_check = false;
            if (ifbranch != null && if_condition.type == 6 && ((FunctionExprent)if_condition).getFuncType() == 42 && ifbranch.type == 8 && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get((int)0).type == 4) {
                FunctionExprent func = (FunctionExprent)if_condition;
                Exprent first_param = func.getLstOperands().get(0);
                Exprent second_param = func.getLstOperands().get(1);
                if (second_param.type == 3 && second_param.getExprType().type == 13 && first_param.type == 12) {
                    VarExprent var = (VarExprent)first_param;
                    boolean thisvar = !mt.hasModifier(8);
                    MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    StructAnnotationParameterAttribute param_annotations = (StructAnnotationParameterAttribute)mt.getAttribute("RuntimeInvisibleParameterAnnotations");
                    if (param_annotations != null) {
                        List<List<AnnotationExprent>> param_annotations_lists = param_annotations.getParamAnnotations();
                        int method_param_number = md.params.length;
                        int index = thisvar ? 1 : 0;
                        for (int i = 0; i < method_param_number; ++i) {
                            if (index == var.getIndex()) {
                                if (param_annotations_lists.size() < method_param_number - i) break;
                                int shift = method_param_number - param_annotations_lists.size();
                                List<AnnotationExprent> annotations = param_annotations_lists.get(i - shift);
                                for (AnnotationExprent ann : annotations) {
                                    if (!ann.getClassName().equals("org/jetbrains/annotations/NotNull")) continue;
                                    is_notnull_check = true;
                                }
                                break;
                            }
                            index += md.params[i].stackSize;
                        }
                    }
                }
            }
            if (!is_notnull_check) {
                return false;
            }
            IdeaNotNullHelper.removeParameterCheck(stat, mt);
            return true;
        }
        return false;
    }

    private static void removeParameterCheck(Statement stat, StructMethod mt) {
        Statement st = stat.getFirst();
        while (st.type == 15) {
            st = st.getFirst();
        }
        IfStatement ifstat = (IfStatement)st;
        if (ifstat.getElsestat() != null) {
            StatEdge ifedge = ifstat.getIfEdge();
            StatEdge elseedge = ifstat.getElseEdge();
            Statement ifbranch = ifstat.getIfstat();
            Statement elsebranch = ifstat.getElsestat();
            ifstat.getFirst().removeSuccessor(ifedge);
            ifstat.getFirst().removeSuccessor(elseedge);
            ifstat.getStats().removeWithKey(ifbranch.id);
            ifstat.getStats().removeWithKey(elsebranch.id);
            if (!ifbranch.getAllSuccessorEdges().isEmpty()) {
                ifbranch.removeSuccessor(ifbranch.getAllSuccessorEdges().get(0));
            }
            ifstat.getParent().replaceStatement(ifstat, elsebranch);
            ifstat.getParent().setAllParent();
        }
    }

    private static boolean findAndRemoveReturnCheck(Statement stat, StructMethod mt) {
        boolean is_notnull_check = false;
        StructAnnotationAttribute attr = (StructAnnotationAttribute)mt.getAttribute("RuntimeInvisibleAnnotations");
        if (attr != null) {
            List<AnnotationExprent> annotations = attr.getAnnotations();
            for (AnnotationExprent ann : annotations) {
                if (!ann.getClassName().equals("org/jetbrains/annotations/NotNull")) continue;
                is_notnull_check = true;
            }
        }
        if (is_notnull_check) {
            return IdeaNotNullHelper.removeReturnCheck(stat, mt);
        }
        return false;
    }

    private static boolean removeReturnCheck(Statement stat, StructMethod mt) {
        Statement ifbranch;
        Exprent exprent_value;
        ExitExprent exit_exprent;
        Exprent exprent;
        Statement parent = stat.getParent();
        if (parent != null && parent.type == 2 && stat.type == 8 && stat.getExprents().size() == 1) {
            exprent = stat.getExprents().get(0);
            if (exprent.type == 4 && (exit_exprent = (ExitExprent)exprent).getExitType() == 0) {
                exprent_value = exit_exprent.getValue();
                IfStatement ifparent = (IfStatement)parent;
                Exprent if_condition = ifparent.getHeadexprent().getCondition();
                if (ifparent.getElsestat() == stat && if_condition.type == 6 && ((FunctionExprent)if_condition).getFuncType() == 42) {
                    FunctionExprent func = (FunctionExprent)if_condition;
                    Exprent first_param = func.getLstOperands().get(0);
                    Exprent second_param = func.getLstOperands().get(1);
                    StatEdge ifedge = ifparent.getIfEdge();
                    StatEdge elseedge = ifparent.getElseEdge();
                    ifbranch = ifparent.getIfstat();
                    Statement elsebranch = ifparent.getElsestat();
                    if (second_param.type == 3 && second_param.getExprType().type == 13 && first_param.equals(exprent_value) && ifbranch.type == 8 && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get((int)0).type == 4) {
                        ifparent.getFirst().removeSuccessor(ifedge);
                        ifparent.getFirst().removeSuccessor(elseedge);
                        ifparent.getStats().removeWithKey(ifbranch.id);
                        ifparent.getStats().removeWithKey(elsebranch.id);
                        if (!ifbranch.getAllSuccessorEdges().isEmpty()) {
                            ifbranch.removeSuccessor(ifbranch.getAllSuccessorEdges().get(0));
                        }
                        if (!ifparent.getFirst().getExprents().isEmpty()) {
                            elsebranch.getExprents().addAll(0, ifparent.getFirst().getExprents());
                        }
                        ifparent.getParent().replaceStatement(ifparent, elsebranch);
                        ifparent.getParent().setAllParent();
                        return true;
                    }
                }
            }
        } else if (parent != null && parent.type == 15 && stat.type == 8 && stat.getExprents().size() == 1) {
            exprent = stat.getExprents().get(0);
            if (exprent.type == 4 && (exit_exprent = (ExitExprent)exprent).getExitType() == 0) {
                exprent_value = exit_exprent.getValue();
                SequenceStatement sequence = (SequenceStatement)parent;
                int sequence_stats_number = sequence.getStats().size();
                if (sequence_stats_number > 1 && sequence.getStats().getLast() == stat && ((Statement)sequence.getStats().get((int)(sequence_stats_number - 2))).type == 2) {
                    IfStatement ifstat = (IfStatement)sequence.getStats().get(sequence_stats_number - 2);
                    Exprent if_condition = ifstat.getHeadexprent().getCondition();
                    if (ifstat.iftype == 0 && if_condition.type == 6 && ((FunctionExprent)if_condition).getFuncType() == 42) {
                        FunctionExprent func = (FunctionExprent)if_condition;
                        Exprent first_param = func.getLstOperands().get(0);
                        Exprent second_param = func.getLstOperands().get(1);
                        ifbranch = ifstat.getIfstat();
                        if (second_param.type == 3 && second_param.getExprType().type == 13 && first_param.equals(exprent_value) && ifbranch.type == 8 && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get((int)0).type == 4) {
                            ifstat.removeSuccessor(ifstat.getAllSuccessorEdges().get(0));
                            if (!ifstat.getFirst().getExprents().isEmpty()) {
                                stat.getExprents().addAll(0, ifstat.getFirst().getExprents());
                            }
                            for (StatEdge edge : ifstat.getAllPredecessorEdges()) {
                                ifstat.removePredecessor(edge);
                                edge.getSource().changeEdgeNode(1, edge, stat);
                                stat.addPredecessor(edge);
                            }
                            sequence.getStats().removeWithKey(ifstat.id);
                            sequence.setFirst((Statement)sequence.getStats().get(0));
                            return true;
                        }
                    }
                }
            }
        }
        for (Statement st : stat.getStats()) {
            if (!IdeaNotNullHelper.removeReturnCheck(st, mt)) continue;
            return true;
        }
        return false;
    }
}

