/*
 * Decompiled with CFR 0.152.
 */
package com.leastfixedpoint.json;

import com.leastfixedpoint.json.JSONReader;
import com.leastfixedpoint.json.JSONSyntaxError;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JSONEventReader {
    protected JSONReader jsonReader;
    protected List<State> stateStack;
    protected State state;

    public JSONEventReader(JSONReader jsonReader) {
        this.jsonReader = jsonReader;
        this.stateStack = new ArrayList<State>();
        this.state = State.GENERAL;
    }

    public Object next() throws IOException {
        block13: while (true) {
            Object token = null;
            try {
                token = this.jsonReader.nextLexeme();
            }
            catch (EOFException e) {
                return null;
            }
            switch (this.state) {
                case GENERAL: {
                    this.maybeEnterNested(token);
                    return token;
                }
                case FIRST_MAP_KEY: {
                    if (token == JSONReader.Lexeme.OBJECT_END) {
                        this.pop();
                        return token;
                    }
                }
                case SUBSEQUENT_MAP_KEY: {
                    if (!(token instanceof String)) {
                        this.jsonReader.expectedMapKey();
                    }
                    this.gotoState(State.MAP_COLON);
                    return token;
                }
                case MAP_COLON: {
                    if (token != JSONReader.Lexeme.COLON) {
                        this.jsonReader.expectedMapColon();
                    }
                    this.gotoState(State.MAP_VALUE);
                    continue block13;
                }
                case MAP_VALUE: {
                    this.gotoState(State.MAP_COMMA_OR_END);
                    this.maybeEnterNested(token);
                    return token;
                }
                case MAP_COMMA_OR_END: {
                    if (token == JSONReader.Lexeme.OBJECT_END) {
                        this.pop();
                        return token;
                    }
                    if (token != JSONReader.Lexeme.COMMA) {
                        this.jsonReader.expectedMapComma();
                    }
                    this.gotoState(State.SUBSEQUENT_MAP_KEY);
                    continue block13;
                }
                case FIRST_ARRAY_VALUE: {
                    if (token == JSONReader.Lexeme.ARRAY_END) {
                        this.pop();
                        return token;
                    }
                }
                case SUBSEQUENT_ARRAY_VALUE: {
                    this.gotoState(State.ARRAY_COMMA_OR_END);
                    this.maybeEnterNested(token);
                    return token;
                }
                case ARRAY_COMMA_OR_END: {
                    if (token == JSONReader.Lexeme.ARRAY_END) {
                        this.pop();
                        return token;
                    }
                    if (token != JSONReader.Lexeme.COMMA) {
                        this.jsonReader.expectedArrayComma();
                    }
                    this.gotoState(State.SUBSEQUENT_ARRAY_VALUE);
                    continue block13;
                }
            }
        }
    }

    public boolean atBoundary() {
        return this.stateStack.size() == 0;
    }

    protected void maybeEnterNested(Object token) throws JSONSyntaxError {
        if (token instanceof JSONReader.Lexeme) {
            switch ((JSONReader.Lexeme)((Object)token)) {
                case OBJECT_START: {
                    this.pushAndGoto(State.FIRST_MAP_KEY);
                    break;
                }
                case ARRAY_START: {
                    this.pushAndGoto(State.FIRST_ARRAY_VALUE);
                    break;
                }
                default: {
                    this.jsonReader.unexpectedLexeme((JSONReader.Lexeme)((Object)token));
                }
            }
        }
    }

    protected void gotoState(State newState) {
        this.state = newState;
    }

    protected void pushAndGoto(State newState) {
        this.stateStack.add(this.state);
        this.state = newState;
    }

    protected void pop() {
        this.state = this.stateStack.remove(this.stateStack.size() - 1);
    }

    protected static enum State {
        GENERAL,
        FIRST_MAP_KEY,
        SUBSEQUENT_MAP_KEY,
        MAP_COLON,
        MAP_VALUE,
        MAP_COMMA_OR_END,
        FIRST_ARRAY_VALUE,
        SUBSEQUENT_ARRAY_VALUE,
        ARRAY_COMMA_OR_END;

    }
}

