/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import java.io.Reader;
import java.nio.CharBuffer;

class CharSequenceReader
extends Reader {
    private static final int CONTEXT = 8;
    private final CharSequence buf;
    private final int length;
    private int off;
    private int mark;

    CharSequenceReader(CharSequence s) {
        this.buf = s;
        this.length = this.buf.length();
    }

    @Override
    public int read() {
        return this.off == this.length ? -1 : (int)this.buf.charAt(this.off++);
    }

    @Override
    public void mark(int limit) {
        this.mark = this.off;
    }

    public int tell() {
        return this.off;
    }

    public int length() {
        return this.length;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(char[] obuf, int ooff, int len) {
        if (this.off == this.length) {
            return -1;
        }
        if (this.off + len > this.length) {
            len = this.length - this.off;
        }
        if (this.buf instanceof String) {
            ((String)this.buf).getChars(this.off, this.off + len, obuf, ooff);
            this.off += len;
        } else if (this.buf instanceof StringBuffer) {
            ((StringBuffer)this.buf).getChars(this.off, this.off + len, obuf, ooff);
            this.off += len;
        } else if (this.buf instanceof StringBuilder) {
            ((StringBuilder)this.buf).getChars(this.off, this.off + len, obuf, ooff);
            this.off += len;
        } else if (this.buf instanceof CharBuffer) {
            ((CharBuffer)this.buf).position(this.off);
            ((CharBuffer)this.buf).get(obuf, ooff, len);
            this.off += len;
        } else {
            while (len-- > 0) {
                obuf[ooff++] = this.buf.charAt(this.off++);
            }
        }
        return len;
    }

    @Override
    public int read(char[] obuf) {
        return this.read(obuf, 0, obuf.length);
    }

    @Override
    public int read(CharBuffer cb) {
        if (this.off == this.length) {
            return -1;
        }
        int len = cb.remaining();
        if (this.off + len > this.length) {
            len = this.length - this.off;
        }
        cb.append(this.buf, this.off, len);
        return len;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        this.off = this.mark;
    }

    @Override
    public long skip(long len) {
        if (len > (long)(this.length - this.off)) {
            len = this.length - this.off;
        }
        this.off = (int)((long)this.off + len);
        return len;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        if (this.off > 8) {
            sb.append("...");
        }
        for (int i = Math.max(0, this.off - 8); i < Math.min(this.length, this.off + 8); ++i) {
            sb.append(this.buf.charAt(i));
        }
        if (this.off + 8 < this.length) {
            sb.append("...");
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public void close() {
    }
}

